/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.api.application;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.api.config.ApplicationConfig;
import org.teamapps.application.api.desktop.ApplicationDesktop;
import org.teamapps.application.api.privilege.CustomObjectPrivilegeGroup;
import org.teamapps.application.api.privilege.OrganizationalPrivilegeGroup;
import org.teamapps.application.api.privilege.Privilege;
import org.teamapps.application.api.privilege.PrivilegeObject;
import org.teamapps.application.api.privilege.SimpleCustomObjectPrivilege;
import org.teamapps.application.api.privilege.SimpleOrganizationalPrivilege;
import org.teamapps.application.api.privilege.SimplePrivilege;
import org.teamapps.application.api.privilege.StandardPrivilegeGroup;
import org.teamapps.application.api.user.SessionUser;
import org.teamapps.icons.Icon;
import org.teamapps.model.controlcenter.OrganizationUnitView;
import org.teamapps.universaldb.index.translation.TranslatableText;
import org.teamapps.ux.application.perspective.Perspective;
import org.teamapps.ux.component.progress.MultiProgressDisplay;
import org.teamapps.ux.session.SessionContext;

public abstract class AbstractApplicationView {
    private final ApplicationInstanceData applicationInstanceData;

    public AbstractApplicationView(ApplicationInstanceData applicationInstanceData) {
        this.applicationInstanceData = applicationInstanceData;
    }

    public ApplicationInstanceData getApplicationInstanceData() {
        return this.applicationInstanceData;
    }

    public SessionContext getContext() {
        return this.applicationInstanceData.getUser().getSessionContext();
    }

    public void writeActivityLog(String title, String data) {
        this.getApplicationInstanceData().writeActivityLog(title, data);
    }

    public void writeExceptionLog(String title, Throwable throwable) {
        this.getApplicationInstanceData().writeExceptionLog(title, throwable);
    }

    public SessionUser getUser() {
        return this.applicationInstanceData.getUser();
    }

    public MultiProgressDisplay getMultiProgressDisplay() {
        return this.applicationInstanceData.getMultiProgressDisplay();
    }

    public <RESULT> void runTaskAsync(Icon icon, String title, Supplier<RESULT> task, Consumer<RESULT> uiResultTask) {
        this.applicationInstanceData.runTaskAsync(icon, title, task, uiResultTask);
    }

    public void showPerspective(Perspective perspective) {
        this.applicationInstanceData.showPerspective(perspective);
    }

    public ApplicationDesktop createApplicationDesktop(Icon icon, String title, boolean select, boolean closable) {
        return this.applicationInstanceData.createApplicationDesktop(icon, title, select, closable);
    }

    public ApplicationConfig<?> getApplicationConfig() {
        return this.applicationInstanceData.getApplicationConfig();
    }

    public String getLocalized(String key, Object ... parameters) {
        return this.applicationInstanceData.getLocalized(key, parameters);
    }

    public String getLocalized(TranslatableText translatableText) {
        return this.applicationInstanceData.getLocalized(translatableText);
    }

    public boolean isAllowed(SimplePrivilege simplePrivilege) {
        return this.applicationInstanceData.isAllowed(simplePrivilege);
    }

    public boolean isAllowed(SimpleOrganizationalPrivilege group, OrganizationUnitView OrganizationUnitView2) {
        return this.applicationInstanceData.isAllowed(group, OrganizationUnitView2);
    }

    public boolean isAllowed(SimpleCustomObjectPrivilege group, PrivilegeObject privilegeObject) {
        return this.applicationInstanceData.isAllowed(group, privilegeObject);
    }

    public boolean isAllowed(StandardPrivilegeGroup group, Privilege privilege) {
        return this.applicationInstanceData.isAllowed(group, privilege);
    }

    public boolean isAllowed(OrganizationalPrivilegeGroup group, Privilege privilege, OrganizationUnitView OrganizationUnitView2) {
        return this.applicationInstanceData.isAllowed(group, privilege, OrganizationUnitView2);
    }

    public boolean isAllowed(CustomObjectPrivilegeGroup group, Privilege privilege, PrivilegeObject privilegeObject) {
        return this.applicationInstanceData.isAllowed(group, privilege, privilegeObject);
    }

    public List<OrganizationUnitView> getAllowedUnits(SimpleOrganizationalPrivilege simplePrivilege) {
        return this.applicationInstanceData.getAllowedUnits(simplePrivilege);
    }

    public List<OrganizationUnitView> getAllowedUnits(OrganizationalPrivilegeGroup group, Privilege privilege) {
        return this.applicationInstanceData.getAllowedUnits(group, privilege);
    }

    public List<PrivilegeObject> getAllowedPrivilegeObjects(SimpleCustomObjectPrivilege simplePrivilege) {
        return this.applicationInstanceData.getAllowedPrivilegeObjects(simplePrivilege);
    }

    public List<PrivilegeObject> getAllowedPrivilegeObjects(CustomObjectPrivilegeGroup group, Privilege privilege) {
        return this.applicationInstanceData.getAllowedPrivilegeObjects(group, privilege);
    }
}

