/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.api.privilege;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.teamapps.application.api.privilege.Privilege;
import org.teamapps.application.api.privilege.PrivilegeGroup;
import org.teamapps.application.api.privilege.PrivilegeObject;
import org.teamapps.icons.Icon;

public abstract class AbstractPrivilegeGroup
implements PrivilegeGroup {
    private final String name;
    private final Icon icon;
    private final String titleKey;
    private final String descriptionKey;
    private final List<Privilege> privileges;
    private Supplier<List<PrivilegeObject>> privilegeObjectsSupplier;

    public AbstractPrivilegeGroup(String name, Icon icon, String titleKey, String descriptionKey) {
        this.name = name;
        this.icon = icon;
        this.titleKey = titleKey;
        this.descriptionKey = descriptionKey;
        this.privileges = Collections.emptyList();
    }

    public AbstractPrivilegeGroup(String name, Icon icon, String titleKey, String descriptionKey, List<Privilege> privileges) {
        this.name = name;
        this.icon = icon;
        this.titleKey = titleKey;
        this.descriptionKey = descriptionKey;
        this.privileges = privileges;
    }

    public AbstractPrivilegeGroup(String name, Icon icon, String titleKey, String descriptionKey, Privilege ... privileges) {
        this.name = name;
        this.icon = icon;
        this.titleKey = titleKey;
        this.descriptionKey = descriptionKey;
        this.privileges = Arrays.asList(privileges);
    }

    public AbstractPrivilegeGroup(String name, Icon icon, String titleKey, String descriptionKey, List<Privilege> privileges, Supplier<List<PrivilegeObject>> privilegeObjectsSupplier) {
        this.name = name;
        this.icon = icon;
        this.titleKey = titleKey;
        this.descriptionKey = descriptionKey;
        this.privileges = privileges;
        this.privilegeObjectsSupplier = privilegeObjectsSupplier;
    }

    public void setPrivilegeObjectsSupplier(Supplier<List<PrivilegeObject>> privilegeObjectsSupplier) {
        this.privilegeObjectsSupplier = privilegeObjectsSupplier;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public String getTitleKey() {
        return this.titleKey;
    }

    @Override
    public String getDescriptionKey() {
        return this.descriptionKey;
    }

    @Override
    public List<Privilege> getPrivileges() {
        return this.privileges;
    }

    @Override
    public Supplier<List<PrivilegeObject>> getPrivilegeObjectsSupplier() {
        return this.privilegeObjectsSupplier;
    }
}

