package org.teamapps.mock.model;

import org.teamapps.universaldb.schema.*;

public class MockSchema implements SchemaInfoProvider {

	public static Schema create() {
		return new MockSchema().getSchema();
	}

	public Schema getSchema() {
		return Schema.parse(getSchemaDefinition());
	}

    public String getSchemaDefinition() {
        return "org.teamapps.mock.model as SCHEMA\n" + 
				"controlCenter as DATABASE\n" + 
				"	organizationUnit as TABLE (TRACK_CREATION, TRACK_MODIFICATION, KEEP_DELETED)\n" + 
				"		metaCreationDate as TIMESTAMP\n" + 
				"		metaCreatedBy as INT\n" + 
				"		metaModificationDate as TIMESTAMP\n" + 
				"		metaModifiedBy as INT\n" + 
				"		metaDeletionDate as TIMESTAMP\n" + 
				"		metaDeletedBy as INT\n" + 
				"		name as TRANSLATABLE_TEXT\n" + 
				"		parent as SINGLE_REFERENCE controlCenter.organizationUnit BACKREF children\n" + 
				"		children as MULTI_REFERENCE controlCenter.organizationUnit BACKREF parent\n" + 
				"		type as SINGLE_REFERENCE controlCenter.organizationUnitType BACKREF NONE\n" + 
				"		icon as TEXT\n" + 
				"		address as SINGLE_REFERENCE controlCenter.address BACKREF NONE\n" + 
				"	organizationUnitType as TABLE (TRACK_CREATION, TRACK_MODIFICATION, KEEP_DELETED)\n" + 
				"		metaCreationDate as TIMESTAMP\n" + 
				"		metaCreatedBy as INT\n" + 
				"		metaModificationDate as TIMESTAMP\n" + 
				"		metaModifiedBy as INT\n" + 
				"		metaDeletionDate as TIMESTAMP\n" + 
				"		metaDeletedBy as INT\n" + 
				"		name as TRANSLATABLE_TEXT\n" + 
				"		abbreviation as TRANSLATABLE_TEXT\n" + 
				"		icon as TEXT\n" + 
				"		translateOrganizationUnits as BOOLEAN\n" + 
				"		allowUserContainer as BOOLEAN\n" + 
				"		defaultChildType as SINGLE_REFERENCE controlCenter.organizationUnitType BACKREF NONE\n" + 
				"		possibleChildrenTypes as MULTI_REFERENCE controlCenter.organizationUnitType BACKREF NONE\n" + 
				"		geoLocationType as ENUM VALUES (country, state, city, place, none)\n" + 
				"	organizationField as TABLE (TRACK_CREATION, TRACK_MODIFICATION, KEEP_DELETED)\n" + 
				"		metaCreationDate as TIMESTAMP\n" + 
				"		metaCreatedBy as INT\n" + 
				"		metaModificationDate as TIMESTAMP\n" + 
				"		metaModifiedBy as INT\n" + 
				"		metaDeletionDate as TIMESTAMP\n" + 
				"		metaDeletedBy as INT\n" + 
				"		title as TRANSLATABLE_TEXT\n" + 
				"		icon as TEXT\n" + 
				"	address as TABLE (TRACK_CREATION, TRACK_MODIFICATION, KEEP_DELETED)\n" + 
				"		metaCreationDate as TIMESTAMP\n" + 
				"		metaCreatedBy as INT\n" + 
				"		metaModificationDate as TIMESTAMP\n" + 
				"		metaModifiedBy as INT\n" + 
				"		metaDeletionDate as TIMESTAMP\n" + 
				"		metaDeletedBy as INT\n" + 
				"		name as TEXT\n" + 
				"		organisation as TEXT\n" + 
				"		street as TEXT\n" + 
				"		city as TEXT\n" + 
				"		dependentLocality as TEXT\n" + 
				"		state as TEXT\n" + 
				"		postalCode as TEXT\n" + 
				"		country as TEXT\n" + 
				"		latitude as FLOAT\n" + 
				"		longitude as FLOAT\n";

    }

}
