package org.teamapps.model.system;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.file.FileValue;
import org.teamapps.universaldb.index.translation.*;
import java.util.*;
import java.time.*;
import java.io.*;
import java.util.function.Supplier;


public interface SystemStarts extends Entity<SystemStarts> {

	final static String FIELD_TIMESTAMP = "timestamp";
	final static String FIELD_TYPE = "type";

    static SystemStarts create() {
        return new UdbSystemStarts();
    }

    static SystemStarts create(int id) {
        return new UdbSystemStarts(id, true);
    }

    static SystemStarts getById(int id) {
        return new UdbSystemStarts(id, false);
    }

    static EntityBuilder<SystemStarts> getBuilder() {
        return new UdbSystemStarts(0, false);
    }

    Instant getTimestamp();

    SystemStarts setTimestamp(Instant value);

    int getTimestampAsEpochSecond();

    SystemStarts setTimestampAsEpochSecond(int value);

    long getTimestampAsEpochMilli();

    SystemStarts setTimestampAsEpochMilli(long value);

    Type getType();

    SystemStarts setType(Type value);


    static List<SystemStarts> getAll() {
        return UdbSystemStarts.getAll();
    }

    static List<SystemStarts> sort(List<SystemStarts> list, String sortFieldName, boolean ascending, String ... path) {
        return UdbSystemStarts.sort(list, sortFieldName, ascending, path);
    }

    static int getCount() {
        return UdbSystemStarts.getCount();
    }

    static SystemStartsQuery filter() {
        return new UdbSystemStartsQuery();
    }
}

