/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.ux.window;

import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.api.theme.ApplicationIcons;
import org.teamapps.icons.Icon;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.toolbar.Toolbar;
import org.teamapps.ux.component.toolbar.ToolbarButton;
import org.teamapps.ux.component.toolbar.ToolbarButtonGroup;
import org.teamapps.ux.component.window.Window;
import org.teamapps.ux.session.SessionContext;

public class ApplicationWindow {
    private final Window window;
    private final ApplicationInstanceData applicationInstanceData;
    private Toolbar toolbar;
    private ToolbarButtonGroup currentButtonGroup;
    private ToolbarButton saveButton;
    private ToolbarButton cancelButton;

    public ApplicationWindow(Icon icon, String title, ApplicationInstanceData applicationInstanceData) {
        this.applicationInstanceData = applicationInstanceData;
        this.window = new Window(icon, title, 800, 600, null);
        this.toolbar = new Toolbar();
        this.window.setToolbar(this.toolbar);
        this.window.setMaximizable(true);
        this.window.setCloseable(true);
        this.window.setCloseOnEscape(true);
        this.currentButtonGroup = this.toolbar.addButtonGroup(new ToolbarButtonGroup());
    }

    public ToolbarButtonGroup addButtonGroup() {
        this.currentButtonGroup = new ToolbarButtonGroup();
        this.toolbar.addButtonGroup(this.currentButtonGroup);
        return this.currentButtonGroup;
    }

    public ToolbarButton addButton(Icon icon, String title) {
        ToolbarButton button = ToolbarButton.createTiny((Icon)icon, (String)title);
        this.currentButtonGroup.addButton(button);
        return button;
    }

    public ToolbarButton addSaveButton() {
        return this.addSaveButton(this.applicationInstanceData.getLocalized("org.teamapps.dictionary.saveClose", new Object[0]), this.applicationInstanceData.getLocalized("org.teamapps.dictionary.saveAndCloseWindow", new Object[0]));
    }

    public ToolbarButton addSaveButton(String title, String description) {
        this.saveButton = ToolbarButton.create((Icon)ApplicationIcons.FLOPPY_DISK, (String)title, (String)description);
        this.currentButtonGroup.addButton(this.saveButton);
        return this.saveButton;
    }

    public ToolbarButton addCancelButton() {
        return this.addCancelButton(this.applicationInstanceData.getLocalized("org.teamapps.dictionary.cancelClose", new Object[0]), this.applicationInstanceData.getLocalized("org.teamapps.dictionary.cancelAndCloseWindow", new Object[0]));
    }

    public ToolbarButton addCancelButton(String title, String description) {
        this.cancelButton = ToolbarButton.create((Icon)ApplicationIcons.ERROR, (String)title, (String)description);
        this.currentButtonGroup.addButton(this.cancelButton);
        this.cancelButton.onClick.addListener(() -> this.window.close());
        return this.cancelButton;
    }

    public void setContent(Component content) {
        this.window.setContent(content);
    }

    public void setWindowRelativeSize(float relativeWidth, float relativeHeight) {
        int windowWidth = (int)Math.max(800.0f, Math.min(1600.0f, (float)SessionContext.current().getClientInfo().getViewPortWidth() * relativeWidth));
        int windowHeight = (int)Math.max(600.0f, Math.min(1200.0f, (float)SessionContext.current().getClientInfo().getScreenHeight() * relativeHeight));
        this.window.setSize(windowWidth, windowHeight);
    }

    public void setWindowPreferredSize(int width, int height, float minRelativeMargin) {
        int windowWidth = (int)Math.min((float)width, (float)SessionContext.current().getClientInfo().getViewPortWidth() * (1.0f - minRelativeMargin));
        int windowHeight = (int)Math.min((float)height, (float)SessionContext.current().getClientInfo().getScreenHeight() * (1.0f - minRelativeMargin));
        this.window.setSize(windowWidth, windowHeight);
    }

    public void setWindowSize(int width, int height) {
        this.window.setSize(width, height);
    }

    public void show() {
        this.window.show(300);
    }

    public void close() {
        this.window.close();
    }

    public ToolbarButtonGroup getCurrentButtonGroup() {
        return this.currentButtonGroup;
    }

    public ToolbarButton getSaveButton() {
        return this.saveButton;
    }

    public ToolbarButton getCancelButton() {
        return this.cancelButton;
    }
}

