/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.tools;

import java.util.List;
import java.util.function.Supplier;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.tools.RecordModelBuilder;
import org.teamapps.udb.filter.TimeIntervalFilter;
import org.teamapps.universaldb.index.IndexType;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.index.numeric.NumericFilter;
import org.teamapps.universaldb.pojo.AbstractUdbQuery;
import org.teamapps.universaldb.pojo.Entity;
import org.teamapps.universaldb.pojo.Query;
import org.teamapps.universaldb.record.EntityBuilder;

public class EntityModelBuilder<ENTITY extends Entity<ENTITY>>
extends RecordModelBuilder<ENTITY> {
    private final Supplier<Query<ENTITY>> querySupplier;
    private final TableIndex tableIndex;
    private final EntityBuilder<ENTITY> entityBuilder;

    public EntityModelBuilder(Supplier<Query<ENTITY>> querySupplier, ApplicationInstanceData applicationInstanceData) {
        super(applicationInstanceData);
        this.querySupplier = querySupplier;
        AbstractUdbQuery udbQuery = (AbstractUdbQuery)querySupplier.get();
        this.tableIndex = udbQuery.getTableIndex();
        this.entityBuilder = udbQuery.getEntityBuilder();
    }

    @Override
    public List<ENTITY> queryRecords(String fullTextQuery, TimeIntervalFilter timeIntervalFilter) {
        AbstractUdbQuery query = (AbstractUdbQuery)this.querySupplier.get();
        if (timeIntervalFilter != null) {
            NumericFilter numericFilter = this.tableIndex.getColumnIndex(timeIntervalFilter.getFieldName()).getType() == IndexType.INT ? timeIntervalFilter.getIntFilter() : timeIntervalFilter.getFilter();
            query.addNumericFilter(timeIntervalFilter.getFieldName(), numericFilter);
        }
        if (fullTextQuery != null && !fullTextQuery.isBlank()) {
            query.addFullTextQuery(fullTextQuery, new String[0]);
        }
        return this.getSortField() != null && this.getCustomFieldSorter() == null ? query.execute(this.getSortField(), this.isSortAscending(), new String[0]) : query.execute();
    }
}

