/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.ux.combo;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.teamapps.application.ux.UiUtils;
import org.teamapps.data.extract.PropertyProvider;
import org.teamapps.ux.component.field.combobox.ComboBox;
import org.teamapps.ux.component.template.Template;
import org.teamapps.ux.model.ComboBoxModel;

public class ComboBoxUtils {
    public static <RECORD> ComboBox<RECORD> createComboBox(ComboBoxModel<RECORD> comboBoxModel, PropertyProvider<RECORD> propertyProvider, Template template) {
        ComboBox comboBox = new ComboBox(template);
        comboBox.setPropertyProvider(propertyProvider);
        Function<Object, String> recordToStringFunction = record -> {
            Map values = propertyProvider.getValues(record, Collections.singleton("caption"));
            Object result = values.get("caption");
            return (String)result;
        };
        comboBox.setRecordToStringFunction(recordToStringFunction);
        comboBox.setModel(comboBoxModel);
        return comboBox;
    }

    public static <RECORD> ComboBox<RECORD> createRecordComboBox(List<RECORD> records, PropertyProvider<RECORD> propertyProvider, Template template) {
        return ComboBoxUtils.createRecordComboBox(() -> records, propertyProvider, template);
    }

    public static <RECORD> ComboBox<RECORD> createRecordComboBox(Supplier<List<RECORD>> records, PropertyProvider<RECORD> propertyProvider, Template template) {
        ComboBox comboBox = new ComboBox(template);
        comboBox.setPropertyProvider(propertyProvider);
        Function recordToStringFunction = UiUtils.createRecordToStringFunction(propertyProvider);
        comboBox.setRecordToStringFunction(recordToStringFunction);
        comboBox.setModel(query -> query == null || query.isBlank() ? (List)records.get() : ((List)records.get()).stream().filter(record -> ((String)recordToStringFunction.apply(record)).toLowerCase().contains(query.toLowerCase())).collect(Collectors.toList()));
        return comboBox;
    }

    public static <RECORD> ComboBoxModel<RECORD> createComboBoxModel(Supplier<List<RECORD>> recordSupplier, PropertyProvider<RECORD> propertyProvider, int limit, String ... properties) {
        BiFunction recordFilterFunction = UiUtils.createRecordFilterFunction(propertyProvider, properties);
        return query -> {
            List records = (List)recordSupplier.get();
            return records != null ? records.stream().filter(record -> (Boolean)recordFilterFunction.apply(record, query)).limit(limit).collect(Collectors.toList()) : Collections.emptyList();
        };
    }
}

