package org.teamapps.mock.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.file.FileValue;
import org.teamapps.universaldb.index.translation.*;
import java.util.*;
import java.time.*;
import java.io.*;
import java.util.function.Supplier;


public interface Address extends Entity<Address> {

	final static String FIELD_META_CREATION_DATE = "metaCreationDate";
	final static String FIELD_META_CREATED_BY = "metaCreatedBy";
	final static String FIELD_META_MODIFICATION_DATE = "metaModificationDate";
	final static String FIELD_META_MODIFIED_BY = "metaModifiedBy";
	final static String FIELD_META_DELETION_DATE = "metaDeletionDate";
	final static String FIELD_META_DELETED_BY = "metaDeletedBy";
	final static String FIELD_NAME = "name";
	final static String FIELD_ORGANISATION = "organisation";
	final static String FIELD_STREET = "street";
	final static String FIELD_CITY = "city";
	final static String FIELD_DEPENDENT_LOCALITY = "dependentLocality";
	final static String FIELD_STATE = "state";
	final static String FIELD_POSTAL_CODE = "postalCode";
	final static String FIELD_COUNTRY = "country";
	final static String FIELD_LATITUDE = "latitude";
	final static String FIELD_LONGITUDE = "longitude";

    static Address create() {
        return new UdbAddress();
    }

    static Address create(int id) {
        return new UdbAddress(id, true);
    }

    static Address getById(int id) {
        return new UdbAddress(id, false);
    }

    static EntityBuilder<Address> getBuilder() {
        return new UdbAddress(0, false);
    }

    Instant getMetaCreationDate();

    Address setMetaCreationDate(Instant value);

    int getMetaCreationDateAsEpochSecond();

    Address setMetaCreationDateAsEpochSecond(int value);

    long getMetaCreationDateAsEpochMilli();

    Address setMetaCreationDateAsEpochMilli(long value);

    int getMetaCreatedBy();

    Address setMetaCreatedBy(int value);

    Instant getMetaModificationDate();

    Address setMetaModificationDate(Instant value);

    int getMetaModificationDateAsEpochSecond();

    Address setMetaModificationDateAsEpochSecond(int value);

    long getMetaModificationDateAsEpochMilli();

    Address setMetaModificationDateAsEpochMilli(long value);

    int getMetaModifiedBy();

    Address setMetaModifiedBy(int value);

    Instant getMetaDeletionDate();

    Address setMetaDeletionDate(Instant value);

    int getMetaDeletionDateAsEpochSecond();

    Address setMetaDeletionDateAsEpochSecond(int value);

    long getMetaDeletionDateAsEpochMilli();

    Address setMetaDeletionDateAsEpochMilli(long value);

    int getMetaDeletedBy();

    Address setMetaDeletedBy(int value);

    String getName();

    Address setName(String value);

    String getOrganisation();

    Address setOrganisation(String value);

    String getStreet();

    Address setStreet(String value);

    String getCity();

    Address setCity(String value);

    String getDependentLocality();

    Address setDependentLocality(String value);

    String getState();

    Address setState(String value);

    String getPostalCode();

    Address setPostalCode(String value);

    String getCountry();

    Address setCountry(String value);

    float getLatitude();

    Address setLatitude(float value);

    float getLongitude();

    Address setLongitude(float value);


    static List<Address> getAll() {
        return UdbAddress.getAll();
    }

    static List<Address> sort(List<Address> list, String sortFieldName, boolean ascending, String ... path) {
        return UdbAddress.sort(list, sortFieldName, ascending, path);
    }

    static int getCount() {
        return UdbAddress.getCount();
    }

    static AddressQuery filter() {
        return new UdbAddressQuery();
    }
}

