/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.ux;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.api.theme.ApplicationIcons;
import org.teamapps.data.extract.PropertyProvider;
import org.teamapps.icons.Icon;
import org.teamapps.ux.component.field.DisplayField;
import org.teamapps.ux.component.field.FieldEditingMode;
import org.teamapps.ux.component.field.TemplateField;
import org.teamapps.ux.component.field.TextField;
import org.teamapps.ux.component.field.combobox.TagBoxWrappingMode;
import org.teamapps.ux.component.field.combobox.TagComboBox;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.Template;
import org.teamapps.ux.session.SessionContext;

public class UiUtils {
    public static void showNotification(Icon icon, String title) {
        SessionContext.current().showNotification(icon, title);
    }

    public static void showSaveNotification(boolean success, ApplicationInstanceData applicationInstanceData) {
        SessionContext.current().showNotification(success ? ApplicationIcons.OK : ApplicationIcons.ERROR, success ? applicationInstanceData.getLocalized("org.teamapps.dictionary.recordSuccessfullySaved", new Object[0]) : applicationInstanceData.getLocalized("org.teamapps.dictionary.errorWhenSaving", new Object[0]));
    }

    public static <TYPE> TemplateField<TYPE> createTemplateField(Template template, PropertyProvider<TYPE> propertyProvider) {
        TemplateField templateField = new TemplateField(template);
        templateField.setPropertyProvider(propertyProvider);
        return templateField;
    }

    public static TemplateField<Boolean> createBooleanTemplateField(Icon trueIcon, String trueTitle, Icon falseIcon, String falseTitle) {
        TemplateField templateField = new TemplateField((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE);
        templateField.setPropertyExtractor((value, propertyName) -> switch (propertyName) {
            case "icon" -> {
                if (value.booleanValue()) {
                    yield trueIcon;
                }
                yield falseIcon;
            }
            case "caption" -> {
                if (value.booleanValue()) {
                    yield trueTitle;
                }
                yield falseTitle;
            }
            default -> null;
        });
        return templateField;
    }

    public static TemplateField<String> createIconFixedIconTemplateField(Icon icon) {
        TemplateField templateField = new TemplateField((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE);
        templateField.setPropertyExtractor((value, propertyName) -> switch (propertyName) {
            case "icon" -> icon;
            case "caption" -> value;
            default -> null;
        });
        return templateField;
    }

    public static TemplateField<String> createSingleValueTemplateField(Icon icon, String title) {
        TemplateField templateField = new TemplateField((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE);
        templateField.setPropertyExtractor((value, propertyName) -> switch (propertyName) {
            case "icon" -> icon;
            case "caption" -> title;
            default -> null;
        });
        templateField.setValue((Object)title);
        return templateField;
    }

    public static TextField createSingleValueTextField(String value) {
        TextField textField = new TextField();
        textField.setValue((Object)value);
        textField.setEditingMode(FieldEditingMode.READONLY);
        return textField;
    }

    public static DisplayField createSingleValueDisplayField(String html) {
        DisplayField displayField = new DisplayField(false, true);
        displayField.setValue((Object)html);
        return displayField;
    }

    public static TagComboBox<String> createSingleValueTagComboBox(Icon icon, List<String> values) {
        TagComboBox tagComboBox = new TagComboBox((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE);
        tagComboBox.setValue(values);
        tagComboBox.setPropertyExtractor((s, propertyName) -> switch (propertyName) {
            case "icon" -> icon;
            case "caption" -> s;
            default -> null;
        });
        tagComboBox.setEditingMode(FieldEditingMode.READONLY);
        return tagComboBox;
    }

    public static <TYPE> TagComboBox<TYPE> createTagComboBox(Template template, PropertyProvider<TYPE> propertyProvider) {
        TagComboBox tagComboBox = new TagComboBox(template);
        tagComboBox.setWrappingMode(TagBoxWrappingMode.SINGLE_TAG_PER_LINE);
        tagComboBox.setPropertyProvider(propertyProvider);
        return tagComboBox;
    }

    public static <RECORD> Function<RECORD, String> createRecordQueryStringFunction(PropertyProvider<RECORD> propertyProvider, String ... properties) {
        HashSet<String> keys = properties != null && properties.length > 0 ? new HashSet<String>(Arrays.asList(properties)) : new HashSet<String>(Arrays.asList("caption"));
        return record -> {
            Map values = propertyProvider.getValues(record, (Collection)keys);
            return values.entrySet().stream().filter(entry -> keys.contains(entry.getKey())).map(Map.Entry::getValue).filter(Objects::nonNull).map(v -> (String)v).collect(Collectors.joining(", ")).toLowerCase();
        };
    }

    public static <RECORD> Function<RECORD, String> createRecordToStringFunction(PropertyProvider<RECORD> propertyProvider) {
        return UiUtils.createRecordToStringFunction(propertyProvider, "caption");
    }

    public static <RECORD> Function<RECORD, String> createRecordToStringFunction(PropertyProvider<RECORD> propertyProvider, String property) {
        return record -> {
            Object value = propertyProvider.getValues(record, Collections.singleton(property)).get(property);
            return value != null ? (String)value : "";
        };
    }

    public static <RECORD> BiFunction<RECORD, String, Boolean> createRecordFilterFunction(PropertyProvider<RECORD> propertyProvider, String ... properties) {
        Function queryStringFunction = UiUtils.createRecordQueryStringFunction(propertyProvider, properties);
        return (record, s) -> s == null || s.isBlank() || ((String)queryStringFunction.apply(record)).contains(s.toLowerCase());
    }
}

