package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.file.FileValue;
import org.teamapps.universaldb.index.translation.*;
import java.util.*;
import java.time.*;
import java.io.*;
import java.util.function.Supplier;


public interface AddressView extends Entity<AddressView> {

	final static String FIELD_NAME = "name";
	final static String FIELD_ORGANISATION = "organisation";
	final static String FIELD_STREET = "street";
	final static String FIELD_CITY = "city";
	final static String FIELD_DEPENDENT_LOCALITY = "dependentLocality";
	final static String FIELD_STATE = "state";
	final static String FIELD_POSTAL_CODE = "postalCode";
	final static String FIELD_COUNTRY = "country";
	final static String FIELD_LATITUDE = "latitude";
	final static String FIELD_LONGITUDE = "longitude";

    static AddressView getById(int id) {
        return new UdbAddressView(id, false);
    }

    static EntityBuilder<AddressView> getBuilder() {
        return new UdbAddressView(0, false);
    }

    String getName();

    String getOrganisation();

    String getStreet();

    String getCity();

    String getDependentLocality();

    String getState();

    String getPostalCode();

    String getCountry();

    float getLatitude();

    float getLongitude();


    static List<AddressView> getAll() {
        return UdbAddressView.getAll();
    }

    static List<AddressView> sort(List<AddressView> list, String sortFieldName, boolean ascending, String ... path) {
        return UdbAddressView.sort(list, sortFieldName, ascending, path);
    }

    static int getCount() {
        return UdbAddressView.getCount();
    }

    static AddressViewQuery filter() {
        return new UdbAddressViewQuery();
    }
}

