/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.tools;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.api.theme.ApplicationIcons;
import org.teamapps.common.format.Color;
import org.teamapps.common.format.RgbaColor;
import org.teamapps.data.extract.PropertyProvider;
import org.teamapps.data.value.SortDirection;
import org.teamapps.data.value.Sorting;
import org.teamapps.databinding.TwoWayBindableValue;
import org.teamapps.dto.UiCommand;
import org.teamapps.dto.UiTimeGraph;
import org.teamapps.event.Event;
import org.teamapps.udb.filter.TimeIntervalFilter;
import org.teamapps.ux.application.view.View;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.TemplateField;
import org.teamapps.ux.component.field.TextField;
import org.teamapps.ux.component.infiniteitemview.AbstractInfiniteItemViewModel;
import org.teamapps.ux.component.infiniteitemview.InfiniteItemView2;
import org.teamapps.ux.component.infiniteitemview.InfiniteItemViewModel;
import org.teamapps.ux.component.table.AbstractTableModel;
import org.teamapps.ux.component.table.Table;
import org.teamapps.ux.component.table.TableColumn;
import org.teamapps.ux.component.table.TableModel;
import org.teamapps.ux.component.template.Template;
import org.teamapps.ux.component.timegraph.AbstractLineChartDataDisplay;
import org.teamapps.ux.component.timegraph.Interval;
import org.teamapps.ux.component.timegraph.LineChartCurveType;
import org.teamapps.ux.component.timegraph.LineChartLine;
import org.teamapps.ux.component.timegraph.LineChartYScaleZoomMode;
import org.teamapps.ux.component.timegraph.ScaleType;
import org.teamapps.ux.component.timegraph.TimeGraph;
import org.teamapps.ux.component.timegraph.TimeGraphModel;
import org.teamapps.ux.component.timegraph.partitioning.PartitioningTimeGraphModel;
import org.teamapps.ux.component.timegraph.partitioning.RawTimedDataModel;
import org.teamapps.ux.component.timegraph.partitioning.StaticRawTimedDataModel;
import org.teamapps.ux.component.tree.Tree;
import org.teamapps.ux.component.tree.TreeNodeInfo;
import org.teamapps.ux.component.tree.TreeNodeInfoImpl;
import org.teamapps.ux.model.AbstractTreeModel;
import org.teamapps.ux.model.TreeModel;
import org.teamapps.ux.session.SessionContext;

public abstract class RecordModelBuilder<RECORD> {
    public Event<Void> onDataChanged = new Event();
    public Event<RECORD> onSelectedRecordChanged = new Event();
    private final ApplicationInstanceData applicationInstanceData;
    private TimeIntervalFilter timeIntervalFilter;
    private String fullTextQuery;
    private String sortField;
    private boolean sortAscending;
    private Predicate<RECORD> customFilter;
    private Function<String, Comparator<RECORD>> customFieldSorter;
    private BiFunction<RECORD, String, Boolean> customFullTextFilter;
    private int countRecords;
    private List<RECORD> records;
    private TwoWayBindableValue<RECORD> selectedRecord = TwoWayBindableValue.create();
    private TwoWayBindableValue<Integer> selectedRecordPosition = TwoWayBindableValue.create();

    public RecordModelBuilder(ApplicationInstanceData applicationInstanceData) {
        this.applicationInstanceData = applicationInstanceData;
        this.onDataChanged.addListener(this::queryRecords);
        this.onSelectedRecordChanged.addListener(record -> this.selectedRecord.set(record));
    }

    public void setSelectedRecord(RECORD record) {
        this.onSelectedRecordChanged.fire(record);
    }

    public RECORD getSelectedRecord() {
        return (RECORD)this.selectedRecord.get();
    }

    public boolean selectPreviousRecord() {
        int recordPosition;
        if (this.countRecords == 0) {
            return false;
        }
        Object selectedRecord = this.selectedRecord.get();
        if (selectedRecord == null) {
            selectedRecord = this.records.get(0);
            this.selectedRecordPosition.set((Object)0);
            this.onSelectedRecordChanged.fire(selectedRecord);
        }
        if ((recordPosition = this.findRecordPosition(selectedRecord)) <= 0) {
            return false;
        }
        RECORD record = this.records.get(--recordPosition);
        this.selectedRecordPosition.set((Object)recordPosition);
        this.onSelectedRecordChanged.fire(record);
        return true;
    }

    public boolean selectNextRecord() {
        int recordPosition;
        if (this.countRecords == 0) {
            return false;
        }
        Object selectedRecord = this.selectedRecord.get();
        if (selectedRecord == null) {
            selectedRecord = this.records.get(0);
            this.selectedRecordPosition.set((Object)0);
            this.onSelectedRecordChanged.fire(selectedRecord);
        }
        if ((recordPosition = this.findRecordPosition(selectedRecord)) < 0) {
            return false;
        }
        if (++recordPosition >= this.records.size()) {
            return false;
        }
        RECORD record = this.records.get(recordPosition);
        this.selectedRecordPosition.set((Object)recordPosition);
        this.onSelectedRecordChanged.fire(record);
        return true;
    }

    private int findRecordPosition(RECORD record) {
        if (record == null) {
            return -1;
        }
        Integer position = (Integer)this.selectedRecordPosition.get();
        if (position != null && position < this.countRecords && this.records.get(position).equals(record)) {
            return position;
        }
        for (int i = 0; i < this.records.size(); ++i) {
            if (!record.equals(this.records.get(i))) continue;
            return i;
        }
        return -1;
    }

    public void updateModels() {
        this.onDataChanged.fire();
    }

    public void attachViewCountHandler(View view, Supplier<String> titleSupplier) {
        this.onDataChanged.addListener(() -> view.getPanel().setTitle((String)titleSupplier.get() + " (" + this.countRecords + ")"));
    }

    public void attachSearchField(View view) {
        TextField searchField = this.createSearchField();
        view.getPanel().setRightHeaderField((AbstractField)searchField);
        view.getPanel().setRightHeaderFieldIcon(ApplicationIcons.FUNNEL);
    }

    public TextField createSearchField() {
        TextField searchField = new TextField();
        searchField.setEmptyText(this.applicationInstanceData.getLocalized("org.teamapps.dictionary.search___", new Object[0]));
        searchField.setShowClearButton(true);
        searchField.onTextInput.addListener(this::setFullTextQuery);
        return searchField;
    }

    public TableModel<RECORD> createTableModel() {
        AbstractTableModel model = new AbstractTableModel<RECORD>(){

            public int getCount() {
                return RecordModelBuilder.this.countRecords;
            }

            public List<RECORD> getRecords(int startIndex, int length, Sorting sorting) {
                return RecordModelBuilder.this.records == null ? Collections.emptyList() : RecordModelBuilder.this.records.stream().skip(startIndex).limit(length).collect(Collectors.toList());
            }
        };
        this.onDataChanged.addListener(() -> ((Event)model.onAllDataChanged).fire());
        return model;
    }

    public Table<RECORD> createTable() {
        Table table = new Table();
        table.setModel(this.createTableModel());
        table.onSortingChanged.addListener(event -> this.setSorting(event.getSortField(), event.getSortDirection() == SortDirection.ASC));
        table.onRowSelected.addListener(record -> this.onSelectedRecordChanged.fire(record));
        return table;
    }

    public Table<RECORD> createTemplateFieldTableList(Template template, PropertyProvider<RECORD> propertyProvider, int rowHeight) {
        Table<RECORD> table = this.createTable();
        table.setDisplayAsList(true);
        table.setForceFitWidth(true);
        table.setRowHeight(rowHeight);
        table.setHideHeaders(true);
        table.setStripedRows(false);
        TemplateField templateField = new TemplateField(template);
        templateField.setPropertyProvider(propertyProvider);
        table.addColumn(new TableColumn("data", (AbstractField)templateField));
        table.setPropertyExtractor((record, propertyName) -> record);
        table.onRowSelected.addListener(record -> this.onSelectedRecordChanged.fire(record));
        return table;
    }

    public InfiniteItemViewModel<RECORD> createInfiniteItemViewModel() {
        AbstractInfiniteItemViewModel model = new AbstractInfiniteItemViewModel<RECORD>(){

            public int getCount() {
                return RecordModelBuilder.this.countRecords;
            }

            public List<RECORD> getRecords(int startIndex, int length) {
                return RecordModelBuilder.this.records == null ? Collections.emptyList() : RecordModelBuilder.this.records.stream().skip(startIndex).limit(length).collect(Collectors.toList());
            }
        };
        this.onDataChanged.addListener(() -> RecordModelBuilder.lambda$createInfiniteItemViewModel$6((InfiniteItemViewModel)model));
        return model;
    }

    public InfiniteItemView2<RECORD> createItemView2(Template template, float itemWidth, int itemHeight) {
        InfiniteItemView2 itemView = new InfiniteItemView2(template, itemWidth, itemHeight);
        itemView.setModel(this.createInfiniteItemViewModel());
        itemView.onItemClicked.addListener(record -> this.onSelectedRecordChanged.fire(record.getRecord()));
        return itemView;
    }

    public TimeGraphModel createTimeGraphModel(Function<RECORD, Long> recordTimeFunction, String seriesId) {
        StaticRawTimedDataModel delegationModel = new StaticRawTimedDataModel();
        PartitioningTimeGraphModel timeGraphModel = new PartitioningTimeGraphModel(SessionContext.current().getTimeZone(), (RawTimedDataModel)delegationModel){

            public Interval getDomainX(Collection<String> dataSeriesId) {
                Interval domainX = super.getDomainX(dataSeriesId);
                long diff = (domainX.getMax() - domainX.getMin()) / 20L;
                return new Interval(domainX.getMin() - diff, domainX.getMax() + diff);
            }
        };
        this.onDataChanged.addListener(() -> {
            long[] data = new long[this.records.size()];
            for (int i = 0; i < this.records.size(); ++i) {
                data[i] = (Long)recordTimeFunction.apply(this.records.get(i));
            }
            delegationModel.setEventTimestampsForDataSeriesIds(seriesId, data);
        });
        return timeGraphModel;
    }

    public TimeGraph createTimeGraph(Function<RECORD, Long> recordTimeFunction, String fieldName) {
        RgbaColor color = Color.MATERIAL_BLUE_700;
        return this.createTimeGraph(recordTimeFunction, fieldName, color);
    }

    public TimeGraph createTimeGraph(Function<RECORD, Long> recordTimeFunction, String fieldName, RgbaColor color) {
        LineChartLine line = this.createTimeGraphLine(fieldName, color);
        TimeGraphModel timeGraphModel = this.createTimeGraphModel(recordTimeFunction, fieldName);
        TimeGraph timeGraph = new TimeGraph(timeGraphModel);
        timeGraph.addLine((AbstractLineChartDataDisplay)line);
        timeGraph.onIntervalSelected.addListener(interval -> {
            this.setTimeIntervalFilter(interval != null ? new TimeIntervalFilter(fieldName, interval.getMin(), interval.getMax()) : null);
            SessionContext.current().queueCommand((UiCommand)new UiTimeGraph.SetSelectedIntervalCommand(timeGraph.getId(), null));
        });
        timeGraph.setSelectedInterval(null);
        return timeGraph;
    }

    private LineChartLine createTimeGraphLine(String fieldName, RgbaColor color) {
        LineChartLine line = new LineChartLine(fieldName, LineChartCurveType.MONOTONE, 0.5f, (Color)color, (Color)color.withAlpha(0.05f));
        line.setAreaColorScaleMin((Color)color.withAlpha(0.05f));
        line.setAreaColorScaleMax((Color)color.withAlpha(0.5f));
        line.setYScaleType(ScaleType.LINEAR);
        line.setYScaleZoomMode(LineChartYScaleZoomMode.DYNAMIC_INCLUDING_ZERO);
        return line;
    }

    public TreeModel<RECORD> createTreeModel(final Function<RECORD, RECORD> parentRecordFunction, final Function<RECORD, Boolean> expandedFunction) {
        AbstractTreeModel treeModel = new AbstractTreeModel<RECORD>(){

            public TreeNodeInfo getTreeNodeInfo(RECORD record) {
                return new TreeNodeInfoImpl(parentRecordFunction.apply(record), expandedFunction != null ? (Boolean)expandedFunction.apply(record) : false);
            }

            public List<RECORD> getRecords() {
                return RecordModelBuilder.this.records;
            }
        };
        this.onDataChanged.addListener(() -> ((Event)treeModel.onAllNodesChanged).fire());
        return treeModel;
    }

    public Tree<RECORD> createTree(Template template, PropertyProvider<RECORD> propertyProvider, Function<RECORD, RECORD> parentRecordFunction, Function<RECORD, Boolean> expandedFunction) {
        Tree tree = new Tree(this.createTreeModel(parentRecordFunction, expandedFunction));
        tree.setEntryTemplate(template);
        tree.setOpenOnSelection(true);
        tree.setPropertyProvider(propertyProvider);
        tree.onNodeSelected.addListener(record -> this.onSelectedRecordChanged.fire(record));
        return tree;
    }

    public void setFullTextQuery(String query) {
        this.fullTextQuery = query;
        this.onDataChanged.fire();
    }

    public void removeFullTextQuery() {
        if (this.fullTextQuery != null) {
            this.fullTextQuery = null;
            this.onDataChanged.fire();
        }
    }

    public void setSorting(String sortField, boolean sortAscending) {
        this.sortField = sortField;
        this.sortAscending = sortAscending;
        this.onDataChanged.fire();
    }

    public String getSortField() {
        return this.sortField;
    }

    public boolean isSortAscending() {
        return this.sortAscending;
    }

    public void removeSorting() {
        if (this.sortField != null) {
            this.sortField = null;
            this.onDataChanged.fire();
        }
    }

    public void setTimeIntervalFilter(String fieldName, long start, long end) {
        TimeIntervalFilter timeIntervalFilter = fieldName != null ? new TimeIntervalFilter(fieldName, start, end) : null;
        this.setTimeIntervalFilter(timeIntervalFilter);
    }

    public void setTimeIntervalFilter(TimeIntervalFilter timeIntervalFilter) {
        this.timeIntervalFilter = timeIntervalFilter;
        this.onDataChanged.fire();
    }

    public void removeTimeIntervalFilter() {
        if (this.timeIntervalFilter != null) {
            this.timeIntervalFilter = null;
            this.onDataChanged.fire();
        }
    }

    public void setCustomFilter(Predicate<RECORD> customFilter) {
        this.customFilter = customFilter;
        this.onDataChanged.fire();
    }

    public void removeCustomFilter() {
        this.customFilter = null;
        this.onDataChanged.fire();
    }

    public void setCustomFieldSorter(Function<String, Comparator<RECORD>> customFieldSorter) {
        this.customFieldSorter = customFieldSorter;
    }

    public void removeCustomFieldSorter() {
        this.customFieldSorter = null;
    }

    public Function<String, Comparator<RECORD>> getCustomFieldSorter() {
        return this.customFieldSorter;
    }

    public BiFunction<RECORD, String, Boolean> getCustomFullTextFilter() {
        return this.customFullTextFilter;
    }

    public void setCustomFullTextFilter(BiFunction<RECORD, String, Boolean> customFullTextFilter) {
        this.customFullTextFilter = customFullTextFilter;
    }

    private Comparator<RECORD> getQuerySorter() {
        if (this.sortField == null || this.customFieldSorter == null) {
            return null;
        }
        Comparator<RECORD> comparator = this.customFieldSorter.apply(this.sortField);
        return comparator == null || this.sortAscending ? comparator : comparator.reversed();
    }

    private void queryRecords() {
        Comparator<RECORD> sorter;
        List<Object> result = this.queryRecords(this.fullTextQuery, this.timeIntervalFilter);
        if (this.customFilter != null) {
            result = result.stream().filter(record -> this.customFilter.test(record)).collect(Collectors.toList());
        }
        if ((sorter = this.getQuerySorter()) != null) {
            result = result.stream().sorted(sorter).collect(Collectors.toList());
        }
        this.records = result;
        this.countRecords = this.records.size();
    }

    public abstract List<RECORD> queryRecords(String var1, TimeIntervalFilter var2);

    private static /* synthetic */ void lambda$createInfiniteItemViewModel$6(InfiniteItemViewModel model) {
        model.onAllDataChanged().fire();
    }
}

