package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.file.FileValue;
import org.teamapps.universaldb.index.translation.*;
import java.util.*;
import java.time.*;
import java.io.*;
import java.util.function.Supplier;


public interface OrganizationFieldView extends Entity<OrganizationFieldView> {

	final static String FIELD_TITLE = "title";
	final static String FIELD_ICON = "icon";

    static OrganizationFieldView getById(int id) {
        return new UdbOrganizationFieldView(id, false);
    }

    static EntityBuilder<OrganizationFieldView> getBuilder() {
        return new UdbOrganizationFieldView(0, false);
    }

    TranslatableText getTitle();

    String getIcon();


    static List<OrganizationFieldView> getAll() {
        return UdbOrganizationFieldView.getAll();
    }

    static List<OrganizationFieldView> sort(List<OrganizationFieldView> list, String sortFieldName, boolean ascending, String ... path) {
        return UdbOrganizationFieldView.sort(list, sortFieldName, ascending, path);
    }

    static int getCount() {
        return UdbOrganizationFieldView.getCount();
    }

    static OrganizationFieldViewQuery filter() {
        return new UdbOrganizationFieldViewQuery();
    }
}

