package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.reference.value.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.query.*;


import java.util.*;
import java.util.function.Function;


public interface OrganizationUnitViewQuery extends Query<OrganizationUnitView> {

    static OrganizationUnitViewQuery create() {
        return new UdbOrganizationUnitViewQuery();
    }

    OrganizationUnitViewQuery fullTextFilter(TextFilter textFilter, String... fieldNames);

    OrganizationUnitViewQuery parseFullTextFilter(String query, String... fieldNames);

	OrganizationUnitViewQuery name(TranslatableTextFilter filter);

	OrganizationUnitViewQuery orName(TranslatableTextFilter filter);

	OrganizationUnitViewQuery filterParent(OrganizationUnitViewQuery query);

	OrganizationUnitViewQuery parent(NumericFilter filter);

	OrganizationUnitViewQuery orParent(NumericFilter filter);

	OrganizationUnitViewQuery filterChildren(OrganizationUnitViewQuery query);

	OrganizationUnitViewQuery children(MultiReferenceFilterType type, OrganizationUnitView ... value);

	OrganizationUnitViewQuery childrenCount(MultiReferenceFilterType type, int count);

	OrganizationUnitViewQuery children(MultiReferenceFilter filter);

	OrganizationUnitViewQuery orChildren(MultiReferenceFilter filter);

	OrganizationUnitViewQuery filterType(OrganizationUnitTypeViewQuery query);

	OrganizationUnitViewQuery type(NumericFilter filter);

	OrganizationUnitViewQuery orType(NumericFilter filter);

	OrganizationUnitViewQuery icon(TextFilter filter);

	OrganizationUnitViewQuery orIcon(TextFilter filter);

	OrganizationUnitViewQuery filterAddress(AddressViewQuery query);

	OrganizationUnitViewQuery address(NumericFilter filter);

	OrganizationUnitViewQuery orAddress(NumericFilter filter);


    OrganizationUnitViewQuery andOr(OrganizationUnitViewQuery... queries);

    OrganizationUnitViewQuery customFilter(Function<OrganizationUnitView, Boolean> customFilter);

    List<OrganizationUnitView> execute();

    OrganizationUnitView executeExpectSingleton();

    BitSet executeToBitSet();

    List<OrganizationUnitView> execute(String sortFieldName, boolean ascending, String ... path);

    List<OrganizationUnitView> execute(int startIndex, int length, Sorting sorting);

}

