/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.ux.form;

import java.time.Instant;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.api.theme.ApplicationIcons;
import org.teamapps.application.api.ui.FormMetaFields;
import org.teamapps.icons.Icon;
import org.teamapps.universaldb.index.ColumnIndex;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.index.numeric.IntegerIndex;
import org.teamapps.universaldb.pojo.AbstractUdbEntity;
import org.teamapps.universaldb.pojo.Entity;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.FieldEditingMode;
import org.teamapps.ux.component.field.TemplateField;
import org.teamapps.ux.component.field.datetime.InstantDateTimeField;
import org.teamapps.ux.component.form.ResponsiveFormLayout;
import org.teamapps.ux.component.form.ResponsiveFormSection;
import org.teamapps.ux.component.format.SizingPolicy;

public class FormMetaFieldsImpl
implements FormMetaFields {
    private final ApplicationInstanceData applicationInstanceData;
    private final TemplateField<Integer> createdByField;
    private final TemplateField<Integer> modifiedByField;
    private final InstantDateTimeField creationDateField;
    private final InstantDateTimeField modificationDateField;

    public FormMetaFieldsImpl(ApplicationInstanceData applicationInstanceData) {
        this.applicationInstanceData = applicationInstanceData;
        this.createdByField = applicationInstanceData.getComponentFactory().createUserTemplateField();
        this.modifiedByField = applicationInstanceData.getComponentFactory().createUserTemplateField();
        this.creationDateField = new InstantDateTimeField();
        this.modificationDateField = new InstantDateTimeField();
        this.creationDateField.setEditingMode(FieldEditingMode.READONLY);
        this.modificationDateField.setEditingMode(FieldEditingMode.READONLY);
    }

    @Override
    public ResponsiveFormSection addMetaFields(ResponsiveFormLayout formLayout, boolean withIcons) {
        Icon dateIcon = withIcons ? ApplicationIcons.CALENDAR_CLOCK : null;
        Icon userIcon = withIcons ? ApplicationIcons.USER : null;
        ResponsiveFormSection formSection = formLayout.addSection(dateIcon, this.applicationInstanceData.getLocalized("org.teamapps.dictionary.metaData", new Object[0]));
        formLayout.addLabelAndField((Icon)userIcon, (String)this.applicationInstanceData.getLocalized((String)"org.teamapps.dictionary.creation", (Object[])new Object[0]), (AbstractField)this.creationDateField).field.getColumnDefinition().setWidthPolicy(SizingPolicy.AUTO);
        formLayout.addLabelAndField(null, null, this.createdByField, (boolean)false).field.getColumnDefinition().setWidthPolicy(SizingPolicy.FRACTION);
        formLayout.addLabelAndField(dateIcon, this.applicationInstanceData.getLocalized("org.teamapps.dictionary.modification", new Object[0]), (AbstractField)this.modificationDateField);
        formLayout.addLabelAndField(null, null, this.modifiedByField, false);
        return formSection;
    }

    @Override
    public void updateEntity(Entity<?> entity) {
        if (entity instanceof AbstractUdbEntity) {
            AbstractUdbEntity udbEntity = (AbstractUdbEntity)entity;
            TableIndex tableIndex = udbEntity.getTableIndex();
            ColumnIndex createdByIndex = tableIndex.getColumnIndex("metaCreatedBy");
            this.createdByField.setValue((Object)(createdByIndex != null ? udbEntity.getIntValue((IntegerIndex)createdByIndex) : 0));
            ColumnIndex modifiedByIndex = tableIndex.getColumnIndex("metaModifiedBy");
            this.modifiedByField.setValue((Object)(modifiedByIndex != null ? udbEntity.getIntValue((IntegerIndex)modifiedByIndex) : 0));
            ColumnIndex creationDateIndex = tableIndex.getColumnIndex("metaCreationDate");
            this.creationDateField.setValue(creationDateIndex != null ? udbEntity.getTimestampValue((IntegerIndex)creationDateIndex) : null);
            ColumnIndex modificationDateIndex = tableIndex.getColumnIndex("metaModificationDate");
            this.modificationDateField.setValue(modificationDateIndex != null ? udbEntity.getTimestampValue((IntegerIndex)modificationDateIndex) : null);
            this.createdByField.setVisible((Integer)this.createdByField.getValue() != 0);
            this.modifiedByField.setVisible((Integer)this.modifiedByField.getValue() != 0);
            this.creationDateField.setVisible(this.creationDateField.getValue() != null);
            this.modificationDateField.setVisible(this.modificationDateField.getValue() != null && !((Instant)this.modificationDateField.getValue()).equals(this.creationDateField.getValue()));
        }
    }
}

