/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.api.application.ApplicationPerspective;
import org.teamapps.application.api.application.ApplicationPerspectiveBuilder;
import org.teamapps.application.api.application.PerspectiveBuilder;
import org.teamapps.application.api.organization.OrgUnit;
import org.teamapps.application.api.theme.ApplicationIcons;
import org.teamapps.application.server.DevApplicationData;
import org.teamapps.common.format.Color;
import org.teamapps.icons.Icon;
import org.teamapps.reporting.convert.DocumentConverter;
import org.teamapps.ux.application.ResponsiveApplication;
import org.teamapps.ux.application.view.View;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.animation.PageTransition;
import org.teamapps.ux.component.flexcontainer.VerticalLayout;
import org.teamapps.ux.component.mobile.MobileLayout;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.Template;
import org.teamapps.ux.component.toolbar.Toolbar;
import org.teamapps.ux.component.toolbar.ToolbarButton;
import org.teamapps.ux.component.toolbar.ToolbarButtonGroup;
import org.teamapps.ux.component.tree.Tree;
import org.teamapps.ux.model.ListTreeModel;
import org.teamapps.ux.model.TreeModel;

public class DevApplication {
    private final ApplicationPerspectiveBuilder applicationBuilder;
    private final DevApplicationData applicationData;
    private ResponsiveApplication application;

    public DevApplication(ApplicationPerspectiveBuilder applicationBuilder, List<OrgUnit> orgUnits, DocumentConverter documentConverter) {
        this.applicationBuilder = applicationBuilder;
        this.applicationData = new DevApplicationData(applicationBuilder, orgUnits, documentConverter);
        this.createUi();
    }

    private void createUi() {
        this.application = ResponsiveApplication.createApplication();
        View applicationMenu = View.createView((String)"left", (Icon)ApplicationIcons.WINDOW, (String)this.applicationData.getLocalized("org.teamapps.dictionary.applications", new Object[0]), null);
        this.application.addApplicationView(applicationMenu);
        applicationMenu.getPanel().setBodyBackgroundColor((Color)Color.WHITE.withAlpha(0.94f));
        VerticalLayout verticalLayout = new VerticalLayout();
        applicationMenu.setComponent((Component)verticalLayout);
        Toolbar toolbar = new Toolbar();
        ToolbarButtonGroup buttonGroup = toolbar.addButtonGroup(new ToolbarButtonGroup());
        buttonGroup.setShowGroupSeparator(false);
        ToolbarButton backButton = ToolbarButton.createSmall((Icon)ApplicationIcons.NAV_LEFT, (String)this.applicationData.getLocalized("org.teamapps.dictionary.back", new Object[0]));
        backButton.setVisible(false);
        buttonGroup.addButton(backButton);
        verticalLayout.addComponent((Component)toolbar);
        MobileLayout mobileLayout = new MobileLayout();
        verticalLayout.addComponentFillRemaining((Component)mobileLayout);
        ListTreeModel treeModel = new ListTreeModel(this.applicationBuilder.getPerspectiveBuilders());
        Tree tree = new Tree((TreeModel)treeModel);
        tree.setShowExpanders(false);
        tree.setEntryTemplate((Template)BaseTemplate.LIST_ITEM_VERY_LARGE_ICON_TWO_LINES);
        tree.setPropertyExtractor((perspectiveBuilder, propertyName) -> {
            switch (propertyName) {
                case "badge": {
                    return null;
                }
                case "icon": {
                    return perspectiveBuilder.getIcon();
                }
                case "caption": {
                    return this.applicationData.getLocalized(perspectiveBuilder.getTitleKey(), new Object[0]);
                }
                case "description": {
                    return this.applicationData.getLocalized(perspectiveBuilder.getDescriptionKey(), new Object[0]);
                }
            }
            return null;
        });
        mobileLayout.setContent((Component)tree);
        HashMap<PerspectiveBuilder, ApplicationPerspective> applicationPerspectiveByPerspectiveBuilder = new HashMap<PerspectiveBuilder, ApplicationPerspective>();
        tree.onNodeSelected.addListener(perspectiveBuilder -> this.showPerspective((PerspectiveBuilder)perspectiveBuilder, this.applicationData, this.application, backButton, mobileLayout, (Map<PerspectiveBuilder, ApplicationPerspective>)applicationPerspectiveByPerspectiveBuilder));
        this.showPerspective(this.applicationBuilder.getPerspectiveBuilders().get(0), this.applicationData, this.application, backButton, mobileLayout, applicationPerspectiveByPerspectiveBuilder);
        backButton.onClick.addListener(() -> {
            backButton.setVisible(false);
            mobileLayout.setContent((Component)tree, PageTransition.MOVE_TO_RIGHT_VS_MOVE_FROM_LEFT, 500);
        });
    }

    private void showPerspective(PerspectiveBuilder perspectiveBuilder, ApplicationInstanceData applicationData, ResponsiveApplication application, ToolbarButton backButton, MobileLayout mobileLayout, Map<PerspectiveBuilder, ApplicationPerspective> applicationPerspectiveByPerspectiveBuilder) {
        ApplicationPerspective applicationPerspective = applicationPerspectiveByPerspectiveBuilder.get(perspectiveBuilder);
        if (applicationPerspective == null) {
            applicationPerspective = perspectiveBuilder.build(applicationData, null);
            applicationPerspectiveByPerspectiveBuilder.put(perspectiveBuilder, applicationPerspective);
            application.addPerspective(applicationPerspective.getPerspective());
        }
        application.showPerspective(applicationPerspective.getPerspective());
        if (applicationPerspective.getPerspectiveMenuPanel() != null) {
            backButton.setVisible(true);
            mobileLayout.setContent(applicationPerspective.getPerspectiveMenuPanel(), PageTransition.MOVE_TO_LEFT_VS_MOVE_FROM_RIGHT, 500);
        }
    }

    public Component getComponent() {
        return this.application.getUi();
    }
}

