/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.api.config;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import org.teamapps.event.Event;

public class ApplicationConfig<CONFIG> {
    private CONFIG config;
    public final Event<CONFIG> onConfigUpdate = new Event();

    public CONFIG getConfig() {
        return this.config;
    }

    public void setConfig(CONFIG config) {
        this.config = config;
    }

    public void updateConfig(String xml, ClassLoader classLoader) throws Exception {
        try {
            XStream xStream = this.createXStream(classLoader);
            Object config = xStream.fromXML(xml);
            this.setConfig(config);
            this.onConfigUpdate.fire(config);
        }
        catch (Throwable e) {
            throw new Exception(e);
        }
    }

    public String getConfigXml(ClassLoader classLoader) {
        if (this.getConfig() == null) {
            return null;
        }
        XStream xStream = this.createXStream(classLoader);
        return xStream.toXML(this.getConfig());
    }

    private XStream createXStream(ClassLoader classLoader) {
        XStream xStream = new XStream((HierarchicalStreamDriver)new DomDriver());
        xStream.setClassLoader(classLoader);
        return xStream;
    }
}

