/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.teamapps.application.api.application.BaseApplicationBuilder;
import org.teamapps.application.api.localization.ApplicationLocalizationProvider;
import org.teamapps.application.api.localization.LocalizationData;
import org.teamapps.universaldb.index.translation.TranslatableText;

public class DevLocalizationProvider
implements ApplicationLocalizationProvider {
    private final BaseApplicationBuilder applicationBuilder;
    private final Map<String, Map<String, String>> localizationMap;
    private final Map<String, Map<String, String>> dictionaryMap;
    private String language = "en";

    public DevLocalizationProvider(BaseApplicationBuilder applicationBuilder) {
        this.applicationBuilder = applicationBuilder;
        this.localizationMap = applicationBuilder.getLocalizationData() != null ? applicationBuilder.getLocalizationData().createLocalizationMapByLanguage() : new HashMap();
        this.dictionaryMap = LocalizationData.createDictionaryData(this.getClass().getClassLoader()).createLocalizationMapByLanguage();
    }

    public void setLanguage(String language) {
        if (language != null && !language.isEmpty()) {
            this.language = language;
        }
    }

    @Override
    public String getLocalized(String key, Object ... parameters) {
        String localizationValue = this.getLocalized(key);
        if (parameters != null && parameters.length > 0) {
            try {
                return MessageFormat.format(localizationValue, parameters);
            }
            catch (Exception e) {
                e.printStackTrace();
                return localizationValue;
            }
        }
        return localizationValue;
    }

    private String getLocalized(String key) {
        Map<String, String> translationMap = this.localizationMap.get(this.language);
        if (translationMap != null && translationMap.containsKey(key)) {
            return translationMap.get(key);
        }
        translationMap = this.dictionaryMap.get(this.language);
        if (translationMap != null && translationMap.containsKey(key)) {
            return translationMap.get(key);
        }
        for (Map<String, String> map : this.localizationMap.values()) {
            if (!map.containsKey(key)) continue;
            return map.get(key);
        }
        for (Map<String, String> map : this.dictionaryMap.values()) {
            if (!map.containsKey(key)) continue;
            return map.get(key);
        }
        return key;
    }

    @Override
    public String getLocalized(TranslatableText translatableText) {
        return translatableText != null ? translatableText.getText() : null;
    }
}

