/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.tools;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ChangeCounter {
    private long time = System.currentTimeMillis();
    private Map<String, Integer> createCountMap = new HashMap<String, Integer>();
    private Map<String, Integer> updateCountMap = new HashMap<String, Integer>();
    private Map<String, Integer> deleteCountMap = new HashMap<String, Integer>();
    private Map<String, Integer> errorCountMap = new HashMap<String, Integer>();
    private String defaultRecord = "records";

    public ChangeCounter() {
    }

    public ChangeCounter(String defaultRecord) {
        this.defaultRecord = defaultRecord;
    }

    public void updateOrCreate(boolean update) {
        this.updateOrCreate(this.defaultRecord, update);
    }

    public void updateOrCreate(String name, boolean update) {
        if (update) {
            this.update(name);
        } else {
            this.create(name);
        }
    }

    public void update() {
        this.update(this.defaultRecord);
    }

    public void update(String name) {
        this.updateCountMap.compute(name, (k, v) -> v == null ? 1 : v + 1);
    }

    public void create() {
        this.create(this.defaultRecord);
    }

    public void create(String name) {
        this.createCountMap.compute(name, (k, v) -> v == null ? 1 : v + 1);
    }

    public void delete() {
        this.delete(this.defaultRecord);
    }

    public void delete(String name) {
        this.deleteCountMap.compute(name, (k, v) -> v == null ? 1 : v + 1);
    }

    public void error() {
        this.error(this.defaultRecord);
    }

    public void error(String name) {
        this.errorCountMap.compute(name, (k, v) -> v == null ? 1 : v + 1);
    }

    public String getResults() {
        return this.getTime() + ", " + this.getKeys().stream().map(this::getResult).collect(Collectors.joining(", "));
    }

    public String getCompactResults() {
        return this.getTime() + ", " + this.getKeys().stream().map(this::getCompactResult).collect(Collectors.joining(", "));
    }

    private String getCompactResult(String key) {
        return key + "(+" + this.createCountMap.getOrDefault(key, 0) + ", -" + this.deleteCountMap.getOrDefault(key, 0) + ", *" + this.updateCountMap.getOrDefault(key, 0) + (String)(this.errorCountMap.get(key) != null ? ", \u26a0" + this.errorCountMap.get(key) : "") + ")";
    }

    private String getResult(String key) {
        return key + "(added: " + this.createCountMap.getOrDefault(key, 0) + ", removed: " + this.deleteCountMap.getOrDefault(key, 0) + ", changed: " + this.updateCountMap.getOrDefault(key, 0) + (String)(this.errorCountMap.get(key) != null ? ", errors: " + this.errorCountMap.get(key) : "") + ")";
    }

    private String getTime() {
        return "time: " + (System.currentTimeMillis() - this.time);
    }

    public List<String> getKeys() {
        HashSet<String> set = new HashSet<String>();
        set.addAll(this.createCountMap.keySet());
        set.addAll(this.updateCountMap.keySet());
        set.addAll(this.deleteCountMap.keySet());
        return set.stream().sorted().collect(Collectors.toList());
    }
}

