/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.tools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class KeyCompare<A, B> {
    private final Collection<A> aCollection;
    private final Collection<B> bCollection;
    private final Function<A, String> keyOfA;
    private final Function<B, String> keyOfB;
    private final List<A> notInB = new ArrayList<A>();
    private final List<A> inB = new ArrayList<A>();
    private final List<B> notInA = new ArrayList<B>();
    private final List<B> inA = new ArrayList<B>();
    private Map<String, A> aByKey;
    private Map<String, B> bByKey;

    public KeyCompare(Collection<A> aCollection, Collection<B> bCollection, Function<A, String> keyOfA, Function<B, String> keyOfB) {
        this.aCollection = aCollection;
        this.bCollection = bCollection;
        this.keyOfA = keyOfA;
        this.keyOfB = keyOfB;
        this.compare();
    }

    private void compare() {
        this.aByKey = this.aCollection.stream().collect(Collectors.toMap(this.keyOfA, a -> a));
        this.bByKey = this.bCollection.stream().collect(Collectors.toMap(this.keyOfB, b -> b));
        for (A a2 : this.aCollection) {
            if (this.bByKey.containsKey(this.keyOfA.apply(a2))) {
                this.inB.add(a2);
                continue;
            }
            this.notInB.add(a2);
        }
        for (Object b2 : this.bCollection) {
            if (this.aByKey.containsKey(this.keyOfB.apply(b2))) {
                this.inA.add(b2);
                continue;
            }
            this.notInA.add(b2);
        }
    }

    public A getA(B b) {
        return this.aByKey.get(this.keyOfB.apply(b));
    }

    public B getB(A a) {
        return this.bByKey.get(this.keyOfA.apply(a));
    }

    public List<A> getAEntriesNotInB() {
        return this.notInB;
    }

    public List<B> getBEntriesNotInA() {
        return this.notInA;
    }

    public List<A> getAEntriesInB() {
        return this.inB;
    }

    public List<B> getBEntriesInA() {
        return this.inA;
    }

    public boolean isDifferent() {
        return !this.notInA.isEmpty() || !this.notInB.isEmpty();
    }
}

