/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.tools;

import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.tools.RecordModelBuilder;
import org.teamapps.udb.filter.TimeIntervalFilter;

public class EntityListModelBuilder<RECORD>
extends RecordModelBuilder<RECORD> {
    private List<RECORD> records = Collections.emptyList();
    private Function<RECORD, String> entityStringFunction;
    private Function<RECORD, Long> entityDateInMillisFunction;

    public EntityListModelBuilder(ApplicationInstanceData applicationInstanceData) {
        super(applicationInstanceData);
    }

    public EntityListModelBuilder(ApplicationInstanceData applicationInstanceData, Function<RECORD, String> entityStringFunction) {
        super(applicationInstanceData);
        this.entityStringFunction = entityStringFunction;
    }

    public EntityListModelBuilder(ApplicationInstanceData applicationInstanceData, Function<RECORD, String> entityStringFunction, Function<RECORD, Long> entityDateInMillisFunction) {
        super(applicationInstanceData);
        this.entityStringFunction = entityStringFunction;
        this.entityDateInMillisFunction = entityDateInMillisFunction;
    }

    public void setEntityStringFunction(Function<RECORD, String> entityStringFunction) {
        this.entityStringFunction = entityStringFunction;
    }

    public void setEntityDateInMillisFunction(Function<RECORD, Long> entityDateInMillisFunction) {
        this.entityDateInMillisFunction = entityDateInMillisFunction;
    }

    public List<RECORD> getRecords() {
        return this.records;
    }

    public void setRecords(List<RECORD> records) {
        this.records = records;
        this.onDataChanged.fire();
    }

    public void addRecord(RECORD record) {
        this.records.add(record);
        this.onDataChanged.fire();
    }

    public void addRecords(List<RECORD> records) {
        this.records.addAll(records);
        this.onDataChanged.fire();
    }

    public void removeRecord(RECORD record) {
        this.records.remove(record);
        this.onDataChanged.fire();
    }

    public void removeRecords(List<RECORD> records) {
        this.records.removeAll(records);
        this.onDataChanged.fire();
    }

    @Override
    public List<RECORD> queryRecords(String fullTextQuery, TimeIntervalFilter timeIntervalFilter) {
        String query;
        List<Object> filteredEntities = null;
        if (this.entityStringFunction != null && this.getCustomFullTextFilter() == null && fullTextQuery != null && !fullTextQuery.isBlank()) {
            query = fullTextQuery.toLowerCase();
            filteredEntities = this.records.stream().filter(RECORD -> this.match(this.entityStringFunction.apply(RECORD), query)).collect(Collectors.toList());
        }
        if (this.entityDateInMillisFunction != null && timeIntervalFilter != null) {
            if (filteredEntities == null) {
                filteredEntities = this.records;
            }
            filteredEntities = filteredEntities.stream().filter(RECORD -> this.match(timeIntervalFilter, this.entityDateInMillisFunction.apply(RECORD))).collect(Collectors.toList());
        }
        if (filteredEntities == null) {
            filteredEntities = this.records;
        }
        if (this.getCustomFullTextFilter() != null && fullTextQuery != null && !fullTextQuery.isBlank()) {
            query = fullTextQuery.toLowerCase();
            BiFunction customFullTextFilter = this.getCustomFullTextFilter();
            filteredEntities = this.records.stream().filter(RECORD -> (Boolean)customFullTextFilter.apply(RECORD, query)).collect(Collectors.toList());
        }
        return filteredEntities;
    }

    private boolean match(String text, String query) {
        if (text == null) {
            return false;
        }
        return text.toLowerCase().contains(query);
    }

    private boolean match(TimeIntervalFilter intervalFilter, Long date) {
        if (date == null) {
            return false;
        }
        return date >= intervalFilter.getStart() && date <= intervalFilter.getEnd();
    }
}

