package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.transaction.*;
import org.teamapps.universaldb.record.*;

import java.util.*;
import java.time.*;
import java.io.*;
import java.util.concurrent.*;
import java.util.function.Supplier;


public class UdbOrganizationUnitView extends AbstractUdbEntity<OrganizationUnitView> implements OrganizationUnitView {
	protected static TableIndex table;
	protected static TranslatableTextIndex name;
	protected static SingleReferenceIndex parent;
	protected static MultiReferenceIndex children;
	protected static SingleReferenceIndex type;
	protected static TextIndex icon;
	protected static SingleReferenceIndex address;

    private static void setTableIndex(TableIndex tableIndex) {
        table = tableIndex;
		name = (TranslatableTextIndex) tableIndex.getColumnIndex(FIELD_NAME);
		parent = (SingleReferenceIndex) tableIndex.getColumnIndex(FIELD_PARENT);
		children = (MultiReferenceIndex) tableIndex.getColumnIndex(FIELD_CHILDREN);
		type = (SingleReferenceIndex) tableIndex.getColumnIndex(FIELD_TYPE);
		icon = (TextIndex) tableIndex.getColumnIndex(FIELD_ICON);
		address = (SingleReferenceIndex) tableIndex.getColumnIndex(FIELD_ADDRESS);
    }

    public static List<OrganizationUnitView> getAll() {
        return new EntityBitSetList<>(OrganizationUnitView.getBuilder(), table.getRecordBitSet());
    }

    public static List<OrganizationUnitView> sort(List<OrganizationUnitView> list, String sortFieldName, boolean ascending, String ... path) {
    	return sort(table, list, sortFieldName, ascending, path);
    }

    public static List<OrganizationUnitView> sort(BitSet recordIds, String sortFieldName, boolean ascending, String ... path) {
        return sort(table, OrganizationUnitView.getBuilder(), recordIds, sortFieldName, ascending, path);
    }

    public static int getCount() {
        return table.getCount();
    }

    public UdbOrganizationUnitView() {
        super(table);
    }

    public UdbOrganizationUnitView(int id, boolean createEntity) {
        super(table, id, createEntity);
    }

    @Override
    public OrganizationUnitView build() {
        return new UdbOrganizationUnitView();
    }

    @Override
    public OrganizationUnitView build(int id) {
        return new UdbOrganizationUnitView(id, false);
    }

	@Override
	public TranslatableText getName() {
	    return getTranslatableTextValue(this.name);
	}

	@Override
	public OrganizationUnitView getParent() {
		if (isChanged(parent)) {
			return (OrganizationUnitView) getReferenceChangeValue(parent);
		} else {
			int id = parent.getValue(getId());
			if (id > 0) {
				return OrganizationUnitView.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public List<OrganizationUnitView> getChildren() {
	    return getMultiReferenceValue(children, OrganizationUnitView.getBuilder());
	}

	@Override
	public int getChildrenCount() {
	    return getMultiReferenceValueCount(children, OrganizationUnitView.getBuilder());
	}

	@Override
	public BitSet getChildrenAsBitSet() {
	    return getMultiReferenceValueAsBitSet(children, OrganizationUnitView.getBuilder());
	}

	@Override
	public OrganizationUnitTypeView getType() {
		if (isChanged(type)) {
			return (OrganizationUnitTypeView) getReferenceChangeValue(type);
		} else {
			int id = type.getValue(getId());
			if (id > 0) {
				return OrganizationUnitTypeView.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public String getIcon() {
        return getTextValue(icon);
	}

	@Override
	public AddressView getAddress() {
		if (isChanged(address)) {
			return (AddressView) getReferenceChangeValue(address);
		} else {
			int id = address.getValue(getId());
			if (id > 0) {
				return AddressView.getById(id);
			} else {
				return null;
			}
		}
	}


    @Override
    public UdbOrganizationUnitView save(Transaction transaction, boolean strictChangeVerification) {
    	throw new UnsupportedOperationException();
    }

    @Override
    public UdbOrganizationUnitView saveTransactional(boolean strictChangeVerification) {
    	throw new UnsupportedOperationException();
    }

    @Override
    public UdbOrganizationUnitView save() {
    	throw new UnsupportedOperationException();
    }

    @Override
    public void delete(Transaction transaction) {
    	throw new UnsupportedOperationException();
    }

    @Override
    public void delete() {
    	throw new UnsupportedOperationException();
    }

	@Override
	public String toString() {
    	StringBuilder sb = new StringBuilder();
    	sb.append(table.getName()).append(": ").append(getId()).append("\n");
		for (ColumnIndex column : table.getColumnIndices()) {
			sb.append("\t").append(column.getName()).append(": ").append(column.getStringValue(getId()));
			if (isChanged(column)) {
				TransactionRecordValue changeValue = getChangeValue(column);
				sb.append(" -> ").append(changeValue.getValue());
			}
			sb.append("\n");
		}
		return sb.toString();
	}
}



