/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server;

import java.util.HashMap;
import java.util.Set;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.api.theme.ApplicationIcons;
import org.teamapps.application.api.ui.FormMetaFields;
import org.teamapps.application.api.ui.TranslationKeyField;
import org.teamapps.application.api.ui.UiComponentFactory;
import org.teamapps.application.ux.UiUtils;
import org.teamapps.application.ux.form.FormMetaFieldsImpl;
import org.teamapps.application.ux.localize.TranslatableField;
import org.teamapps.application.ux.org.OrganizationViewUtils;
import org.teamapps.data.extract.PropertyProvider;
import org.teamapps.event.Event;
import org.teamapps.model.controlcenter.OrganizationUnitTypeView;
import org.teamapps.model.controlcenter.OrganizationUnitView;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.FieldEditingMode;
import org.teamapps.ux.component.field.TemplateField;
import org.teamapps.ux.component.field.TextField;
import org.teamapps.ux.component.field.combobox.ComboBox;
import org.teamapps.ux.component.field.combobox.TagComboBox;
import org.teamapps.ux.component.linkbutton.LinkButton;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.Template;

public class DevUiComponentFactory
implements UiComponentFactory {
    private final ApplicationInstanceData applicationInstanceData;

    public DevUiComponentFactory(ApplicationInstanceData applicationInstanceData) {
        this.applicationInstanceData = applicationInstanceData;
    }

    @Override
    public ComboBox<OrganizationUnitView> createOrganizationUnitComboBox(Set<OrganizationUnitView> allowedUnits) {
        return OrganizationViewUtils.createOrganizationComboBox((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE, allowedUnits, this.applicationInstanceData);
    }

    @Override
    public TagComboBox<OrganizationUnitTypeView> createOrganizationUnitTypeTagComboBox() {
        return OrganizationViewUtils.createOrganizationUnitTypeTagComboBox(150, this.applicationInstanceData);
    }

    @Override
    public TemplateField<OrganizationUnitView> createOrganizationUnitTemplateField() {
        return UiUtils.createTemplateField((Template)BaseTemplate.LIST_ITEM_MEDIUM_ICON_SINGLE_LINE, OrganizationViewUtils.creatOrganizationUnitViewPropertyProvider(this.applicationInstanceData));
    }

    @Override
    public TemplateField<Integer> createUserTemplateField() {
        return UiUtils.createTemplateField((Template)BaseTemplate.LIST_ITEM_MEDIUM_ICON_SINGLE_LINE, DevUiComponentFactory.createUserIdPropertyProvider());
    }

    @Override
    public TranslatableField createTranslatableField() {
        return new TranslatableField(this.applicationInstanceData);
    }

    @Override
    public TranslationKeyField createTranslationKeyField(String linkButtonCaption, boolean allowMultiLine, boolean selectionFieldWithKey) {
        final TextField selectionField = new TextField();
        final TextField keyField = new TextField();
        final LinkButton linkButton = new LinkButton(linkButtonCaption);
        final Event onValueChanged = new Event();
        keyField.setEditingMode(FieldEditingMode.READONLY);
        return new TranslationKeyField(){

            @Override
            public Event<String> getOnValueChanged() {
                return onValueChanged;
            }

            @Override
            public AbstractField<String> getSelectionField() {
                return selectionField;
            }

            @Override
            public AbstractField<String> getKeyDisplayField() {
                return keyField;
            }

            @Override
            public LinkButton getKeyLinkButton() {
                return linkButton;
            }

            @Override
            public void setKey(String key) {
                keyField.setValue((Object)key);
                selectionField.setValue((Object)key);
            }

            @Override
            public String getKey() {
                return (String)selectionField.getValue();
            }
        };
    }

    @Override
    public FormMetaFields createFormMetaFields() {
        return new FormMetaFieldsImpl(this.applicationInstanceData);
    }

    @Override
    public String createUserAvatarLink(int userId, boolean large) {
        return null;
    }

    public static PropertyProvider<Integer> createUserIdPropertyProvider() {
        return (userId, propertyNames) -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("icon", ApplicationIcons.USER);
            map.put("caption", "User with id:" + userId);
            return map;
        };
    }
}

