package org.teamapps.mock.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.file.FileValue;
import org.teamapps.universaldb.index.translation.*;
import java.util.*;
import java.time.*;
import java.io.*;
import java.util.function.Supplier;


public interface OrganizationField extends Entity<OrganizationField> {

	final static String FIELD_META_CREATION_DATE = "metaCreationDate";
	final static String FIELD_META_CREATED_BY = "metaCreatedBy";
	final static String FIELD_META_MODIFICATION_DATE = "metaModificationDate";
	final static String FIELD_META_MODIFIED_BY = "metaModifiedBy";
	final static String FIELD_META_DELETION_DATE = "metaDeletionDate";
	final static String FIELD_META_DELETED_BY = "metaDeletedBy";
	final static String FIELD_META_RESTORE_DATE = "metaRestoreDate";
	final static String FIELD_META_RESTORED_BY = "metaRestoredBy";
	final static String FIELD_TITLE = "title";
	final static String FIELD_ICON = "icon";

    static OrganizationField create() {
        return new UdbOrganizationField();
    }

    static OrganizationField create(int id) {
        return new UdbOrganizationField(id, true);
    }

    static OrganizationField getById(int id) {
        return new UdbOrganizationField(id, false);
    }

    static EntityBuilder<OrganizationField> getBuilder() {
        return new UdbOrganizationField(0, false);
    }

    Instant getMetaCreationDate();

    OrganizationField setMetaCreationDate(Instant value);

    int getMetaCreationDateAsEpochSecond();

    OrganizationField setMetaCreationDateAsEpochSecond(int value);

    long getMetaCreationDateAsEpochMilli();

    OrganizationField setMetaCreationDateAsEpochMilli(long value);

    int getMetaCreatedBy();

    OrganizationField setMetaCreatedBy(int value);

    Instant getMetaModificationDate();

    OrganizationField setMetaModificationDate(Instant value);

    int getMetaModificationDateAsEpochSecond();

    OrganizationField setMetaModificationDateAsEpochSecond(int value);

    long getMetaModificationDateAsEpochMilli();

    OrganizationField setMetaModificationDateAsEpochMilli(long value);

    int getMetaModifiedBy();

    OrganizationField setMetaModifiedBy(int value);

    Instant getMetaDeletionDate();

    OrganizationField setMetaDeletionDate(Instant value);

    int getMetaDeletionDateAsEpochSecond();

    OrganizationField setMetaDeletionDateAsEpochSecond(int value);

    long getMetaDeletionDateAsEpochMilli();

    OrganizationField setMetaDeletionDateAsEpochMilli(long value);

    int getMetaDeletedBy();

    OrganizationField setMetaDeletedBy(int value);

    Instant getMetaRestoreDate();

    OrganizationField setMetaRestoreDate(Instant value);

    int getMetaRestoreDateAsEpochSecond();

    OrganizationField setMetaRestoreDateAsEpochSecond(int value);

    long getMetaRestoreDateAsEpochMilli();

    OrganizationField setMetaRestoreDateAsEpochMilli(long value);

    int getMetaRestoredBy();

    OrganizationField setMetaRestoredBy(int value);

    TranslatableText getTitle();

    OrganizationField setTitle(TranslatableText value);

    String getIcon();

    OrganizationField setIcon(String value);


    static List<OrganizationField> getAll() {
        return UdbOrganizationField.getAll();
    }

    static List<OrganizationField> getDeletedRecords() {
        return UdbOrganizationField.getDeletedRecords();
    }

    static List<OrganizationField> sort(List<OrganizationField> list, String sortFieldName, boolean ascending, String ... path) {
        return UdbOrganizationField.sort(list, sortFieldName, ascending, path);
    }

    static int getCount() {
        return UdbOrganizationField.getCount();
    }

    static OrganizationFieldQuery filter() {
        return new UdbOrganizationFieldQuery();
    }
}

