package org.teamapps.mock.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.transaction.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.query.*;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


public class UdbOrganizationFieldQuery extends AbstractUdbQuery<OrganizationField> implements OrganizationFieldQuery {

    public UdbOrganizationFieldQuery() {
        super(UdbOrganizationField.table, OrganizationField.getBuilder());
    }

	@Override
	public OrganizationFieldQuery fullTextFilter(TextFilter textFilter, String... fieldNames) {
    	and(UdbOrganizationField.table.createFullTextFilter(textFilter, fieldNames));
		return this;
	}

	@Override
	public OrganizationFieldQuery parseFullTextFilter(String query, String... fieldNames) {
    	and(UdbOrganizationField.table.createFullTextFilter(query, fieldNames));
		return this;
	}

	@Override
	public OrganizationFieldQuery metaCreationDate(NumericFilter filter) {
		and(UdbOrganizationField.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationFieldQuery orMetaCreationDate(NumericFilter filter) {
		or(UdbOrganizationField.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationFieldQuery metaCreatedBy(NumericFilter filter) {
		and(UdbOrganizationField.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationFieldQuery orMetaCreatedBy(NumericFilter filter) {
		or(UdbOrganizationField.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationFieldQuery metaModificationDate(NumericFilter filter) {
		and(UdbOrganizationField.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationFieldQuery orMetaModificationDate(NumericFilter filter) {
		or(UdbOrganizationField.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationFieldQuery metaModifiedBy(NumericFilter filter) {
		and(UdbOrganizationField.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationFieldQuery orMetaModifiedBy(NumericFilter filter) {
		or(UdbOrganizationField.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationFieldQuery metaDeletionDate(NumericFilter filter) {
		and(UdbOrganizationField.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationFieldQuery orMetaDeletionDate(NumericFilter filter) {
		or(UdbOrganizationField.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationFieldQuery metaDeletedBy(NumericFilter filter) {
		and(UdbOrganizationField.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationFieldQuery orMetaDeletedBy(NumericFilter filter) {
		or(UdbOrganizationField.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationFieldQuery metaRestoreDate(NumericFilter filter) {
		and(UdbOrganizationField.metaRestoreDate.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationFieldQuery orMetaRestoreDate(NumericFilter filter) {
		or(UdbOrganizationField.metaRestoreDate.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationFieldQuery metaRestoredBy(NumericFilter filter) {
		and(UdbOrganizationField.metaRestoredBy.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationFieldQuery orMetaRestoredBy(NumericFilter filter) {
		or(UdbOrganizationField.metaRestoredBy.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationFieldQuery title(TranslatableTextFilter filter) {
		and(UdbOrganizationField.title.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationFieldQuery orTitle(TranslatableTextFilter filter) {
		or(UdbOrganizationField.title.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationFieldQuery icon(TextFilter filter) {
		and(UdbOrganizationField.icon.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationFieldQuery orIcon(TextFilter filter) {
		or(UdbOrganizationField.icon.createFilter(filter));
		return this;
	}


	@Override
	public UdbOrganizationFieldQuery andOr(OrganizationFieldQuery ... queries) {
	    AbstractUdbQuery[] abstractUdbQueries = Arrays.copyOf(queries, queries.length, AbstractUdbQuery[].class);
		andOr(abstractUdbQueries);
		return this;
	}

    @Override
    public OrganizationFieldQuery customFilter(Function<OrganizationField, Boolean> customFilter) {
        Function<Integer, Boolean> filterFunction = id -> {
            return customFilter.apply(OrganizationField.getById(id));
        };
        and(new CustomEntityFilter(filterFunction));
        return this;
    }

}



