package org.teamapps.model.system;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.transaction.*;
import org.teamapps.universaldb.record.*;

import java.util.*;
import java.time.*;
import java.io.*;
import java.util.concurrent.*;
import java.util.function.Supplier;


public class UdbSystemStarts extends AbstractUdbEntity<SystemStarts> implements SystemStarts {
	protected static TableIndex table;
	protected static IntegerIndex timestamp;
	protected static ShortIndex type;

    private static void setTableIndex(TableIndex tableIndex) {
        table = tableIndex;
		timestamp = (IntegerIndex) tableIndex.getColumnIndex(FIELD_TIMESTAMP);
		type = (ShortIndex) tableIndex.getColumnIndex(FIELD_TYPE);
    }

    public static List<SystemStarts> getAll() {
        return new EntityBitSetList<>(SystemStarts.getBuilder(), table.getRecordBitSet());
    }

    public static List<SystemStarts> getDeletedRecords() {
        return new EntityBitSetList<>(SystemStarts.getBuilder(), table.getDeletedRecordsBitSet());
    }

    public static List<SystemStarts> sort(List<SystemStarts> list, String sortFieldName, boolean ascending, String ... path) {
    	return sort(table, list, sortFieldName, ascending, path);
    }

    public static List<SystemStarts> sort(BitSet recordIds, String sortFieldName, boolean ascending, String ... path) {
        return sort(table, SystemStarts.getBuilder(), recordIds, sortFieldName, ascending, path);
    }

    public static int getCount() {
        return table.getCount();
    }

    public UdbSystemStarts() {
        super(table);
    }

    public UdbSystemStarts(int id, boolean createEntity) {
        super(table, id, createEntity);
    }

    @Override
    public SystemStarts build() {
        return new UdbSystemStarts();
    }

    @Override
    public SystemStarts build(int id) {
        return new UdbSystemStarts(id, false);
    }

	@Override
	public Instant getTimestamp() {
	    return getTimestampValue(timestamp);
	}

	@Override
	public SystemStarts setTimestamp(Instant value) {
	    setTimestampValue(value, this.timestamp);
		return this;
	}

	@Override
	public int getTimestampAsEpochSecond() {
	    return getTimestampAsEpochSecond(timestamp);
	}

	@Override
	public SystemStarts setTimestampAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.timestamp);
		return this;
	}

	@Override
	public long getTimestampAsEpochMilli() {
	    return getTimestampAsEpochMilli(timestamp);
	}

	@Override
	public SystemStarts setTimestampAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.timestamp);
		return this;
	}

	@Override
	public Type getType() {
	    return getEnumValue(type, Type.values());
	}

	@Override
	public SystemStarts setType(Type value) {
    	setEnumValue(this.type, value);
		return this;
	}


    @Override
    public UdbSystemStarts save(Transaction transaction, boolean strictChangeVerification) {
        saveRecord(transaction, strictChangeVerification);
        return this;
    }

    @Override
    public UdbSystemStarts saveTransactional(boolean strictChangeVerification) {
        saveRecord(UniversalDB.getThreadLocalTransaction(), strictChangeVerification);
        return this;
    }

    @Override
    public UdbSystemStarts save() {
        saveRecord();
        return this;
    }

    @Override
    public void delete(Transaction transaction) {
        deleteRecord(transaction);
    }

    @Override
    public void delete() {
        deleteRecord();
    }

    @Override
    public void restoreDeleted() {
        restoreDeletedRecord();
    }
}



