/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.ux.form;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.api.privilege.OrganizationalPrivilegeGroup;
import org.teamapps.application.api.privilege.Privilege;
import org.teamapps.application.api.privilege.StandardPrivilegeGroup;
import org.teamapps.application.api.theme.ApplicationIcons;
import org.teamapps.application.api.ui.FormMetaFields;
import org.teamapps.application.tools.RecordModelBuilder;
import org.teamapps.application.ux.UiUtils;
import org.teamapps.application.ux.form.FormButtonUtils;
import org.teamapps.application.ux.form.FormValidator;
import org.teamapps.databinding.TwoWayBindableValue;
import org.teamapps.event.Event;
import org.teamapps.icons.Icon;
import org.teamapps.model.controlcenter.OrganizationUnitView;
import org.teamapps.universaldb.pojo.Entity;
import org.teamapps.ux.application.view.View;
import org.teamapps.ux.component.dialogue.Dialogue;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.FieldEditingMode;
import org.teamapps.ux.component.field.FieldMessage;
import org.teamapps.ux.component.field.Fields;
import org.teamapps.ux.component.form.AbstractForm;
import org.teamapps.ux.component.form.ResponsiveFormLayout;
import org.teamapps.ux.component.panel.Panel;
import org.teamapps.ux.component.toolbar.Toolbar;
import org.teamapps.ux.component.toolbar.ToolbarButton;
import org.teamapps.ux.component.toolbar.ToolbarButtonGroup;

public class FormController<ENTITY extends Entity<?>>
extends FormValidator {
    public final Event<ENTITY> onEntityCreated = new Event();
    public final Event<ENTITY> onEntityUpdated = new Event();
    public final Event<ENTITY> onEntityDeleted = new Event();
    public final Event<ENTITY> onEntityRestored = new Event();
    public final Event<ENTITY> onEntityAnyChanged = new Event();
    private final AbstractForm<?, ENTITY> form;
    private final Set<AbstractField<?>> otherFields = new HashSet();
    private final TwoWayBindableValue<ENTITY> selectedEntity;
    private final ApplicationInstanceData applicationInstanceData;
    private Supplier<ENTITY> createNewEntitySupplier;
    private Predicate<ENTITY> saveEntityHandler;
    private Predicate<ENTITY> revertChangesHandler;
    private Predicate<ENTITY> deleteEntityHandler;
    private Predicate<ENTITY> restoreEntityHandler;
    private StandardPrivilegeGroup standardPrivilegeGroup;
    private OrganizationalPrivilegeGroup organizationalPrivilegeGroup;
    private Function<ENTITY, OrganizationUnitView> entityOrganizationUnitSelector;
    private AbstractField<OrganizationUnitView> organizationUnitViewField;
    private boolean updateFieldEditMode;
    private final Set<AbstractField<?>> nonEditableFields = new HashSet();
    private ToolbarButton newButton;
    private ToolbarButton saveButton;
    private ToolbarButton revertButton;
    private ToolbarButton deleteButton;
    private ToolbarButton restoreButton;
    private List<ToolbarButtonGroup> toolbarButtonGroups;
    private boolean isModified;
    private boolean autoApplyFieldValuesToRecord;
    private boolean autoApplyRecordValuesToFields;
    private Panel toolbarButtonPanel;
    private Toolbar toolbar;

    public FormController(ApplicationInstanceData applicationInstanceData, AbstractForm<?, ENTITY> form, TwoWayBindableValue<ENTITY> selectedEntity, Supplier<ENTITY> createNewEntitySupplier, StandardPrivilegeGroup standardPrivilegeGroup) {
        this(applicationInstanceData, form, selectedEntity, createNewEntitySupplier);
        this.standardPrivilegeGroup = standardPrivilegeGroup;
    }

    public FormController(ApplicationInstanceData applicationInstanceData, AbstractForm<?, ENTITY> form, TwoWayBindableValue<ENTITY> selectedEntity, Supplier<ENTITY> createNewEntitySupplier, OrganizationalPrivilegeGroup organizationalPrivilegeGroup, Function<ENTITY, OrganizationUnitView> entityOrganizationUnitSelector) {
        this(applicationInstanceData, form, selectedEntity, createNewEntitySupplier);
        this.organizationalPrivilegeGroup = organizationalPrivilegeGroup;
        this.entityOrganizationUnitSelector = entityOrganizationUnitSelector;
        if (entityOrganizationUnitSelector == null) {
            throw new RuntimeException("Missing entity org unit selector!");
        }
        this.createOrganizationUnitField();
    }

    private FormController(ApplicationInstanceData applicationInstanceData, AbstractForm<?, ENTITY> form, TwoWayBindableValue<ENTITY> selectedEntity, Supplier<ENTITY> createNewEntitySupplier) {
        super(applicationInstanceData);
        this.form = form;
        this.selectedEntity = selectedEntity;
        this.applicationInstanceData = applicationInstanceData;
        this.createNewEntitySupplier = createNewEntitySupplier;
        this.init(applicationInstanceData);
        form.onFieldValueChanged.addListener(event -> this.handleFieldUpdateByClient(event.getField()));
        selectedEntity.onChanged().addListener(this::handleEntitySelection);
        this.init(applicationInstanceData);
        this.onEntityCreated.addListener(() -> this.onEntityAnyChanged.fire());
        this.onEntityUpdated.addListener(() -> this.onEntityAnyChanged.fire());
        this.onEntityDeleted.addListener(() -> this.onEntityAnyChanged.fire());
        this.onEntityRestored.addListener(() -> this.onEntityAnyChanged.fire());
    }

    private void init(ApplicationInstanceData applicationInstanceData) {
        this.newButton = FormButtonUtils.createNewButton(applicationInstanceData);
        this.saveButton = FormButtonUtils.createSaveButton(applicationInstanceData);
        this.revertButton = FormButtonUtils.createRevertButton(applicationInstanceData);
        this.deleteButton = FormButtonUtils.createDeleteButton(applicationInstanceData);
        this.restoreButton = FormButtonUtils.createRestoreButton(applicationInstanceData);
        this.newButton.setVisible(this.isEntityCreationAllowed());
        this.saveButton.setVisible(false);
        this.revertButton.setVisible(false);
        this.deleteButton.setVisible(false);
        this.restoreButton.setVisible(false);
        this.toolbarButtonGroups = new ArrayList<ToolbarButtonGroup>();
        ToolbarButtonGroup buttonGroup = new ToolbarButtonGroup();
        buttonGroup.addButton(this.newButton);
        buttonGroup.addButton(this.saveButton);
        this.toolbarButtonGroups.add(buttonGroup);
        buttonGroup = new ToolbarButtonGroup();
        buttonGroup.addButton(this.revertButton);
        this.toolbarButtonGroups.add(buttonGroup);
        buttonGroup = new ToolbarButtonGroup();
        buttonGroup.addButton(this.deleteButton);
        buttonGroup.addButton(this.restoreButton);
        this.toolbarButtonGroups.add(buttonGroup);
        this.newButton.onClick.addListener(() -> {
            if (this.isEntityCreationAllowed()) {
                Entity entity = (Entity)this.createNewEntitySupplier.get();
                this.selectedEntity.set((Object)entity);
                this.newButton.setVisible(false);
            }
        });
        this.saveButton.onClick.addListener(() -> {
            Entity entity = (Entity)this.selectedEntity.get();
            if (this.validate() && (this.saveEntityHandler == null || this.saveEntityHandler.test(entity))) {
                boolean stored = entity.isStored();
                if (this.autoApplyFieldValuesToRecord) {
                    this.form.applyFieldValuesToRecord((Object)entity);
                }
                entity.save();
                this.saveButton.setVisible(false);
                this.restoreButton.setVisible(false);
                this.newButton.setVisible(this.isEntityCreationAllowed());
                if (stored) {
                    this.onEntityUpdated.fire((Object)entity);
                } else {
                    this.onEntityCreated.fire((Object)entity);
                }
                UiUtils.showSaveNotification(true, applicationInstanceData);
            } else {
                UiUtils.showSaveNotification(false, applicationInstanceData);
            }
        });
        this.revertButton.onClick.addListener(() -> {
            Entity entity = (Entity)this.selectedEntity.get();
            if (this.revertChangesHandler == null || this.revertChangesHandler.test(entity)) {
                this.selectedEntity.onChanged().fire((Object)entity);
                this.saveButton.setVisible(false);
                this.revertButton.setVisible(false);
                this.newButton.setVisible(this.isEntityCreationAllowed());
                this.deleteButton.setVisible(this.isEntityDeletable((Entity)this.selectedEntity.get()));
                this.markAllFieldsUnchanged();
            }
        });
        this.deleteButton.onClick.addListener(() -> {
            Entity entity = (Entity)this.selectedEntity.get();
            if (this.isEntityDeletable(entity)) {
                Dialogue.showOkCancel((Icon)ApplicationIcons.DELETE, (String)applicationInstanceData.getLocalized("org.teamapps.dictionary.deleteRecord", new Object[0]), (String)applicationInstanceData.getLocalized("org.teamapps.dictionary.doYouReallyWantToDeleteTheRecord", new Object[0])).addListener(result -> {
                    if (result.booleanValue() && (this.deleteEntityHandler == null || this.deleteEntityHandler.test(entity))) {
                        entity.delete();
                        this.deleteButton.setVisible(false);
                        this.restoreButton.setVisible(this.isEntityRestorable(entity));
                        this.onEntityDeleted.fire((Object)entity);
                    }
                });
            }
        });
        this.restoreButton.onClick.addListener(() -> {
            Entity entity = (Entity)this.selectedEntity.get();
            if (this.isEntityRestorable(entity) && (this.restoreEntityHandler == null || this.revertChangesHandler.test(entity))) {
                entity.restoreDeleted();
                this.restoreButton.setVisible(false);
                this.deleteButton.setVisible(this.isEntityDeletable((Entity)this.selectedEntity.get()));
                this.onEntityRestored.fire((Object)entity);
            }
        });
        this.selectedEntity.onChanged().addListener(entity -> {
            this.newButton.setVisible(this.isEntityCreationAllowed());
            this.deleteButton.setVisible(this.isEntityDeletable(entity));
            this.restoreButton.setVisible(this.isEntityRestorable(entity));
            this.markAllFieldsUnchanged();
        });
    }

    private void createOrganizationUnitField() {
        List<OrganizationUnitView> allowedUnitsForCreation = this.applicationInstanceData.getAllowedUnits(this.organizationalPrivilegeGroup, Privilege.CREATE);
        List<OrganizationUnitView> allowedUnitsForModification = this.applicationInstanceData.getAllowedUnits(this.organizationalPrivilegeGroup, Privilege.UPDATE);
        this.organizationUnitViewField = allowedUnitsForCreation.size() > 1 || allowedUnitsForModification.size() > 1 ? this.applicationInstanceData.getComponentFactory().createOrganizationUnitComboBox(() -> {
            if (((Entity)this.selectedEntity.get()).isStored()) {
                return allowedUnitsForModification;
            }
            return allowedUnitsForCreation;
        }) : this.applicationInstanceData.getComponentFactory().createOrganizationUnitTemplateField();
        this.organizationUnitViewField.addValidator(organizationUnitView -> {
            Privilege privilege;
            Entity entity = (Entity)this.selectedEntity.get();
            Privilege privilege2 = privilege = entity.isStored() ? Privilege.UPDATE : Privilege.CREATE;
            if (this.applicationInstanceData.isAllowed(this.organizationalPrivilegeGroup, privilege, (OrganizationUnitView)this.organizationUnitViewField.getValue())) {
                return Collections.emptyList();
            }
            return Collections.singletonList(new FieldMessage(FieldMessage.Severity.ERROR, this.applicationInstanceData.getLocalized("org.teamapps.dictionary.organization", new Object[0])));
        });
        this.addFieldWithValidator(this.organizationUnitViewField);
        this.selectedEntity.onChanged().addListener(entity -> this.organizationUnitViewField.setValue((Object)this.entityOrganizationUnitSelector.apply(entity)));
    }

    public void registerModelBuilder(RecordModelBuilder<ENTITY> modelBuilder) {
        this.onEntityCreated.addListener(entity -> modelBuilder.onDataChanged.fire());
        this.onEntityUpdated.addListener(entity -> modelBuilder.onDataChanged.fire());
        this.onEntityDeleted.addListener(entity -> modelBuilder.onDataChanged.fire());
        this.onEntityRestored.addListener(entity -> modelBuilder.onDataChanged.fire());
    }

    public void registerView(View view) {
        this.toolbarButtonGroups.forEach(arg_0 -> ((View)view).addLocalButtonGroup(arg_0));
    }

    public void setCreateNewEntitySupplier(Supplier<ENTITY> createNewEntitySupplier) {
        this.createNewEntitySupplier = createNewEntitySupplier;
    }

    public void setUpdateFieldEditMode(boolean updateFieldEditMode) {
        this.updateFieldEditMode = updateFieldEditMode;
        if (updateFieldEditMode) {
            this.nonEditableFields.clear();
            Stream.concat(this.form.getFields().stream(), this.otherFields.stream()).filter(f -> f.getEditingMode() != FieldEditingMode.EDITABLE).forEach(f -> this.nonEditableFields.add((AbstractField<?>)f));
        }
    }

    public void addFormFields(List<AbstractField<?>> fields) {
        fields.stream().filter(f -> !this.otherFields.contains(f)).forEach(f -> {
            this.otherFields.add((AbstractField<?>)f);
            this.handleFieldUpdateByClient((AbstractField<?>)f);
        });
    }

    private void handleEntitySelection(ENTITY entity) {
        if (this.isModified) {
            this.isModified = false;
            this.markAllFieldsUnchanged();
            this.clearMessages();
        }
        if (this.autoApplyRecordValuesToFields) {
            this.form.applyRecordValuesToFields(entity);
        }
        if (this.updateFieldEditMode) {
            boolean editable = !entity.isDeleted() && this.isEntityEditable(entity);
            Stream.concat(this.form.getFields().stream(), this.otherFields.stream()).filter(f -> !this.nonEditableFields.contains(f)).forEach(f -> f.setEditingMode(editable ? FieldEditingMode.EDITABLE : FieldEditingMode.READONLY));
        }
    }

    public void handleFieldUpdateByClient(AbstractField<?> field) {
        Entity entity;
        this.markFieldChanged(field);
        if (!this.saveButton.isVisible() && this.isEntityEditable(entity = (Entity)this.selectedEntity.get())) {
            this.saveButton.setVisible(true);
            this.revertButton.setVisible(true);
            this.newButton.setVisible(false);
            this.deleteButton.setVisible(false);
            this.isModified = true;
        }
    }

    private boolean isEntityEditable(ENTITY entity) {
        Privilege privilege;
        if (entity == null) {
            return false;
        }
        Privilege privilege2 = privilege = entity.isStored() ? Privilege.UPDATE : Privilege.CREATE;
        if (this.standardPrivilegeGroup != null) {
            return this.applicationInstanceData.isAllowed(this.standardPrivilegeGroup, privilege);
        }
        OrganizationUnitView selectedOrganizationUnit = this.entityOrganizationUnitSelector.apply(entity);
        if (entity.isStored() || selectedOrganizationUnit != null) {
            return this.applicationInstanceData.isAllowed(this.organizationalPrivilegeGroup, privilege, selectedOrganizationUnit);
        }
        return !this.applicationInstanceData.getAllowedUnits(this.organizationalPrivilegeGroup, Privilege.CREATE).isEmpty();
    }

    private boolean isEntityDeletable(ENTITY entity) {
        if (entity == null || !entity.isStored() || entity.isDeleted()) {
            return false;
        }
        Privilege privilege = Privilege.DELETE;
        if (this.standardPrivilegeGroup != null) {
            return this.applicationInstanceData.isAllowed(this.standardPrivilegeGroup, privilege);
        }
        return this.applicationInstanceData.isAllowed(this.organizationalPrivilegeGroup, privilege, this.entityOrganizationUnitSelector.apply(entity));
    }

    private boolean isEntityRestorable(ENTITY entity) {
        if (entity == null || !entity.isDeleted() || !entity.isRestorable()) {
            return false;
        }
        Privilege privilege = Privilege.RESTORE;
        if (this.standardPrivilegeGroup != null) {
            return this.applicationInstanceData.isAllowed(this.standardPrivilegeGroup, privilege);
        }
        return this.applicationInstanceData.isAllowed(this.organizationalPrivilegeGroup, privilege, this.entityOrganizationUnitSelector.apply(entity));
    }

    private boolean isEntityCreationAllowed() {
        return this.standardPrivilegeGroup != null ? this.applicationInstanceData.isAllowed(this.standardPrivilegeGroup, Privilege.CREATE) : !this.applicationInstanceData.getAllowedUnits(this.organizationalPrivilegeGroup, Privilege.CREATE).isEmpty();
    }

    public AbstractField<OrganizationUnitView> getOrganizationUnitViewField() {
        return this.organizationUnitViewField;
    }

    public List<ToolbarButtonGroup> getToolbarButtonGroups() {
        return this.toolbarButtonGroups;
    }

    public void addToolbarButtonGroup(ToolbarButtonGroup buttonGroup) {
        this.toolbarButtonGroups.add(buttonGroup);
    }

    public void addMetaDataSection(ResponsiveFormLayout formLayout) {
        FormMetaFields formMetaFields = this.applicationInstanceData.getComponentFactory().createFormMetaFields();
        formMetaFields.addMetaFields(formLayout, false);
        this.selectedEntity.onChanged().addListener(formMetaFields::updateEntity);
    }

    protected void markFieldChanged(AbstractField<?> field) {
        field.setCssStyle(".field-border", "border-color", "#ec9a1a");
        field.setCssStyle(".field-border-glow", "box-shadow", "0 0 3px 0 #ec9a1a");
    }

    protected void markAllFieldsUnchanged() {
        this.form.getFields().forEach(field -> {
            field.setCssStyle(".field-border", "border-color", null);
            field.setCssStyle(".field-border-glow", "box-shadow", null);
        });
    }

    @Override
    public boolean validate() {
        boolean validationResult = super.validate();
        if (validationResult && (validationResult = Fields.validateAll(new ArrayList(this.otherFields)))) {
            Entity entity = (Entity)this.selectedEntity.get();
            return this.isEntityEditable(entity);
        }
        return false;
    }

    public ToolbarButton getNewButton() {
        return this.newButton;
    }

    public ToolbarButton getSaveButton() {
        return this.saveButton;
    }

    public ToolbarButton getRevertButton() {
        return this.revertButton;
    }

    public ToolbarButton getDeleteButton() {
        return this.deleteButton;
    }

    public ToolbarButton getRestoreButton() {
        return this.restoreButton;
    }

    public void setSaveEntityHandler(Predicate<ENTITY> saveEntityHandler) {
        this.saveEntityHandler = saveEntityHandler;
    }

    public void setRevertChangesHandler(Predicate<ENTITY> revertChangesHandler) {
        this.revertChangesHandler = revertChangesHandler;
    }

    public void setDeleteEntityHandler(Predicate<ENTITY> deleteEntityHandler) {
        this.deleteEntityHandler = deleteEntityHandler;
    }

    public void setRestoreEntityHandler(Predicate<ENTITY> restoreEntityHandler) {
        this.restoreEntityHandler = restoreEntityHandler;
    }

    public boolean isAutoApplyFieldValuesToRecord() {
        return this.autoApplyFieldValuesToRecord;
    }

    public void setAutoApplyFieldValuesToRecord(boolean autoApplyFieldValuesToRecord) {
        this.autoApplyFieldValuesToRecord = autoApplyFieldValuesToRecord;
    }

    public boolean isAutoApplyRecordValuesToFields() {
        return this.autoApplyRecordValuesToFields;
    }

    public void setAutoApplyRecordValuesToFields(boolean autoApplyRecordValuesToFields) {
        this.autoApplyRecordValuesToFields = autoApplyRecordValuesToFields;
    }
}

