/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.ux.view;

import java.util.function.Function;
import java.util.function.Supplier;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.api.application.ApplicationInstanceDataMethods;
import org.teamapps.application.api.privilege.OrganizationalPrivilegeGroup;
import org.teamapps.application.api.privilege.PrivilegeGroup;
import org.teamapps.application.api.privilege.StandardPrivilegeGroup;
import org.teamapps.application.api.theme.ApplicationIcons;
import org.teamapps.application.api.ui.FormMetaFields;
import org.teamapps.application.tools.EntityModelBuilder;
import org.teamapps.application.ux.form.FormController;
import org.teamapps.common.format.Color;
import org.teamapps.databinding.TwoWayBindableValue;
import org.teamapps.icons.Icon;
import org.teamapps.icons.composite.CompositeIcon;
import org.teamapps.model.controlcenter.OrganizationUnitView;
import org.teamapps.universaldb.pojo.Entity;
import org.teamapps.universaldb.pojo.Query;
import org.teamapps.ux.application.perspective.Perspective;
import org.teamapps.ux.application.view.View;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.field.combobox.ComboBox;
import org.teamapps.ux.component.form.AbstractForm;
import org.teamapps.ux.component.form.ResponsiveForm;
import org.teamapps.ux.component.form.ResponsiveFormLayout;
import org.teamapps.ux.component.itemview.SimpleItemGroup;
import org.teamapps.ux.component.itemview.SimpleItemView;
import org.teamapps.ux.component.timegraph.TimeGraph;
import org.teamapps.ux.component.toolbar.Toolbar;
import org.teamapps.ux.component.toolbar.ToolbarButton;
import org.teamapps.ux.component.toolbar.ToolbarButtonGroup;
import org.teamapps.ux.component.window.Window;

public class MasterDetailController<ENTITY extends Entity<ENTITY>>
implements ApplicationInstanceDataMethods {
    private final Icon entityIcon;
    private final String entityTitle;
    private final ApplicationInstanceData applicationInstanceData;
    private final EntityModelBuilder<ENTITY> entityModelBuilder;
    private final FormController<ENTITY> formController;
    private final ResponsiveForm<ENTITY> responsiveForm;
    private DetailPosition detailPosition = DetailPosition.RIGHT;
    private Component masterComponent;
    private Component detailComponent;
    private PrivilegeGroup privilegeGroup;
    private boolean singleViewMenu;
    private View timeGraphView;
    private View masterView;
    private View detailViewRight;
    private View detailViewBottom;
    private Window window;
    private TimeGraph timeGraph;
    private ComboBox<String> timeGraphFieldSelectionCombobox;
    private Toolbar formToolbar;
    private ToolbarButton windowCloseButton;
    private ToolbarButton editorNextButton;
    private ToolbarButton editorPreviousButton;

    public MasterDetailController(Icon entityIcon, String entityTitle, ApplicationInstanceData applicationInstanceData, EntityModelBuilder<ENTITY> entityModelBuilder, FormController<ENTITY> formController, ResponsiveForm<ENTITY> responsiveForm) {
        this.entityIcon = entityIcon;
        this.entityTitle = entityTitle;
        this.applicationInstanceData = applicationInstanceData;
        this.entityModelBuilder = entityModelBuilder;
        this.formController = formController;
        this.responsiveForm = responsiveForm;
        this.init();
    }

    public MasterDetailController(Icon entityIcon, String entityTitle, ApplicationInstanceData applicationInstanceData, Supplier<Query<ENTITY>> querySupplier, StandardPrivilegeGroup standardPrivilegeGroup) {
        this.entityIcon = entityIcon;
        this.entityTitle = entityTitle;
        this.applicationInstanceData = applicationInstanceData;
        this.entityModelBuilder = new EntityModelBuilder<ENTITY>(querySupplier, applicationInstanceData);
        this.responsiveForm = new ResponsiveForm(120, 120, 0);
        this.formController = new FormController<Entity>(applicationInstanceData, (AbstractForm<?, Entity>)this.responsiveForm, (TwoWayBindableValue<Entity>)this.entityModelBuilder.getSelectedRecordBindableValue(), () -> (Entity)this.entityModelBuilder.getEntityBuilder().build(), standardPrivilegeGroup);
        this.init();
    }

    public MasterDetailController(Icon entityIcon, String entityTitle, ApplicationInstanceData applicationInstanceData, Supplier<Query<ENTITY>> querySupplier, OrganizationalPrivilegeGroup organizationalPrivilegeGroup) {
        this.entityIcon = entityIcon;
        this.entityTitle = entityTitle;
        this.applicationInstanceData = applicationInstanceData;
        this.entityModelBuilder = new EntityModelBuilder<ENTITY>(querySupplier, applicationInstanceData);
        this.responsiveForm = new ResponsiveForm(120, 120, 0);
        this.formController = new FormController<Entity>(applicationInstanceData, (AbstractForm<?, Entity>)this.responsiveForm, (TwoWayBindableValue<Entity>)this.entityModelBuilder.getSelectedRecordBindableValue(), () -> (Entity)this.entityModelBuilder.getEntityBuilder().build(), organizationalPrivilegeGroup, (Function<Entity, OrganizationUnitView>)this.entityModelBuilder.createEntityOrganizationUnitViewFunction());
        this.init();
    }

    private void init() {
        this.formController.registerModelBuilder(this.entityModelBuilder);
        this.detailComponent = this.responsiveForm;
        this.timeGraph = this.entityModelBuilder.createTimeGraph();
        this.timeGraphFieldSelectionCombobox = this.entityModelBuilder.createTimeGraphFieldSelectionCombobox(this.timeGraph);
        this.entityModelBuilder.getOnSelectionEvent().addListener(entity -> {
            if (this.detailPosition == DetailPosition.WINDOW) {
                this.window.show();
            }
        });
    }

    public void createViews(Perspective perspective, Component masterComponent, ResponsiveFormLayout formLayout) {
        this.createViews(perspective, masterComponent, formLayout, true);
    }

    public void createViews(Perspective perspective, Component masterComponent, ResponsiveFormLayout formLayout, boolean withMetaFields) {
        this.masterComponent = masterComponent;
        this.timeGraphView = perspective.addView(View.createView((String)"top", (Icon)ApplicationIcons.CHART_LINE, (String)this.getLocalized("org.teamapps.dictionary.timeline", new Object[0]), null));
        this.masterView = perspective.addView(View.createView((String)"center", (Icon)this.entityIcon, (String)this.entityTitle, (Component)masterComponent));
        this.detailViewRight = perspective.addView(View.createView((String)"right", (Icon)this.entityIcon, (String)this.entityTitle, null));
        this.detailViewBottom = perspective.addView(View.createView((String)"center-bottom", (Icon)this.entityIcon, (String)this.entityTitle, null));
        this.detailViewRight.getPanel().setBodyBackgroundColor((Color)Color.WHITE.withAlpha(0.9f));
        this.detailViewBottom.getPanel().setBodyBackgroundColor((Color)Color.WHITE.withAlpha(0.9f));
        this.timeGraphView.setVisible(false);
        this.detailViewBottom.setVisible(false);
        this.timeGraphView.getPanel().setRightHeaderField(this.timeGraphFieldSelectionCombobox);
        this.timeGraphView.setComponent((Component)this.timeGraph);
        this.entityModelBuilder.attachViewCountHandler(this.masterView, () -> this.entityTitle);
        this.entityModelBuilder.attachSearchField(this.masterView);
        this.formController.registerView(this.detailViewRight);
        this.detailViewRight.setComponent(this.responsiveForm);
        this.window = new Window(1200, 800, null);
        this.window.setTitle(this.entityTitle);
        this.window.setIcon(this.entityIcon);
        this.window.setCloseable(true);
        this.window.setMaximizable(true);
        this.window.setCloseOnEscape(true);
        this.formToolbar = this.detailViewRight.getPanel().getToolbar();
        ToolbarButtonGroup buttonGroup = this.formToolbar.addButtonGroup(new ToolbarButtonGroup());
        this.editorPreviousButton = buttonGroup.addButton(ToolbarButton.createSmall((Icon)ApplicationIcons.NAVIGATE_LEFT, (String)this.getLocalized("org.teamapps.dictionary.previous", new Object[0])));
        this.editorNextButton = buttonGroup.addButton(ToolbarButton.createSmall((Icon)ApplicationIcons.NAVIGATE_RIGHT, (String)this.getLocalized("org.teamapps.dictionary.next", new Object[0])));
        this.editorPreviousButton.setVisible(false);
        this.editorNextButton.setVisible(false);
        buttonGroup = this.formToolbar.addButtonGroup(new ToolbarButtonGroup());
        this.windowCloseButton = buttonGroup.addButton(ToolbarButton.createSmall((Icon)ApplicationIcons.WINDOW_CLOSE, (String)this.getLocalized("org.teamapps.dictionary.close", new Object[0])));
        this.windowCloseButton.setVisible(false);
        this.editorPreviousButton.onClick.addListener(this.entityModelBuilder::selectPreviousRecord);
        this.editorNextButton.onClick.addListener(this.entityModelBuilder::selectNextRecord);
        this.windowCloseButton.onClick.addListener(() -> this.window.close());
        if (withMetaFields) {
            FormMetaFields formMetaFields = this.getApplicationInstanceData().getComponentFactory().createFormMetaFields();
            formMetaFields.addMetaFields(formLayout, false);
            this.entityModelBuilder.getOnSelectionEvent().addListener(formMetaFields::updateEntity);
        }
        this.createToolbarButtons(perspective);
    }

    public void setDetailComponent(Component detailComponent) {
        this.detailComponent = detailComponent;
        this.setDetailPosition(this.detailPosition);
    }

    private void createToolbarButtons(Perspective perspective) {
        ToolbarButtonGroup buttonGroup = perspective.addWorkspaceButtonGroup(new ToolbarButtonGroup());
        ToolbarButton showTimeGraphButton = buttonGroup.addButton(ToolbarButton.create((Icon)ApplicationIcons.CHART_LINE, (String)this.getLocalized("org.teamapps.dictionary.timeline", new Object[0]), (String)this.getLocalized("org.teamapps.dictionary.timeline", new Object[0])));
        ToolbarButton hideTimeGraphButton = buttonGroup.addButton(ToolbarButton.create((Icon)CompositeIcon.of((Icon)ApplicationIcons.CHART_LINE, (Icon)ApplicationIcons.ERROR), (String)this.getLocalized("org.teamapps.dictionary.timeline", new Object[0]), (String)this.getLocalized("org.teamapps.dictionary.timeline", new Object[0])));
        hideTimeGraphButton.setVisible(false);
        buttonGroup = perspective.addWorkspaceButtonGroup(new ToolbarButtonGroup());
        ToolbarButton showDeletedButton = buttonGroup.addButton(ToolbarButton.create((Icon)ApplicationIcons.GARBAGE_EMPTY, (String)this.getLocalized("org.teamapps.dictionary.recycleBin", new Object[0]), (String)this.getLocalized("org.teamapps.dictionary.showRecycleBin", new Object[0])));
        ToolbarButton hideDeletedButton = buttonGroup.addButton(ToolbarButton.create((Icon)CompositeIcon.of((Icon)ApplicationIcons.GARBAGE_EMPTY, (Icon)ApplicationIcons.ERROR), (String)this.getLocalized("org.teamapps.dictionary.recycleBin", new Object[0]), (String)this.getLocalized("org.teamapps.dictionary.recycleBin", new Object[0])));
        hideDeletedButton.setVisible(false);
        buttonGroup = perspective.addWorkspaceButtonGroup(new ToolbarButtonGroup());
        ToolbarButton viewButton = buttonGroup.addButton(ToolbarButton.create((Icon)ApplicationIcons.WINDOWS, (String)this.getLocalized("org.teamapps.dictionary.view", new Object[0]), (String)this.getLocalized("org.teamapps.dictionary.view", new Object[0])));
        viewButton.setDroDownPanelWidth(400);
        SimpleItemView simpleItemView = new SimpleItemView();
        SimpleItemGroup itemGroup = simpleItemView.addSingleColumnGroup(ApplicationIcons.WINDOWS, this.getLocalized("org.teamapps.dictionary.view", new Object[0]));
        itemGroup.addItem((Icon)ApplicationIcons.WINDOW_SPLIT_HOR, (String)this.getLocalized((String)"org.teamapps.dictionary.editorPaneOnTheRight", (Object[])new Object[0]), (String)this.getLocalized((String)"org.teamapps.dictionary.displayTheEditorPaneOnTheRightSide", (Object[])new Object[0])).onClick.addListener(() -> this.setDetailPosition(DetailPosition.RIGHT));
        itemGroup.addItem((Icon)ApplicationIcons.WINDOW_SPLIT_VER, (String)this.getLocalized((String)"org.teamapps.dictionary.editorPaneBelow", (Object[])new Object[0]), (String)this.getLocalized((String)"org.teamapps.dictionary.displayTheEditorPaneBelowTheMasterView", (Object[])new Object[0])).onClick.addListener(() -> this.setDetailPosition(DetailPosition.BOTTOM));
        itemGroup.addItem((Icon)ApplicationIcons.WINDOW_DIALOG, (String)this.getLocalized((String)"org.teamapps.dictionary.centralEditorPane", (Object[])new Object[0]), (String)this.getLocalized((String)"org.teamapps.dictionary.displayTheEditorPaneInTheCenter", (Object[])new Object[0])).onClick.addListener(() -> this.setDetailPosition(DetailPosition.CENTER));
        itemGroup.addItem((Icon)ApplicationIcons.WINDOWS, (String)this.getLocalized((String)"org.teamapps.dictionary.editorPaneAsWindow", (Object[])new Object[0]), (String)this.getLocalized((String)"org.teamapps.dictionary.displayTheEditorPaneAsPopupWindow", (Object[])new Object[0])).onClick.addListener(() -> this.setDetailPosition(DetailPosition.WINDOW));
        viewButton.setDropDownComponent((Component)simpleItemView);
        showTimeGraphButton.onClick.addListener(() -> {
            showTimeGraphButton.setVisible(false);
            hideTimeGraphButton.setVisible(true);
            this.showTimeGraph(true);
        });
        hideTimeGraphButton.onClick.addListener(() -> {
            hideTimeGraphButton.setVisible(false);
            showTimeGraphButton.setVisible(true);
            this.showTimeGraph(false);
        });
        showDeletedButton.onClick.addListener(() -> {
            showDeletedButton.setVisible(false);
            hideDeletedButton.setVisible(true);
            this.entityModelBuilder.setShowDeletedRecords(true);
        });
        hideDeletedButton.onClick.addListener(() -> {
            showDeletedButton.setVisible(true);
            hideDeletedButton.setVisible(false);
            this.entityModelBuilder.setShowDeletedRecords(false);
        });
    }

    public void setDetailPosition(DetailPosition position) {
        this.detailPosition = position;
        this.masterView.setVisible(true);
        this.window.setToolbar(null);
        this.window.setContent(null);
        this.windowCloseButton.setVisible(false);
        this.editorPreviousButton.setVisible(false);
        this.editorNextButton.setVisible(false);
        switch (position) {
            case RIGHT: {
                this.detailViewBottom.setVisible(false);
                this.detailViewBottom.setComponent(null);
                this.detailViewBottom.getPanel().setToolbar(null);
                this.detailViewRight.getPanel().setToolbar(this.formToolbar);
                this.detailViewRight.setComponent(this.detailComponent);
                this.detailViewRight.setVisible(true);
                break;
            }
            case BOTTOM: {
                this.detailViewRight.setVisible(false);
                this.detailViewRight.setComponent(null);
                this.detailViewRight.getPanel().setToolbar(null);
                this.detailViewBottom.getPanel().setToolbar(this.formToolbar);
                this.detailViewBottom.setComponent(this.detailComponent);
                this.detailViewBottom.setVisible(true);
                break;
            }
            case CENTER: {
                this.masterView.setVisible(false);
                this.detailViewBottom.setVisible(false);
                this.detailViewBottom.setComponent(null);
                this.detailViewBottom.getPanel().setToolbar(null);
                this.detailViewRight.getPanel().setToolbar(this.formToolbar);
                this.detailViewRight.setComponent(this.detailComponent);
                this.detailViewRight.setVisible(true);
                this.editorPreviousButton.setVisible(true);
                this.editorNextButton.setVisible(true);
                break;
            }
            case WINDOW: {
                this.detailViewBottom.setVisible(false);
                this.detailViewBottom.setComponent(null);
                this.detailViewRight.setVisible(false);
                this.detailViewRight.setComponent(null);
                this.detailViewRight.getPanel().setToolbar(null);
                this.detailViewBottom.getPanel().setToolbar(null);
                this.window.setToolbar(this.formToolbar);
                this.window.setContent(this.detailComponent);
                this.windowCloseButton.setVisible(true);
                this.editorPreviousButton.setVisible(true);
                this.editorNextButton.setVisible(true);
            }
        }
    }

    public void showTimeGraph(boolean show) {
        this.timeGraphView.setVisible(show);
    }

    @Override
    public ApplicationInstanceData getApplicationInstanceData() {
        return this.applicationInstanceData;
    }

    public EntityModelBuilder<ENTITY> getEntityModelBuilder() {
        return this.entityModelBuilder;
    }

    public FormController<ENTITY> getFormController() {
        return this.formController;
    }

    public ResponsiveForm<ENTITY> getResponsiveForm() {
        return this.responsiveForm;
    }

    public View getTimeGraphView() {
        return this.timeGraphView;
    }

    public View getMasterView() {
        return this.masterView;
    }

    public View getDetailViewRight() {
        return this.detailViewRight;
    }

    public View getDetailViewBottom() {
        return this.detailViewBottom;
    }

    public static enum DetailPosition {
        RIGHT,
        BOTTOM,
        CENTER,
        WINDOW;

    }
}

