/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.model.controlcenter;

import java.util.BitSet;
import java.util.List;
import org.teamapps.model.controlcenter.AddressView;
import org.teamapps.universaldb.index.ColumnIndex;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.index.numeric.FloatIndex;
import org.teamapps.universaldb.index.text.TextIndex;
import org.teamapps.universaldb.pojo.AbstractUdbEntity;
import org.teamapps.universaldb.pojo.EntityBitSetList;
import org.teamapps.universaldb.transaction.Transaction;
import org.teamapps.universaldb.transaction.TransactionRecordValue;

public class UdbAddressView
extends AbstractUdbEntity<AddressView>
implements AddressView {
    protected static TableIndex table;
    protected static TextIndex name;
    protected static TextIndex organisation;
    protected static TextIndex street;
    protected static TextIndex city;
    protected static TextIndex dependentLocality;
    protected static TextIndex state;
    protected static TextIndex postalCode;
    protected static TextIndex country;
    protected static FloatIndex latitude;
    protected static FloatIndex longitude;

    private static void setTableIndex(TableIndex tableIndex) {
        table = tableIndex;
        name = (TextIndex)tableIndex.getColumnIndex("name");
        organisation = (TextIndex)tableIndex.getColumnIndex("organisation");
        street = (TextIndex)tableIndex.getColumnIndex("street");
        city = (TextIndex)tableIndex.getColumnIndex("city");
        dependentLocality = (TextIndex)tableIndex.getColumnIndex("dependentLocality");
        state = (TextIndex)tableIndex.getColumnIndex("state");
        postalCode = (TextIndex)tableIndex.getColumnIndex("postalCode");
        country = (TextIndex)tableIndex.getColumnIndex("country");
        latitude = (FloatIndex)tableIndex.getColumnIndex("latitude");
        longitude = (FloatIndex)tableIndex.getColumnIndex("longitude");
    }

    public static List<AddressView> getAll() {
        return new EntityBitSetList(AddressView.getBuilder(), table.getRecordBitSet());
    }

    public static List<AddressView> sort(List<AddressView> list, String sortFieldName, boolean ascending, String ... path) {
        return UdbAddressView.sort((TableIndex)table, list, (String)sortFieldName, (boolean)ascending, (String[])path);
    }

    public static List<AddressView> sort(BitSet recordIds, String sortFieldName, boolean ascending, String ... path) {
        return UdbAddressView.sort((TableIndex)table, AddressView.getBuilder(), (BitSet)recordIds, (String)sortFieldName, (boolean)ascending, (String[])path);
    }

    public static int getCount() {
        return table.getCount();
    }

    public UdbAddressView() {
        super(table);
    }

    public UdbAddressView(int id, boolean createEntity) {
        super(table, id, createEntity);
    }

    public AddressView build() {
        return new UdbAddressView();
    }

    public AddressView build(int id) {
        return new UdbAddressView(id, false);
    }

    @Override
    public String getName() {
        return this.getTextValue(name);
    }

    @Override
    public String getOrganisation() {
        return this.getTextValue(organisation);
    }

    @Override
    public String getStreet() {
        return this.getTextValue(street);
    }

    @Override
    public String getCity() {
        return this.getTextValue(city);
    }

    @Override
    public String getDependentLocality() {
        return this.getTextValue(dependentLocality);
    }

    @Override
    public String getState() {
        return this.getTextValue(state);
    }

    @Override
    public String getPostalCode() {
        return this.getTextValue(postalCode);
    }

    @Override
    public String getCountry() {
        return this.getTextValue(country);
    }

    @Override
    public float getLatitude() {
        return this.getFloatValue(latitude);
    }

    @Override
    public float getLongitude() {
        return this.getFloatValue(longitude);
    }

    public UdbAddressView save(Transaction transaction, boolean strictChangeVerification) {
        throw new UnsupportedOperationException();
    }

    public UdbAddressView saveTransactional(boolean strictChangeVerification) {
        throw new UnsupportedOperationException();
    }

    public UdbAddressView save() {
        throw new UnsupportedOperationException();
    }

    public void delete(Transaction transaction) {
        throw new UnsupportedOperationException();
    }

    public void delete() {
        throw new UnsupportedOperationException();
    }

    public void restoreDeleted() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(table.getName()).append(": ").append(this.getId()).append("\n");
        for (ColumnIndex column : table.getColumnIndices()) {
            sb.append("\t").append(column.getName()).append(": ").append(column.getStringValue(this.getId()));
            if (this.isChanged(column)) {
                TransactionRecordValue changeValue = this.getChangeValue(column);
                sb.append(" -> ").append(changeValue.getValue());
            }
            sb.append("\n");
        }
        return sb.toString();
    }
}

