/*-
 * ========================LICENSE_START=================================
 * TeamApps Application API
 * ---
 * Copyright (C) 2020 - 2021 TeamApps.org
 * ---
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =========================LICENSE_END==================================
 */
package org.teamapps.application.api.localization;

public class Dictionary {
	//standard operations
	public static final String ADD = "org.teamapps.dictionary.add";
	public static final String ADD_RECORD = "org.teamapps.dictionary.addRecord";
	public static final String EDIT = "org.teamapps.dictionary.edit";
	public static final String CREATE = "org.teamapps.dictionary.create";
	public static final String READ = "org.teamapps.dictionary.read";
	public static final String UPDATE = "org.teamapps.dictionary.update";
	public static final String REVERT = "org.teamapps.dictionary.revert";
	public static final String RESTORE = "org.teamapps.dictionary.restore";
	public static final String RESTORE_RECORD = "org.teamapps.dictionary.restoreRecord";
	public static final String REFRESH = "org.teamapps.dictionary.refresh";
	public static final String REVERT_CHANGES = "org.teamapps.dictionary.revertChanges";
	public static final String REMOVE = "org.teamapps.dictionary.remove";
	public static final String REMOVE_SELECTION = "org.teamapps.dictionary.removeSelection";
	public static final String REMOVE_ALL_FILTERS = "org.teamapps.dictionary.removeAllFilters";
	public static final String DELETE = "org.teamapps.dictionary.delete";
	public static final String DELETE_RECORD = "org.teamapps.dictionary.deleteRecord";
	public static final String EXECUTE = "org.teamapps.dictionary.execute";
	public static final String PRINT = "org.teamapps.dictionary.print";
	public static final String APPLY = "org.teamapps.dictionary.apply";
	public static final String CUSTOM = "org.teamapps.dictionary.custom";
	public static final String SAVE = "org.teamapps.dictionary.save";
	public static final String SAVE_CHANGES = "org.teamapps.dictionary.saveChanges";
	public static final String SAVE_CLOSE = "org.teamapps.dictionary.saveClose";
	public static final String SAVE_AND_CLOSE_WINDOW = "org.teamapps.dictionary.saveAndCloseWindow";
	public static final String CANCEL = "org.teamapps.dictionary.cancel";
	public static final String CANCEL_CLOSE = "org.teamapps.dictionary.cancelClose";
	public static final String CANCEL_AND_CLOSE_WINDOW = "org.teamapps.dictionary.cancelAndCloseWindow";
	public static final String CLOSE = "org.teamapps.dictionary.close";
	public static final String SELECT = "org.teamapps.dictionary.select";
	public static final String SELECT_AREA = "org.teamapps.dictionary.selectArea";
	public static final String SELECT_RECORDS = "org.teamapps.dictionary.selectRecords";
	public static final String SELECT_ROWS = "org.teamapps.dictionary.selectRows";
	public static final String UNSELECT = "org.teamapps.dictionary.unselect";
	public static final String PLAY = "org.teamapps.dictionary.play";
	public static final String PAUSE = "org.teamapps.dictionary.pause";
	public static final String STOP = "org.teamapps.dictionary.stop";
	public static final String RECORD = "org.teamapps.dictionary.record";
	public static final String HELP = "org.teamapps.dictionary.help";
	public static final String UPLOAD = "org.teamapps.dictionary.upload";
	public static final String DOWNLOAD = "org.teamapps.dictionary.download";
	public static final String ERROR = "org.teamapps.dictionary.error";
	public static final String MOVE_UP = "org.teamapps.dictionary.moveUp";
	public static final String MOVE_DOWN = "org.teamapps.dictionary.moveDown";
	public static final String MOVE_LEFT = "org.teamapps.dictionary.moveLeft";
	public static final String MOVE_RIGHT = "org.teamapps.dictionary.moveRight";
	public static final String MOVE_CENTER = "org.teamapps.dictionary.moveCenter";
	public static final String HIDE = "org.teamapps.dictionary.hide";
	public static final String SHOW = "org.teamapps.dictionary.show";
	public static final String HIDDEN = "org.teamapps.dictionary.hidden";
	public static final String VISIBLE = "org.teamapps.dictionary.visible";
	public static final String CAPTION = "org.teamapps.dictionary.caption";
	public static final String KEY = "org.teamapps.dictionary.key";
	public static final String VALUE = "org.teamapps.dictionary.value";
	public static final String DONE = "org.teamapps.dictionary.done";
	public static final String REJECT = "org.teamapps.dictionary.reject";
	public static final String UNCLEAR = "org.teamapps.dictionary.unclear";
	public static final String VERIFIED = "org.teamapps.dictionary.verified";
	public static final String INCORRECT = "org.teamapps.dictionary.incorrect";
	public static final String CHECKED = "org.teamapps.dictionary.checked";
	public static final String OVERVIEW = "org.teamapps.dictionary.overview";
	public static final String PREVIEW = "org.teamapps.dictionary.preview";
	public static final String PREVIEW_IMAGE = "org.teamapps.dictionary.previewImage";
	public static final String COPY = "org.teamapps.dictionary.copy";
	public static final String ZOOM_IN = "org.teamapps.dictionary.zoomIn";
	public static final String ZOOM_OUT = "org.teamapps.dictionary.zoomOut";
	public static final String INCREASE = "org.teamapps.dictionary.increase";
	public static final String DECREASE = "org.teamapps.dictionary.decrease";
	public static final String IMPORT = "org.teamapps.dictionary.import";
	public static final String EXPORT = "org.teamapps.dictionary.export";
	public static final String RECYCLE_BIN = "org.teamapps.dictionary.recycleBin";
	public static final String SHOW_RECYCLE_BIN = "org.teamapps.dictionary.showRecycleBin";
	public static final String NEW = "org.teamapps.dictionary.new";
	public static final String RESET = "org.teamapps.dictionary.reset";
	public static final String DISCARD = "org.teamapps.dictionary.discard";
	public static final String OVERWRITE = "org.teamapps.dictionary.overwrite";
	public static final String PUBLISH = "org.teamapps.dictionary.publish";
	//options
	public static final String O_K = "org.teamapps.dictionary.oK";
	public static final String YES = "org.teamapps.dictionary.yes";
	public static final String NO = "org.teamapps.dictionary.no";
	public static final String BACK = "org.teamapps.dictionary.back";
	public static final String SEARCH = "org.teamapps.dictionary.search";
	public static final String SEARCH___ = "org.teamapps.dictionary.search___";
	public static final String VIEW = "org.teamapps.dictionary.view";
	public static final String VIEWS = "org.teamapps.dictionary.views";
	public static final String MENU = "org.teamapps.dictionary.menu";
	public static final String TREE = "org.teamapps.dictionary.tree";
	public static final String TABLE = "org.teamapps.dictionary.table";
	public static final String LIST = "org.teamapps.dictionary.list";
	public static final String FORM = "org.teamapps.dictionary.form";
	public static final String TIMELINE = "org.teamapps.dictionary.timeline";
	public static final String MEDIA = "org.teamapps.dictionary.media";
	public static final String MAP = "org.teamapps.dictionary.map";
	public static final String CALENDAR = "org.teamapps.dictionary.calendar";
	public static final String NETWORK = "org.teamapps.dictionary.network";
	//user data
	public static final String SALUTATION = "org.teamapps.dictionary.salutation";
	public static final String NAME = "org.teamapps.dictionary.name";
	public static final String FIRST_NAME = "org.teamapps.dictionary.firstName";
	public static final String LAST_NAME = "org.teamapps.dictionary.lastName";
	public static final String PHONE_NUMBER = "org.teamapps.dictionary.phoneNumber";
	public static final String MOBILE_NUMBER = "org.teamapps.dictionary.mobileNumber";
	public static final String E_MAIL = "org.teamapps.dictionary.eMail";
	public static final String LANGUAGE = "org.teamapps.dictionary.language";
	public static final String ALL_LANGUAGES = "org.teamapps.dictionary.allLanguages";
	public static final String MY_MAIN_LANGUAGE = "org.teamapps.dictionary.myMainLanguage";
	public static final String ALL_MY_LANGUAGES = "org.teamapps.dictionary.allMyLanguages";
	public static final String BIRTHDATE = "org.teamapps.dictionary.birthdate";
	//address
	public static final String ADDRESS = "org.teamapps.dictionary.address";
	public static final String POSTAL_ADDRESS = "org.teamapps.dictionary.postalAddress";
	public static final String ORGANIZATION = "org.teamapps.dictionary.organization";
	public static final String STREET = "org.teamapps.dictionary.street";
	public static final String CITY = "org.teamapps.dictionary.city";
	public static final String DEPENDENT_LOCALITY = "org.teamapps.dictionary.dependentLocality";
	public static final String POSTAL_CODE = "org.teamapps.dictionary.postalCode";
	public static final String STATE = "org.teamapps.dictionary.state";
	public static final String COUNTRY = "org.teamapps.dictionary.country";
	public static final String P_OBOX = "org.teamapps.dictionary.pOBox";
	public static final String LATITUDE = "org.teamapps.dictionary.latitude";
	public static final String LONGITUDE = "org.teamapps.dictionary.longitude";
	//reports
	public static final String CURRENCY = "org.teamapps.dictionary.currency";
	public static final String MAX = "org.teamapps.dictionary.max";
	public static final String MIN = "org.teamapps.dictionary.min";
	public static final String SUM = "org.teamapps.dictionary.sum";
	public static final String AVERAGE = "org.teamapps.dictionary.average";
	//login
	public static final String LOGIN = "org.teamapps.dictionary.login";
	public static final String LOGOUT = "org.teamapps.dictionary.logout";
	public static final String USER_NAME = "org.teamapps.dictionary.userName";
	public static final String USER_ID = "org.teamapps.dictionary.userID";
	public static final String PASSWORD = "org.teamapps.dictionary.password";
	public static final String RETYPE_PASSWORD = "org.teamapps.dictionary.retypePassword";
	public static final String RESET_PASSWORD = "org.teamapps.dictionary.resetPassword";
	public static final String WRONG_PASSWORD = "org.teamapps.dictionary.wrongPassword";
	public static final String WRONG_USER_NAME_OR_PASSWORD = "org.teamapps.dictionary.wrongUserNameOrPassword";
	public static final String SENTENCE_ERROR_THE_PASSWORDS_MUST_BE_IDENTIC__ = "org.teamapps.dictionary.errorThePasswordsMustBeIdentical";
	public static final String REGISTER = "org.teamapps.dictionary.register";
	public static final String CREATE_ACCOUNT = "org.teamapps.dictionary.createAccount";
	public static final String KEEP_ME_LOGGED_INTHIS_PC_IS_SECURE = "org.teamapps.dictionary.keepMeLoggedInthisPCIsSecure";
	public static final String OTHER_USER = "org.teamapps.dictionary.otherUser";
	public static final String REGISTRATION_ERROR = "org.teamapps.dictionary.registrationError";
	public static final String UNKNOWN_EMAIL_ADDRESS = "org.teamapps.dictionary.unknownEmailAddress";
	public static final String ERROR_INCORRECT_USERNAME_OR_PASSWORD = "org.teamapps.dictionary.errorIncorrectUsernameOrPassword";
	public static final String ERROR_RESETTING_THE_PASSWORD = "org.teamapps.dictionary.errorResettingThePassword";
	public static final String SESSION_TERMINATED = "org.teamapps.dictionary.sessionTerminated";
	public static final String SESSION_EXPIRED = "org.teamapps.dictionary.sessionExpired";
	public static final String SENTENCE_THE_PASSWORD_WAS_CHANGED_SUCCESSFUL__ = "org.teamapps.dictionary.thePasswordWasChangedSuccessfullyYouCanNowLogIn";
	public static final String SENTENCE_YOUR_ACCOUNT_WAS_CREATED_SUCCESSFUL__ = "org.teamapps.dictionary.yourAccountWasCreatedSuccessfullyYouCanNowLogIn";
	//record data
	public static final String META_DATA = "org.teamapps.dictionary.metaData";
	public static final String CREATION = "org.teamapps.dictionary.creation";
	public static final String MODIFICATION = "org.teamapps.dictionary.modification";
	public static final String CREATION_DATE = "org.teamapps.dictionary.creationDate";
	public static final String MODIFICATION_DATE = "org.teamapps.dictionary.modificationDate";
	public static final String DELETION_DATE = "org.teamapps.dictionary.deletionDate";
	public static final String RESTORE_DATE = "org.teamapps.dictionary.restoreDate";
	public static final String CREATED_BY = "org.teamapps.dictionary.createdBy";
	public static final String MODIFIED_BY = "org.teamapps.dictionary.modifiedBy";
	public static final String DELETED_BY = "org.teamapps.dictionary.deletedBy";
	public static final String RESTORED_BY = "org.teamapps.dictionary.restoredBy";
	public static final String DELETED = "org.teamapps.dictionary.deleted";
	public static final String RESTORED = "org.teamapps.dictionary.restored";
	public static final String LAST_RECORD = "org.teamapps.dictionary.lastRecord";
	public static final String FIRST_RECORD = "org.teamapps.dictionary.firstRecord";
	public static final String THIS_FIELD_IS_REQUIRED = "org.teamapps.dictionary.thisFieldIsRequired";
	public static final String THIS_FIELD_MUST_NOT_BE_EMPTY = "org.teamapps.dictionary.thisFieldMustNotBeEmpty";
	public static final String FIELD_VALUE_MUST_NOT_BE_EMPTY = "org.teamapps.dictionary.fieldValueMustNotBeEmpty";
	public static final String RECORD_SUCCESSFULLY_SAVED = "org.teamapps.dictionary.recordSuccessfullySaved";
	public static final String RECORD_SUCCESSFULLY_DELETED = "org.teamapps.dictionary.recordSuccessfullyDeleted";
	public static final String SENTENCE_THE_FILE_YOU_SELECTED_IS_TOO_LARGE___ = "org.teamapps.dictionary.theFileYouSelectedIsTooLargeTheMaximumAllowedFileSizeIs0";
	public static final String FILE_TOO_LARGE_MAX_SIZE0 = "org.teamapps.dictionary.fileTooLargeMaxSize0";
	public static final String SENTENCE_AN_ERROR_HAS_OCCURRED_WHILE_UPLOADI__ = "org.teamapps.dictionary.anErrorHasOccurredWhileUploadingTheFile";
	public static final String ERROR_WHILE_UPLOADING = "org.teamapps.dictionary.errorWhileUploading";
	public static final String THE_DATA_WAS_SAVED_SUCCESSFULLY = "org.teamapps.dictionary.theDataWasSavedSuccessfully";
	public static final String THE_CHANGES_WERE_SAVED_SUCCESSFULLY = "org.teamapps.dictionary.theChangesWereSavedSuccessfully";
	public static final String ERROR_WHEN_SAVING = "org.teamapps.dictionary.errorWhenSaving";
	public static final String ERROR_NOTHING_TO_DELETE = "org.teamapps.dictionary.errorNothingToDelete";
	public static final String THE_DATA_WAS_SUCCESSFULLY_DELETED = "org.teamapps.dictionary.theDataWasSuccessfullyDeleted";
	public static final String THE_RECORD_WAS_SUCCESSFULLY_CREATED = "org.teamapps.dictionary.theRecordWasSuccessfullyCreated";
	public static final String SENTENCE_DO_YOU_REALLY_WANT_TO_DELETE_THE_RE__ = "org.teamapps.dictionary.doYouReallyWantToDeleteTheRecord";
	public static final String CONFIRM_DELETION = "org.teamapps.dictionary.confirmDeletion";
	public static final String SENTENCE_DO_YOU_REALLY_WANT_TO_DELETE_ALL_DA__ = "org.teamapps.dictionary.doYouReallyWantToDeleteAllData";
	//validation
	public static final String PLEASE_ENTER_AVALUE = "org.teamapps.dictionary.pleaseEnterAValue";
	public static final String NOT_AVALID_EMAIL_ADDRESS = "org.teamapps.dictionary.notAValidEmailAddress";
	public static final String NOT_AVALID_PHONE_NUMBER = "org.teamapps.dictionary.notAValidPhoneNumber";
	public static final String NOT_AVALID_IP_ADDRESS = "org.teamapps.dictionary.notAValidIPAddress";
	public static final String NOT_AVALID_DATE = "org.teamapps.dictionary.notAValidDate";
	public static final String TEXT_ENTERED_IS_TOO_SHORT = "org.teamapps.dictionary.textEnteredIsTooShort";
	public static final String TEXT_ENTERED_IS_TOO_LONG = "org.teamapps.dictionary.textEnteredIsTooLong";
	public static final String SENTENCE_THE_FIELD_MUST_CONTAIN_AT_LEAST0_CH__ = "org.teamapps.dictionary.theFieldMustContainAtLeast0Characters";
	public static final String SENTENCE_THE_FIELD0_MUST_CONTAIN_AT_LEAST1_C__ = "org.teamapps.dictionary.theField0MustContainAtLeast1Characters";
	public static final String SENTENCE_THE_FIELD_MUST_CONTAIN_LESS_THAN0_C__ = "org.teamapps.dictionary.theFieldMustContainLessThan0Characters";
	//calendar
	public static final String YEAR = "org.teamapps.dictionary.year";
	public static final String YEARS = "org.teamapps.dictionary.years";
	public static final String MONTH = "org.teamapps.dictionary.month";
	public static final String MONTHS = "org.teamapps.dictionary.months";
	public static final String WEEK = "org.teamapps.dictionary.week";
	public static final String WEEKS = "org.teamapps.dictionary.weeks";
	public static final String DAY = "org.teamapps.dictionary.day";
	public static final String DAYS = "org.teamapps.dictionary.days";
	public static final String HOUR = "org.teamapps.dictionary.hour";
	public static final String HOURS = "org.teamapps.dictionary.hours";
	public static final String MINUTE = "org.teamapps.dictionary.minute";
	public static final String MINUTES = "org.teamapps.dictionary.minutes";
	public static final String SECOND = "org.teamapps.dictionary.second";
	public static final String SECONDS = "org.teamapps.dictionary.seconds";
	public static final String TODAY = "org.teamapps.dictionary.today";
	public static final String NOW = "org.teamapps.dictionary.now";
	public static final String PREVIOUS = "org.teamapps.dictionary.previous";
	public static final String NEXT = "org.teamapps.dictionary.next";
	public static final String DATE = "org.teamapps.dictionary.date";
	public static final String TIME = "org.teamapps.dictionary.time";
	public static final String TIMESTAMP = "org.teamapps.dictionary.timestamp";
	public static final String DURATION = "org.teamapps.dictionary.duration";
	//grouping
	public static final String GROUP = "org.teamapps.dictionary.group";
	public static final String GROUPING = "org.teamapps.dictionary.grouping";
	public static final String BY_FULL_VALUE = "org.teamapps.dictionary.byFullValue";
	public static final String BY_WORDS = "org.teamapps.dictionary.byWords";
	public static final String BY_YEARS = "org.teamapps.dictionary.byYears";
	public static final String BY_QUARTERS = "org.teamapps.dictionary.byQuarters";
	public static final String BY_MONTHS = "org.teamapps.dictionary.byMonths";
	public static final String BY_WEEKS = "org.teamapps.dictionary.byWeeks";
	public static final String BY_DAYS = "org.teamapps.dictionary.byDays";
	public static final String VALUES = "org.teamapps.dictionary.values";
	public static final String COUNT = "org.teamapps.dictionary.count";
	public static final String FILTER = "org.teamapps.dictionary.filter";
	public static final String EMPTY = "org.teamapps.dictionary.empty";
	//base system
	public static final String LAUNCH_APPLICATION = "org.teamapps.dictionary.launchApplication";
	public static final String SENTENCE_ALLOWS_AUSER_TO_LAUNCH_THE_APPLICAT__ = "org.teamapps.dictionary.allowsAUserToLaunchTheApplication";
	public static final String APPLICATION_LAUNCHER = "org.teamapps.dictionary.applicationLauncher";
	public static final String OPEN_NEW_APPLICATION = "org.teamapps.dictionary.openNewApplication";
	public static final String APPLICATION_MENU = "org.teamapps.dictionary.applicationMenu";
	public static final String SELECT_APPLICATION_PERSPECTIVE = "org.teamapps.dictionary.selectApplicationPerspective";
	public static final String PRIVILEGES = "org.teamapps.dictionary.privileges";
	public static final String TRANSLATION_KEY = "org.teamapps.dictionary.translationKey";
	public static final String ERROR_TRANSLATION_KEY_ALREADY_EXISTS = "org.teamapps.dictionary.errorTranslationKeyAlreadyExists";
	public static final String SENTENCE_ERROR_THE_ACTIVE_APPLICATION_CAUSED__ = "org.teamapps.dictionary.errorTheActiveApplicationCausedAnErrorAnWillBeClosed";
	public static final String WELCOME = "org.teamapps.dictionary.welcome";
	public static final String TRANSLATION = "org.teamapps.dictionary.translation";
	public static final String TRANSLATIONS = "org.teamapps.dictionary.translations";
	public static final String EDITOR_PANE = "org.teamapps.dictionary.editorPane";
	public static final String EDITOR_PANE_BELOW = "org.teamapps.dictionary.editorPaneBelow";
	public static final String EDITOR_PANE_ON_THE_RIGHT = "org.teamapps.dictionary.editorPaneOnTheRight";
	public static final String EDITOR_PANE_AS_WINDOW = "org.teamapps.dictionary.editorPaneAsWindow";
	public static final String CENTRAL_EDITOR_PANE = "org.teamapps.dictionary.centralEditorPane";
	public static final String SENTENCE_DISPLAY_THE_EDITOR_PANE_ON_THE_RIGH__ = "org.teamapps.dictionary.displayTheEditorPaneOnTheRightSide";
	public static final String SENTENCE_DISPLAY_THE_EDITOR_PANE_BELOW_THE_M__ = "org.teamapps.dictionary.displayTheEditorPaneBelowTheMasterView";
	public static final String SENTENCE_DISPLAY_THE_EDITOR_PANE_AS_POPUP_WI__ = "org.teamapps.dictionary.displayTheEditorPaneAsPopupWindow";
	public static final String SENTENCE_DISPLAY_THE_EDITOR_PANE_IN_THE_CENT__ = "org.teamapps.dictionary.displayTheEditorPaneInTheCenter";
	//other
	public static final String ROTATE = "org.teamapps.dictionary.rotate";
	public static final String ROTATE_PICTURE = "org.teamapps.dictionary.rotatePicture";
	public static final String CROP_IMAGE = "org.teamapps.dictionary.cropImage";
	public static final String NO_RUNNING_TASKS = "org.teamapps.dictionary.noRunningTasks";
	public static final String ERROR_UNKNOWN_LINK = "org.teamapps.dictionary.errorUnknownLink";
	public static final String APPLICATIONS = "org.teamapps.dictionary.applications";
	public static final String APPLICATION = "org.teamapps.dictionary.application";
	public static final String APPLICATION_PERSPECTIVE = "org.teamapps.dictionary.applicationPerspective";
	public static final String PERSPECTIVE = "org.teamapps.dictionary.perspective";
	public static final String HOME = "org.teamapps.dictionary.home";
	public static final String ADMINISTRATION = "org.teamapps.dictionary.administration";
	public static final String PREFERENCES = "org.teamapps.dictionary.preferences";
	public static final String OPTIONAL = "org.teamapps.dictionary.optional";
	public static final String LOCATION = "org.teamapps.dictionary.location";
	public static final String DATABASE = "org.teamapps.dictionary.database";
	//countries
	public static final String COUNTRY_AF_AFGHANISTAN = "org.teamapps.dictionary.country.AF_AFGHANISTAN";
	public static final String COUNTRY_AX_ALAND_ISLANDS = "org.teamapps.dictionary.country.AX_ALAND_ISLANDS";
	public static final String COUNTRY_AL_ALBANIA = "org.teamapps.dictionary.country.AL_ALBANIA";
	public static final String COUNTRY_DZ_ALGERIA = "org.teamapps.dictionary.country.DZ_ALGERIA";
	public static final String COUNTRY_AS_AMERICAN_SAMOA = "org.teamapps.dictionary.country.AS_AMERICAN_SAMOA";
	public static final String COUNTRY_AD_ANDORRA = "org.teamapps.dictionary.country.AD_ANDORRA";
	public static final String COUNTRY_AO_ANGOLA = "org.teamapps.dictionary.country.AO_ANGOLA";
	public static final String COUNTRY_AI_ANGUILLA = "org.teamapps.dictionary.country.AI_ANGUILLA";
	public static final String COUNTRY_AQ_ANTARCTICA = "org.teamapps.dictionary.country.AQ_ANTARCTICA";
	public static final String COUNTRY_AG_ANTIGUA_AND_BARBUDA = "org.teamapps.dictionary.country.AG_ANTIGUA_AND_BARBUDA";
	public static final String COUNTRY_AR_ARGENTINA = "org.teamapps.dictionary.country.AR_ARGENTINA";
	public static final String COUNTRY_AM_ARMENIA = "org.teamapps.dictionary.country.AM_ARMENIA";
	public static final String COUNTRY_AW_ARUBA = "org.teamapps.dictionary.country.AW_ARUBA";
	public static final String COUNTRY_AU_AUSTRALIA = "org.teamapps.dictionary.country.AU_AUSTRALIA";
	public static final String COUNTRY_AT_AUSTRIA = "org.teamapps.dictionary.country.AT_AUSTRIA";
	public static final String COUNTRY_AZ_AZERBAIJAN = "org.teamapps.dictionary.country.AZ_AZERBAIJAN";
	public static final String COUNTRY_BH_BAHRAIN = "org.teamapps.dictionary.country.BH_BAHRAIN";
	public static final String COUNTRY_BS_BAHAMAS = "org.teamapps.dictionary.country.BS_BAHAMAS";
	public static final String COUNTRY_BD_BANGLADESH = "org.teamapps.dictionary.country.BD_BANGLADESH";
	public static final String COUNTRY_BB_BARBADOS = "org.teamapps.dictionary.country.BB_BARBADOS";
	public static final String COUNTRY_BY_BELARUS = "org.teamapps.dictionary.country.BY_BELARUS";
	public static final String COUNTRY_BE_BELGIUM = "org.teamapps.dictionary.country.BE_BELGIUM";
	public static final String COUNTRY_BZ_BELIZE = "org.teamapps.dictionary.country.BZ_BELIZE";
	public static final String COUNTRY_BJ_BENIN = "org.teamapps.dictionary.country.BJ_BENIN";
	public static final String COUNTRY_BM_BERMUDA = "org.teamapps.dictionary.country.BM_BERMUDA";
	public static final String COUNTRY_BT_BHUTAN = "org.teamapps.dictionary.country.BT_BHUTAN";
	public static final String COUNTRY_BO_BOLIVIA = "org.teamapps.dictionary.country.BO_BOLIVIA";
	public static final String COUNTRY_BQ_BONAIRE_SINT_EUSTATIUS_AND_SABA = "org.teamapps.dictionary.country.BQ_BONAIRE_SINT_EUSTATIUS_AND_SABA";
	public static final String COUNTRY_BA_BOSNIA_AND_HERZEGOVINA = "org.teamapps.dictionary.country.BA_BOSNIA_AND_HERZEGOVINA";
	public static final String COUNTRY_BW_BOTSWANA = "org.teamapps.dictionary.country.BW_BOTSWANA";
	public static final String COUNTRY_BV_BOUVET_ISLAND = "org.teamapps.dictionary.country.BV_BOUVET_ISLAND";
	public static final String COUNTRY_BR_BRAZIL = "org.teamapps.dictionary.country.BR_BRAZIL";
	public static final String COUNTRY_IO_BRITISH_INDIAN_OCEAN_TERRITORY = "org.teamapps.dictionary.country.IO_BRITISH_INDIAN_OCEAN_TERRITORY";
	public static final String COUNTRY_BN_BRUNEI_DARUSSALAM = "org.teamapps.dictionary.country.BN_BRUNEI_DARUSSALAM";
	public static final String COUNTRY_BG_BULGARIA = "org.teamapps.dictionary.country.BG_BULGARIA";
	public static final String COUNTRY_BF_BURKINA_FASO = "org.teamapps.dictionary.country.BF_BURKINA_FASO";
	public static final String COUNTRY_BI_BURUNDI = "org.teamapps.dictionary.country.BI_BURUNDI";
	public static final String COUNTRY_KH_CAMBODIA = "org.teamapps.dictionary.country.KH_CAMBODIA";
	public static final String COUNTRY_CM_CAMEROON = "org.teamapps.dictionary.country.CM_CAMEROON";
	public static final String COUNTRY_CA_CANADA = "org.teamapps.dictionary.country.CA_CANADA";
	public static final String COUNTRY_CV_CAPE_VERDE = "org.teamapps.dictionary.country.CV_CAPE_VERDE";
	public static final String COUNTRY_KY_CAYMAN_ISLANDS = "org.teamapps.dictionary.country.KY_CAYMAN_ISLANDS";
	public static final String COUNTRY_CF_CENTRAL_AFRICAN_REPUBLIC = "org.teamapps.dictionary.country.CF_CENTRAL_AFRICAN_REPUBLIC";
	public static final String COUNTRY_TD_CHAD = "org.teamapps.dictionary.country.TD_CHAD";
	public static final String COUNTRY_CL_CHILE = "org.teamapps.dictionary.country.CL_CHILE";
	public static final String COUNTRY_CN_CHINA = "org.teamapps.dictionary.country.CN_CHINA";
	public static final String COUNTRY_CX_CHRISTMAS_ISLAND = "org.teamapps.dictionary.country.CX_CHRISTMAS_ISLAND";
	public static final String COUNTRY_CC_COCOS__KEELING_ISLANDS = "org.teamapps.dictionary.country.CC_COCOS__KEELING_ISLANDS";
	public static final String COUNTRY_CO_COLOMBIA = "org.teamapps.dictionary.country.CO_COLOMBIA";
	public static final String COUNTRY_KM_COMOROS = "org.teamapps.dictionary.country.KM_COMOROS";
	public static final String COUNTRY_CG_CONGO = "org.teamapps.dictionary.country.CG_CONGO";
	public static final String COUNTRY_CD_CONGO_THE_DEMOCRATIC_REPUBLIC_OF_THE = "org.teamapps.dictionary.country.CD_CONGO_THE_DEMOCRATIC_REPUBLIC_OF_THE";
	public static final String COUNTRY_CK_COOK_ISLANDS = "org.teamapps.dictionary.country.CK_COOK_ISLANDS";
	public static final String COUNTRY_CR_COSTA_RICA = "org.teamapps.dictionary.country.CR_COSTA_RICA";
	public static final String COUNTRY_CI_COTE_D_IVOIRE = "org.teamapps.dictionary.country.CI_COTE_D_IVOIRE";
	public static final String COUNTRY_HR_CROATIA = "org.teamapps.dictionary.country.HR_CROATIA";
	public static final String COUNTRY_CU_CUBA = "org.teamapps.dictionary.country.CU_CUBA";
	public static final String COUNTRY_CW_CURACAO = "org.teamapps.dictionary.country.CW_CURACAO";
	public static final String COUNTRY_CY_CYPRUS = "org.teamapps.dictionary.country.CY_CYPRUS";
	public static final String COUNTRY_CZ_CZECH_REPUBLIC = "org.teamapps.dictionary.country.CZ_CZECH_REPUBLIC";
	public static final String COUNTRY_DK_DENMARK = "org.teamapps.dictionary.country.DK_DENMARK";
	public static final String COUNTRY_DJ_DJIBOUTI = "org.teamapps.dictionary.country.DJ_DJIBOUTI";
	public static final String COUNTRY_DM_DOMINICA = "org.teamapps.dictionary.country.DM_DOMINICA";
	public static final String COUNTRY_DO_DOMINICAN_REPUBLIC = "org.teamapps.dictionary.country.DO_DOMINICAN_REPUBLIC";
	public static final String COUNTRY_EC_ECUADOR = "org.teamapps.dictionary.country.EC_ECUADOR";
	public static final String COUNTRY_EG_EGYPT = "org.teamapps.dictionary.country.EG_EGYPT";
	public static final String COUNTRY_SV_EL_SALVADOR = "org.teamapps.dictionary.country.SV_EL_SALVADOR";
	public static final String COUNTRY_GQ_EQUATORIAL_GUINEA = "org.teamapps.dictionary.country.GQ_EQUATORIAL_GUINEA";
	public static final String COUNTRY_ER_ERITREA = "org.teamapps.dictionary.country.ER_ERITREA";
	public static final String COUNTRY_EE_ESTONIA = "org.teamapps.dictionary.country.EE_ESTONIA";
	public static final String COUNTRY_ET_ETHIOPIA = "org.teamapps.dictionary.country.ET_ETHIOPIA";
	public static final String COUNTRY_FK_FALKLAND_ISLANDS__MALVINAS_ = "org.teamapps.dictionary.country.FK_FALKLAND_ISLANDS__MALVINAS_";
	public static final String COUNTRY_FO_FAROE_ISLANDS = "org.teamapps.dictionary.country.FO_FAROE_ISLANDS";
	public static final String COUNTRY_FJ_FIJI = "org.teamapps.dictionary.country.FJ_FIJI";
	public static final String COUNTRY_FI_FINLAND = "org.teamapps.dictionary.country.FI_FINLAND";
	public static final String COUNTRY_FR_FRANCE = "org.teamapps.dictionary.country.FR_FRANCE";
	public static final String COUNTRY_GF_FRENCH_GUIANA = "org.teamapps.dictionary.country.GF_FRENCH_GUIANA";
	public static final String COUNTRY_PF_FRENCH_POLYNESIA = "org.teamapps.dictionary.country.PF_FRENCH_POLYNESIA";
	public static final String COUNTRY_TF_FRENCH_SOUTHERN_TERRITORIES = "org.teamapps.dictionary.country.TF_FRENCH_SOUTHERN_TERRITORIES";
	public static final String COUNTRY_GA_GABON = "org.teamapps.dictionary.country.GA_GABON";
	public static final String COUNTRY_GM_GAMBIA = "org.teamapps.dictionary.country.GM_GAMBIA";
	public static final String COUNTRY_GE_GEORGIA = "org.teamapps.dictionary.country.GE_GEORGIA";
	public static final String COUNTRY_DE_GERMANY = "org.teamapps.dictionary.country.DE_GERMANY";
	public static final String COUNTRY_GH_GHANA = "org.teamapps.dictionary.country.GH_GHANA";
	public static final String COUNTRY_GI_GIBRALTAR = "org.teamapps.dictionary.country.GI_GIBRALTAR";
	public static final String COUNTRY_GR_GREECE = "org.teamapps.dictionary.country.GR_GREECE";
	public static final String COUNTRY_GL_GREENLAND = "org.teamapps.dictionary.country.GL_GREENLAND";
	public static final String COUNTRY_GD_GRENADA = "org.teamapps.dictionary.country.GD_GRENADA";
	public static final String COUNTRY_GP_GUADELOUPE = "org.teamapps.dictionary.country.GP_GUADELOUPE";
	public static final String COUNTRY_GU_GUAM = "org.teamapps.dictionary.country.GU_GUAM";
	public static final String COUNTRY_GT_GUATEMALA = "org.teamapps.dictionary.country.GT_GUATEMALA";
	public static final String COUNTRY_GG_GUERNSEY = "org.teamapps.dictionary.country.GG_GUERNSEY";
	public static final String COUNTRY_GN_GUINEA = "org.teamapps.dictionary.country.GN_GUINEA";
	public static final String COUNTRY_GW_GUINEA_BISSAU = "org.teamapps.dictionary.country.GW_GUINEA_BISSAU";
	public static final String COUNTRY_GY_GUYANA = "org.teamapps.dictionary.country.GY_GUYANA";
	public static final String COUNTRY_HT_HAITI = "org.teamapps.dictionary.country.HT_HAITI";
	public static final String COUNTRY_HM_HEARD_ISLAND_AND_MC_DONALD_ISLANDS = "org.teamapps.dictionary.country.HM_HEARD_ISLAND_AND_MC_DONALD_ISLANDS";
	public static final String COUNTRY_VA_VATICAN_CITY_STATE = "org.teamapps.dictionary.country.VA_VATICAN_CITY_STATE";
	public static final String COUNTRY_HN_HONDURAS = "org.teamapps.dictionary.country.HN_HONDURAS";
	public static final String COUNTRY_HK_HONG_KONG = "org.teamapps.dictionary.country.HK_HONG_KONG";
	public static final String COUNTRY_HU_HUNGARY = "org.teamapps.dictionary.country.HU_HUNGARY";
	public static final String COUNTRY_IS_ICELAND = "org.teamapps.dictionary.country.IS_ICELAND";
	public static final String COUNTRY_IN_INDIA = "org.teamapps.dictionary.country.IN_INDIA";
	public static final String COUNTRY_ID_INDONESIA = "org.teamapps.dictionary.country.ID_INDONESIA";
	public static final String COUNTRY_IR_IRAN = "org.teamapps.dictionary.country.IR_IRAN";
	public static final String COUNTRY_IQ_IRAQ = "org.teamapps.dictionary.country.IQ_IRAQ";
	public static final String COUNTRY_IE_IRELAND = "org.teamapps.dictionary.country.IE_IRELAND";
	public static final String COUNTRY_IM_ISLE_OF_MAN = "org.teamapps.dictionary.country.IM_ISLE_OF_MAN";
	public static final String COUNTRY_IL_ISRAEL = "org.teamapps.dictionary.country.IL_ISRAEL";
	public static final String COUNTRY_IT_ITALY = "org.teamapps.dictionary.country.IT_ITALY";
	public static final String COUNTRY_JM_JAMAICA = "org.teamapps.dictionary.country.JM_JAMAICA";
	public static final String COUNTRY_JP_JAPAN = "org.teamapps.dictionary.country.JP_JAPAN";
	public static final String COUNTRY_JE_JERSEY = "org.teamapps.dictionary.country.JE_JERSEY";
	public static final String COUNTRY_JO_JORDAN = "org.teamapps.dictionary.country.JO_JORDAN";
	public static final String COUNTRY_KZ_KAZAKHSTAN = "org.teamapps.dictionary.country.KZ_KAZAKHSTAN";
	public static final String COUNTRY_KE_KENYA = "org.teamapps.dictionary.country.KE_KENYA";
	public static final String COUNTRY_KI_KIRIBATI = "org.teamapps.dictionary.country.KI_KIRIBATI";
	public static final String COUNTRY_KP_KOREA_DEMOCRATIC_PEOPLE_S_REPUBLIC_OF = "org.teamapps.dictionary.country.KP_KOREA_DEMOCRATIC_PEOPLE_S_REPUBLIC_OF";
	public static final String COUNTRY_KR_KOREA_REPUBLIC_OF = "org.teamapps.dictionary.country.KR_KOREA_REPUBLIC_OF";
	public static final String COUNTRY_KW_KUWAIT = "org.teamapps.dictionary.country.KW_KUWAIT";
	public static final String COUNTRY_KG_KYRGYZSTAN = "org.teamapps.dictionary.country.KG_KYRGYZSTAN";
	public static final String COUNTRY_LA_LAO_PEOPLE_S_DEMOCRATIC_REPUBLIC = "org.teamapps.dictionary.country.LA_LAO_PEOPLE_S_DEMOCRATIC_REPUBLIC";
	public static final String COUNTRY_LV_LATVIA = "org.teamapps.dictionary.country.LV_LATVIA";
	public static final String COUNTRY_LB_LEBANON = "org.teamapps.dictionary.country.LB_LEBANON";
	public static final String COUNTRY_LS_LESOTHO = "org.teamapps.dictionary.country.LS_LESOTHO";
	public static final String COUNTRY_LR_LIBERIA = "org.teamapps.dictionary.country.LR_LIBERIA";
	public static final String COUNTRY_LY_LIBYA = "org.teamapps.dictionary.country.LY_LIBYA";
	public static final String COUNTRY_LI_LIECHTENSTEIN = "org.teamapps.dictionary.country.LI_LIECHTENSTEIN";
	public static final String COUNTRY_LT_LITHUANIA = "org.teamapps.dictionary.country.LT_LITHUANIA";
	public static final String COUNTRY_LU_LUXEMBOURG = "org.teamapps.dictionary.country.LU_LUXEMBOURG";
	public static final String COUNTRY_MO_MACAO = "org.teamapps.dictionary.country.MO_MACAO";
	public static final String COUNTRY_MK_MACEDONIA_THE_FORMER_YUGOSLAV_REPUBLIC_OF = "org.teamapps.dictionary.country.MK_MACEDONIA_THE_FORMER_YUGOSLAV_REPUBLIC_OF";
	public static final String COUNTRY_MG_MADAGASCAR = "org.teamapps.dictionary.country.MG_MADAGASCAR";
	public static final String COUNTRY_MW_MALAWI = "org.teamapps.dictionary.country.MW_MALAWI";
	public static final String COUNTRY_MY_MALAYSIA = "org.teamapps.dictionary.country.MY_MALAYSIA";
	public static final String COUNTRY_MV_MALDIVES = "org.teamapps.dictionary.country.MV_MALDIVES";
	public static final String COUNTRY_ML_MALI = "org.teamapps.dictionary.country.ML_MALI";
	public static final String COUNTRY_MT_MALTA = "org.teamapps.dictionary.country.MT_MALTA";
	public static final String COUNTRY_MH_MARSHALL_ISLANDS = "org.teamapps.dictionary.country.MH_MARSHALL_ISLANDS";
	public static final String COUNTRY_MQ_MARTINIQUE = "org.teamapps.dictionary.country.MQ_MARTINIQUE";
	public static final String COUNTRY_MR_MAURITANIA = "org.teamapps.dictionary.country.MR_MAURITANIA";
	public static final String COUNTRY_MU_MAURITIUS = "org.teamapps.dictionary.country.MU_MAURITIUS";
	public static final String COUNTRY_YT_MAYOTTE = "org.teamapps.dictionary.country.YT_MAYOTTE";
	public static final String COUNTRY_MX_MEXICO = "org.teamapps.dictionary.country.MX_MEXICO";
	public static final String COUNTRY_FM_MICRONESIA = "org.teamapps.dictionary.country.FM_MICRONESIA";
	public static final String COUNTRY_MD_MOLDOVA = "org.teamapps.dictionary.country.MD_MOLDOVA";
	public static final String COUNTRY_MC_MONACO = "org.teamapps.dictionary.country.MC_MONACO";
	public static final String COUNTRY_MN_MONGOLIA = "org.teamapps.dictionary.country.MN_MONGOLIA";
	public static final String COUNTRY_ME_MONTENEGRO = "org.teamapps.dictionary.country.ME_MONTENEGRO";
	public static final String COUNTRY_MS_MONTSERRAT = "org.teamapps.dictionary.country.MS_MONTSERRAT";
	public static final String COUNTRY_MA_MOROCCO = "org.teamapps.dictionary.country.MA_MOROCCO";
	public static final String COUNTRY_MZ_MOZAMBIQUE = "org.teamapps.dictionary.country.MZ_MOZAMBIQUE";
	public static final String COUNTRY_MM_MYANMAR = "org.teamapps.dictionary.country.MM_MYANMAR";
	public static final String COUNTRY_NA_NAMIBIA = "org.teamapps.dictionary.country.NA_NAMIBIA";
	public static final String COUNTRY_NR_NAURU = "org.teamapps.dictionary.country.NR_NAURU";
	public static final String COUNTRY_NP_NEPAL = "org.teamapps.dictionary.country.NP_NEPAL";
	public static final String COUNTRY_NL_NETHERLANDS = "org.teamapps.dictionary.country.NL_NETHERLANDS";
	public static final String COUNTRY_NC_NEW_CALEDONIA = "org.teamapps.dictionary.country.NC_NEW_CALEDONIA";
	public static final String COUNTRY_NZ_NEW_ZEALAND = "org.teamapps.dictionary.country.NZ_NEW_ZEALAND";
	public static final String COUNTRY_NI_NICARAGUA = "org.teamapps.dictionary.country.NI_NICARAGUA";
	public static final String COUNTRY_NE_NIGER = "org.teamapps.dictionary.country.NE_NIGER";
	public static final String COUNTRY_NG_NIGERIA = "org.teamapps.dictionary.country.NG_NIGERIA";
	public static final String COUNTRY_NU_NIUE = "org.teamapps.dictionary.country.NU_NIUE";
	public static final String COUNTRY_NF_NORFOLK_ISLAND = "org.teamapps.dictionary.country.NF_NORFOLK_ISLAND";
	public static final String COUNTRY_MP_NORTHERN_MARIANA_ISLANDS = "org.teamapps.dictionary.country.MP_NORTHERN_MARIANA_ISLANDS";
	public static final String COUNTRY_NO_NORWAY = "org.teamapps.dictionary.country.NO_NORWAY";
	public static final String COUNTRY_OM_OMAN = "org.teamapps.dictionary.country.OM_OMAN";
	public static final String COUNTRY_PK_PAKISTAN = "org.teamapps.dictionary.country.PK_PAKISTAN";
	public static final String COUNTRY_PW_PALAU = "org.teamapps.dictionary.country.PW_PALAU";
	public static final String COUNTRY_PS_PALESTINE_STATE_OF = "org.teamapps.dictionary.country.PS_PALESTINE_STATE_OF";
	public static final String COUNTRY_PA_PANAMA = "org.teamapps.dictionary.country.PA_PANAMA";
	public static final String COUNTRY_PG_PAPUA_NEW_GUINEA = "org.teamapps.dictionary.country.PG_PAPUA_NEW_GUINEA";
	public static final String COUNTRY_PY_PARAGUAY = "org.teamapps.dictionary.country.PY_PARAGUAY";
	public static final String COUNTRY_PE_PERU = "org.teamapps.dictionary.country.PE_PERU";
	public static final String COUNTRY_PH_PHILIPPINES = "org.teamapps.dictionary.country.PH_PHILIPPINES";
	public static final String COUNTRY_PN_PITCAIRN = "org.teamapps.dictionary.country.PN_PITCAIRN";
	public static final String COUNTRY_PL_POLAND = "org.teamapps.dictionary.country.PL_POLAND";
	public static final String COUNTRY_PT_PORTUGAL = "org.teamapps.dictionary.country.PT_PORTUGAL";
	public static final String COUNTRY_PR_PUERTO_RICO = "org.teamapps.dictionary.country.PR_PUERTO_RICO";
	public static final String COUNTRY_QA_QATAR = "org.teamapps.dictionary.country.QA_QATAR";
	public static final String COUNTRY_RE_REUNION = "org.teamapps.dictionary.country.RE_REUNION";
	public static final String COUNTRY_RO_ROMANIA = "org.teamapps.dictionary.country.RO_ROMANIA";
	public static final String COUNTRY_RU_RUSSIAN_FEDERATION = "org.teamapps.dictionary.country.RU_RUSSIAN_FEDERATION";
	public static final String COUNTRY_RW_RWANDA = "org.teamapps.dictionary.country.RW_RWANDA";
	public static final String COUNTRY_BL_SAINT_BARTHELEMY = "org.teamapps.dictionary.country.BL_SAINT_BARTHELEMY";
	public static final String COUNTRY_SH_SAINT_HELENA_ASCENSION_AND_TRISTAN_DA_CUNHA = "org.teamapps.dictionary.country.SH_SAINT_HELENA_ASCENSION_AND_TRISTAN_DA_CUNHA";
	public static final String COUNTRY_KN_SAINT_KITTS_AND_NEVIS = "org.teamapps.dictionary.country.KN_SAINT_KITTS_AND_NEVIS";
	public static final String COUNTRY_LC_SAINT_LUCIA = "org.teamapps.dictionary.country.LC_SAINT_LUCIA";
	public static final String COUNTRY_MF_SAINT_MARTIN__FRENCH_PART_ = "org.teamapps.dictionary.country.MF_SAINT_MARTIN__FRENCH_PART_";
	public static final String COUNTRY_PM_SAINT_PIERRE_AND_MIQUELON = "org.teamapps.dictionary.country.PM_SAINT_PIERRE_AND_MIQUELON";
	public static final String COUNTRY_VC_SAINT_VINCENT_AND_THE_GRENADINES = "org.teamapps.dictionary.country.VC_SAINT_VINCENT_AND_THE_GRENADINES";
	public static final String COUNTRY_WS_SAMOA = "org.teamapps.dictionary.country.WS_SAMOA";
	public static final String COUNTRY_SM_SAN_MARINO = "org.teamapps.dictionary.country.SM_SAN_MARINO";
	public static final String COUNTRY_ST_SAO_TOME_AND_PRINCIPE = "org.teamapps.dictionary.country.ST_SAO_TOME_AND_PRINCIPE";
	public static final String COUNTRY_SA_SAUDI_ARABIA = "org.teamapps.dictionary.country.SA_SAUDI_ARABIA";
	public static final String COUNTRY_SN_SENEGAL = "org.teamapps.dictionary.country.SN_SENEGAL";
	public static final String COUNTRY_RS_SERBIA = "org.teamapps.dictionary.country.RS_SERBIA";
	public static final String COUNTRY_SC_SEYCHELLES = "org.teamapps.dictionary.country.SC_SEYCHELLES";
	public static final String COUNTRY_SL_SIERRA_LEONE = "org.teamapps.dictionary.country.SL_SIERRA_LEONE";
	public static final String COUNTRY_SG_SINGAPORE = "org.teamapps.dictionary.country.SG_SINGAPORE";
	public static final String COUNTRY_SX_SINT_MAARTEN__DUTCH_PART_ = "org.teamapps.dictionary.country.SX_SINT_MAARTEN__DUTCH_PART_";
	public static final String COUNTRY_SK_SLOVAKIA = "org.teamapps.dictionary.country.SK_SLOVAKIA";
	public static final String COUNTRY_SI_SLOVENIA = "org.teamapps.dictionary.country.SI_SLOVENIA";
	public static final String COUNTRY_SB_SOLOMON_ISLANDS = "org.teamapps.dictionary.country.SB_SOLOMON_ISLANDS";
	public static final String COUNTRY_SO_SOMALIA = "org.teamapps.dictionary.country.SO_SOMALIA";
	public static final String COUNTRY_ZA_SOUTH_AFRICA = "org.teamapps.dictionary.country.ZA_SOUTH_AFRICA";
	public static final String COUNTRY_GS_SOUTH_GEORGIA_AND_THE_SOUTH_SANDWICH_ISLANDS = "org.teamapps.dictionary.country.GS_SOUTH_GEORGIA_AND_THE_SOUTH_SANDWICH_ISLANDS";
	public static final String COUNTRY_SS_SOUTH_SUDAN = "org.teamapps.dictionary.country.SS_SOUTH_SUDAN";
	public static final String COUNTRY_ES_SPAIN = "org.teamapps.dictionary.country.ES_SPAIN";
	public static final String COUNTRY_LK_SRI_LANKA = "org.teamapps.dictionary.country.LK_SRI_LANKA";
	public static final String COUNTRY_SD_SUDAN = "org.teamapps.dictionary.country.SD_SUDAN";
	public static final String COUNTRY_SR_SURINAME = "org.teamapps.dictionary.country.SR_SURINAME";
	public static final String COUNTRY_SJ_SVALBARD_AND_JAN_MAYEN = "org.teamapps.dictionary.country.SJ_SVALBARD_AND_JAN_MAYEN";
	public static final String COUNTRY_SZ_SWAZILAND = "org.teamapps.dictionary.country.SZ_SWAZILAND";
	public static final String COUNTRY_SE_SWEDEN = "org.teamapps.dictionary.country.SE_SWEDEN";
	public static final String COUNTRY_CH_SWITZERLAND = "org.teamapps.dictionary.country.CH_SWITZERLAND";
	public static final String COUNTRY_SY_SYRIAN_ARAB_REPUBLIC = "org.teamapps.dictionary.country.SY_SYRIAN_ARAB_REPUBLIC";
	public static final String COUNTRY_TW_TAIWAN = "org.teamapps.dictionary.country.TW_TAIWAN";
	public static final String COUNTRY_TJ_TAJIKISTAN = "org.teamapps.dictionary.country.TJ_TAJIKISTAN";
	public static final String COUNTRY_TZ_TANZANIA = "org.teamapps.dictionary.country.TZ_TANZANIA";
	public static final String COUNTRY_TH_THAILAND = "org.teamapps.dictionary.country.TH_THAILAND";
	public static final String COUNTRY_TL_TIMOR_LESTE = "org.teamapps.dictionary.country.TL_TIMOR_LESTE";
	public static final String COUNTRY_TG_TOGO = "org.teamapps.dictionary.country.TG_TOGO";
	public static final String COUNTRY_TK_TOKELAU = "org.teamapps.dictionary.country.TK_TOKELAU";
	public static final String COUNTRY_TO_TONGA = "org.teamapps.dictionary.country.TO_TONGA";
	public static final String COUNTRY_TT_TRINIDAD_AND_TOBAGO = "org.teamapps.dictionary.country.TT_TRINIDAD_AND_TOBAGO";
	public static final String COUNTRY_TN_TUNISIA = "org.teamapps.dictionary.country.TN_TUNISIA";
	public static final String COUNTRY_TR_TURKEY = "org.teamapps.dictionary.country.TR_TURKEY";
	public static final String COUNTRY_TM_TURKMENISTAN = "org.teamapps.dictionary.country.TM_TURKMENISTAN";
	public static final String COUNTRY_TC_TURKS_AND_CAICOS_ISLANDS = "org.teamapps.dictionary.country.TC_TURKS_AND_CAICOS_ISLANDS";
	public static final String COUNTRY_TV_TUVALU = "org.teamapps.dictionary.country.TV_TUVALU";
	public static final String COUNTRY_UG_UGANDA = "org.teamapps.dictionary.country.UG_UGANDA";
	public static final String COUNTRY_UA_UKRAINE = "org.teamapps.dictionary.country.UA_UKRAINE";
	public static final String COUNTRY_AE_UNITED_ARAB_EMIRATES = "org.teamapps.dictionary.country.AE_UNITED_ARAB_EMIRATES";
	public static final String COUNTRY_GB_UNITED_KINGDOM = "org.teamapps.dictionary.country.GB_UNITED_KINGDOM";
	public static final String COUNTRY_US_UNITED_STATES = "org.teamapps.dictionary.country.US_UNITED_STATES";
	public static final String COUNTRY_UM_UNITED_STATES_MINOR_OUTLYING_ISLANDS = "org.teamapps.dictionary.country.UM_UNITED_STATES_MINOR_OUTLYING_ISLANDS";
	public static final String COUNTRY_UY_URUGUAY = "org.teamapps.dictionary.country.UY_URUGUAY";
	public static final String COUNTRY_UZ_UZBEKISTAN = "org.teamapps.dictionary.country.UZ_UZBEKISTAN";
	public static final String COUNTRY_VU_VANUATU = "org.teamapps.dictionary.country.VU_VANUATU";
	public static final String COUNTRY_VE_VENEZUELA = "org.teamapps.dictionary.country.VE_VENEZUELA";
	public static final String COUNTRY_VN_VIETNAM = "org.teamapps.dictionary.country.VN_VIETNAM";
	public static final String COUNTRY_VG_VIRGIN_ISLANDS_BRITISH = "org.teamapps.dictionary.country.VG_VIRGIN_ISLANDS_BRITISH";
	public static final String COUNTRY_VI_VIRGIN_ISLANDS_U_S = "org.teamapps.dictionary.country.VI_VIRGIN_ISLANDS_U_S";
	public static final String COUNTRY_WF_WALLIS_AND_FUTUNA = "org.teamapps.dictionary.country.WF_WALLIS_AND_FUTUNA";
	public static final String COUNTRY_EH_WESTERN_SAHARA = "org.teamapps.dictionary.country.EH_WESTERN_SAHARA";
	public static final String COUNTRY_YE_YEMEN = "org.teamapps.dictionary.country.YE_YEMEN";
	public static final String COUNTRY_ZM_ZAMBIA = "org.teamapps.dictionary.country.ZM_ZAMBIA";
	public static final String COUNTRY_ZW_ZIMBABWE = "org.teamapps.dictionary.country.ZW_ZIMBABWE";
	//languages
	public static final String LANGUAGE_AA_AFAR = "org.teamapps.dictionary.language.AA_AFAR";
	public static final String LANGUAGE_AF_AFRIKAANS = "org.teamapps.dictionary.language.AF_AFRIKAANS";
	public static final String LANGUAGE_AK_AKAN = "org.teamapps.dictionary.language.AK_AKAN";
	public static final String LANGUAGE_AM_AMHARIC = "org.teamapps.dictionary.language.AM_AMHARIC";
	public static final String LANGUAGE_AN_ARAGONESE = "org.teamapps.dictionary.language.AN_ARAGONESE";
	public static final String LANGUAGE_AR_ARABIC = "org.teamapps.dictionary.language.AR_ARABIC";
	public static final String LANGUAGE_AS_ASSAMESE = "org.teamapps.dictionary.language.AS_ASSAMESE";
	public static final String LANGUAGE_AV_AVARIC = "org.teamapps.dictionary.language.AV_AVARIC";
	public static final String LANGUAGE_AY_AYMARA = "org.teamapps.dictionary.language.AY_AYMARA";
	public static final String LANGUAGE_AZ_AZERBAIJANI = "org.teamapps.dictionary.language.AZ_AZERBAIJANI";
	public static final String LANGUAGE_BA_BASHKIR = "org.teamapps.dictionary.language.BA_BASHKIR";
	public static final String LANGUAGE_BE_BELARUSIAN = "org.teamapps.dictionary.language.BE_BELARUSIAN";
	public static final String LANGUAGE_BG_BULGARIAN = "org.teamapps.dictionary.language.BG_BULGARIAN";
	public static final String LANGUAGE_BH_BIHARI = "org.teamapps.dictionary.language.BH_BIHARI";
	public static final String LANGUAGE_BI_BISLAMA = "org.teamapps.dictionary.language.BI_BISLAMA";
	public static final String LANGUAGE_BM_BAMBARA = "org.teamapps.dictionary.language.BM_BAMBARA";
	public static final String LANGUAGE_BN_BENGALI = "org.teamapps.dictionary.language.BN_BENGALI";
	public static final String LANGUAGE_BO_TIBETAN = "org.teamapps.dictionary.language.BO_TIBETAN";
	public static final String LANGUAGE_BR_BRETON = "org.teamapps.dictionary.language.BR_BRETON";
	public static final String LANGUAGE_BS_BOSNIAN = "org.teamapps.dictionary.language.BS_BOSNIAN";
	public static final String LANGUAGE_CA_CATALAN = "org.teamapps.dictionary.language.CA_CATALAN";
	public static final String LANGUAGE_CE_CHECHEN = "org.teamapps.dictionary.language.CE_CHECHEN";
	public static final String LANGUAGE_CH_CHAMORRO = "org.teamapps.dictionary.language.CH_CHAMORRO";
	public static final String LANGUAGE_CO_CORSICAN = "org.teamapps.dictionary.language.CO_CORSICAN";
	public static final String LANGUAGE_CR_CREE = "org.teamapps.dictionary.language.CR_CREE";
	public static final String LANGUAGE_CS_CZECH = "org.teamapps.dictionary.language.CS_CZECH";
	public static final String LANGUAGE_CV_CHUVASH = "org.teamapps.dictionary.language.CV_CHUVASH";
	public static final String LANGUAGE_CY_WELSH = "org.teamapps.dictionary.language.CY_WELSH";
	public static final String LANGUAGE_DA_DANISH = "org.teamapps.dictionary.language.DA_DANISH";
	public static final String LANGUAGE_DE_GERMAN = "org.teamapps.dictionary.language.DE_GERMAN";
	public static final String LANGUAGE_DV_DHIVEHI_MALDIVIAN = "org.teamapps.dictionary.language.DV_DHIVEHI_MALDIVIAN";
	public static final String LANGUAGE_DZ_DZONGKHA = "org.teamapps.dictionary.language.DZ_DZONGKHA";
	public static final String LANGUAGE_EE_EWE = "org.teamapps.dictionary.language.EE_EWE";
	public static final String LANGUAGE_EL_GREEK = "org.teamapps.dictionary.language.EL_GREEK";
	public static final String LANGUAGE_EN_ENGLISH = "org.teamapps.dictionary.language.EN_ENGLISH";
	public static final String LANGUAGE_EO_ESPERANTO = "org.teamapps.dictionary.language.EO_ESPERANTO";
	public static final String LANGUAGE_ES_SPANISH = "org.teamapps.dictionary.language.ES_SPANISH";
	public static final String LANGUAGE_ET_ESTONIAN = "org.teamapps.dictionary.language.ET_ESTONIAN";
	public static final String LANGUAGE_EU_BASQUE = "org.teamapps.dictionary.language.EU_BASQUE";
	public static final String LANGUAGE_FA_PERSIAN = "org.teamapps.dictionary.language.FA_PERSIAN";
	public static final String LANGUAGE_FF_FULAH = "org.teamapps.dictionary.language.FF_FULAH";
	public static final String LANGUAGE_FI_FINNISH = "org.teamapps.dictionary.language.FI_FINNISH";
	public static final String LANGUAGE_FJ_FIJIAN = "org.teamapps.dictionary.language.FJ_FIJIAN";
	public static final String LANGUAGE_FO_FAROESE = "org.teamapps.dictionary.language.FO_FAROESE";
	public static final String LANGUAGE_FR_FRENCH = "org.teamapps.dictionary.language.FR_FRENCH";
	public static final String LANGUAGE_FY_WESTERN_FRISIAN = "org.teamapps.dictionary.language.FY_WESTERN_FRISIAN";
	public static final String LANGUAGE_GA_IRISH = "org.teamapps.dictionary.language.GA_IRISH";
	public static final String LANGUAGE_GD_GAELIC = "org.teamapps.dictionary.language.GD_GAELIC";
	public static final String LANGUAGE_GL_GALICIAN = "org.teamapps.dictionary.language.GL_GALICIAN";
	public static final String LANGUAGE_GN_GUARANI = "org.teamapps.dictionary.language.GN_GUARANI";
	public static final String LANGUAGE_GU_GUJARATI = "org.teamapps.dictionary.language.GU_GUJARATI";
	public static final String LANGUAGE_GV_MANX = "org.teamapps.dictionary.language.GV_MANX";
	public static final String LANGUAGE_HA_HAUSA = "org.teamapps.dictionary.language.HA_HAUSA";
	public static final String LANGUAGE_HE_HEBREW = "org.teamapps.dictionary.language.HE_HEBREW";
	public static final String LANGUAGE_HI_HINDI = "org.teamapps.dictionary.language.HI_HINDI";
	public static final String LANGUAGE_HO_HIRI_MOTU = "org.teamapps.dictionary.language.HO_HIRI_MOTU";
	public static final String LANGUAGE_HR_CROATIAN = "org.teamapps.dictionary.language.HR_CROATIAN";
	public static final String LANGUAGE_HT_HAITIAN_HAITIAN_CREOLE = "org.teamapps.dictionary.language.HT_HAITIAN_HAITIAN_CREOLE";
	public static final String LANGUAGE_HU_HUNGARIAN = "org.teamapps.dictionary.language.HU_HUNGARIAN";
	public static final String LANGUAGE_HY_ARMENIAN = "org.teamapps.dictionary.language.HY_ARMENIAN";
	public static final String LANGUAGE_HZ_HERERO = "org.teamapps.dictionary.language.HZ_HERERO";
	public static final String LANGUAGE_ID_INDONESIAN = "org.teamapps.dictionary.language.ID_INDONESIAN";
	public static final String LANGUAGE_IG_IGBO = "org.teamapps.dictionary.language.IG_IGBO";
	public static final String LANGUAGE_II_SICHUAN_YI_NUOSU = "org.teamapps.dictionary.language.II_SICHUAN_YI_NUOSU";
	public static final String LANGUAGE_IK_INUPIAQ = "org.teamapps.dictionary.language.IK_INUPIAQ";
	public static final String LANGUAGE_IO_IDO = "org.teamapps.dictionary.language.IO_IDO";
	public static final String LANGUAGE_IS_ICELANDIC = "org.teamapps.dictionary.language.IS_ICELANDIC";
	public static final String LANGUAGE_IT_ITALIAN = "org.teamapps.dictionary.language.IT_ITALIAN";
	public static final String LANGUAGE_IU_INUKTITUT = "org.teamapps.dictionary.language.IU_INUKTITUT";
	public static final String LANGUAGE_JA_JAPANESE = "org.teamapps.dictionary.language.JA_JAPANESE";
	public static final String LANGUAGE_JV_JAVANESE = "org.teamapps.dictionary.language.JV_JAVANESE";
	public static final String LANGUAGE_KA_GEORGIAN = "org.teamapps.dictionary.language.KA_GEORGIAN";
	public static final String LANGUAGE_KG_KONGO = "org.teamapps.dictionary.language.KG_KONGO";
	public static final String LANGUAGE_KI_KIKUYU_GIKUYU = "org.teamapps.dictionary.language.KI_KIKUYU_GIKUYU";
	public static final String LANGUAGE_KJ_KUANYAMA_KWANYAMA = "org.teamapps.dictionary.language.KJ_KUANYAMA_KWANYAMA";
	public static final String LANGUAGE_KK_KAZAKH = "org.teamapps.dictionary.language.KK_KAZAKH";
	public static final String LANGUAGE_KL_KALAALLISUT_GREENLANDIC = "org.teamapps.dictionary.language.KL_KALAALLISUT_GREENLANDIC";
	public static final String LANGUAGE_KM_CENTRAL_KHMER = "org.teamapps.dictionary.language.KM_CENTRAL_KHMER";
	public static final String LANGUAGE_KN_KANNADA = "org.teamapps.dictionary.language.KN_KANNADA";
	public static final String LANGUAGE_KO_KOREAN = "org.teamapps.dictionary.language.KO_KOREAN";
	public static final String LANGUAGE_KR_KANURI = "org.teamapps.dictionary.language.KR_KANURI";
	public static final String LANGUAGE_KS_KASHMIRI = "org.teamapps.dictionary.language.KS_KASHMIRI";
	public static final String LANGUAGE_KU_KURDISH = "org.teamapps.dictionary.language.KU_KURDISH";
	public static final String LANGUAGE_KV_KOMI = "org.teamapps.dictionary.language.KV_KOMI";
	public static final String LANGUAGE_KW_CORNISH = "org.teamapps.dictionary.language.KW_CORNISH";
	public static final String LANGUAGE_KY_KIRGHIZ_KYRGYZ = "org.teamapps.dictionary.language.KY_KIRGHIZ_KYRGYZ";
	public static final String LANGUAGE_LG_GANDA = "org.teamapps.dictionary.language.LG_GANDA";
	public static final String LANGUAGE_LN_LINGALA = "org.teamapps.dictionary.language.LN_LINGALA";
	public static final String LANGUAGE_LO_LAO = "org.teamapps.dictionary.language.LO_LAO";
	public static final String LANGUAGE_LT_LITHUANIAN = "org.teamapps.dictionary.language.LT_LITHUANIAN";
	public static final String LANGUAGE_LU_LUBA_KATANGA = "org.teamapps.dictionary.language.LU_LUBA_KATANGA";
	public static final String LANGUAGE_LV_LATVIAN = "org.teamapps.dictionary.language.LV_LATVIAN";
	public static final String LANGUAGE_MG_MALAGASY = "org.teamapps.dictionary.language.MG_MALAGASY";
	public static final String LANGUAGE_MH_MARSHALLESE = "org.teamapps.dictionary.language.MH_MARSHALLESE";
	public static final String LANGUAGE_MI_MAORI = "org.teamapps.dictionary.language.MI_MAORI";
	public static final String LANGUAGE_MK_MACEDONIAN = "org.teamapps.dictionary.language.MK_MACEDONIAN";
	public static final String LANGUAGE_ML_MALAYALAM = "org.teamapps.dictionary.language.ML_MALAYALAM";
	public static final String LANGUAGE_MN_MONGOLIAN = "org.teamapps.dictionary.language.MN_MONGOLIAN";
	public static final String LANGUAGE_MR_MARATHI = "org.teamapps.dictionary.language.MR_MARATHI";
	public static final String LANGUAGE_MS_MALAY = "org.teamapps.dictionary.language.MS_MALAY";
	public static final String LANGUAGE_MT_MALTESE = "org.teamapps.dictionary.language.MT_MALTESE";
	public static final String LANGUAGE_MY_BURMESE = "org.teamapps.dictionary.language.MY_BURMESE";
	public static final String LANGUAGE_NA_NAURU = "org.teamapps.dictionary.language.NA_NAURU";
	public static final String LANGUAGE_ND_NDEBELE_NORTH = "org.teamapps.dictionary.language.ND_NDEBELE_NORTH";
	public static final String LANGUAGE_NE_NEPALI = "org.teamapps.dictionary.language.NE_NEPALI";
	public static final String LANGUAGE_NG_NDONGA = "org.teamapps.dictionary.language.NG_NDONGA";
	public static final String LANGUAGE_NL_DUTCH = "org.teamapps.dictionary.language.NL_DUTCH";
	public static final String LANGUAGE_NO_NORWEGIAN = "org.teamapps.dictionary.language.NO_NORWEGIAN";
	public static final String LANGUAGE_NR_NDEBELE_SOUTH = "org.teamapps.dictionary.language.NR_NDEBELE_SOUTH";
	public static final String LANGUAGE_NV_NAVAJO_NAVAHO = "org.teamapps.dictionary.language.NV_NAVAJO_NAVAHO";
	public static final String LANGUAGE_NY_CHICHEWA_CHEWA_NYANJA = "org.teamapps.dictionary.language.NY_CHICHEWA_CHEWA_NYANJA";
	public static final String LANGUAGE_OC_OCCITAN = "org.teamapps.dictionary.language.OC_OCCITAN";
	public static final String LANGUAGE_OJ_OJIBWA = "org.teamapps.dictionary.language.OJ_OJIBWA";
	public static final String LANGUAGE_OM_OROMO = "org.teamapps.dictionary.language.OM_OROMO";
	public static final String LANGUAGE_OR_ORIYA = "org.teamapps.dictionary.language.OR_ORIYA";
	public static final String LANGUAGE_OS_OSSETIAN_OSSETIC = "org.teamapps.dictionary.language.OS_OSSETIAN_OSSETIC";
	public static final String LANGUAGE_PA_PANJABI_PUNJABI = "org.teamapps.dictionary.language.PA_PANJABI_PUNJABI";
	public static final String LANGUAGE_PI_PALI = "org.teamapps.dictionary.language.PI_PALI";
	public static final String LANGUAGE_PL_POLISH = "org.teamapps.dictionary.language.PL_POLISH";
	public static final String LANGUAGE_PS_PUSHTO_PASHTO = "org.teamapps.dictionary.language.PS_PUSHTO_PASHTO";
	public static final String LANGUAGE_PT_PORTUGUESE = "org.teamapps.dictionary.language.PT_PORTUGUESE";
	public static final String LANGUAGE_QU_QUECHUA = "org.teamapps.dictionary.language.QU_QUECHUA";
	public static final String LANGUAGE_RM_ROMANSH = "org.teamapps.dictionary.language.RM_ROMANSH";
	public static final String LANGUAGE_RN_RUNDI = "org.teamapps.dictionary.language.RN_RUNDI";
	public static final String LANGUAGE_RO_ROMANIAN = "org.teamapps.dictionary.language.RO_ROMANIAN";
	public static final String LANGUAGE_RU_RUSSIAN = "org.teamapps.dictionary.language.RU_RUSSIAN";
	public static final String LANGUAGE_RW_KINYARWANDA = "org.teamapps.dictionary.language.RW_KINYARWANDA";
	public static final String LANGUAGE_SA_SANSKRIT = "org.teamapps.dictionary.language.SA_SANSKRIT";
	public static final String LANGUAGE_SC_SARDINIAN = "org.teamapps.dictionary.language.SC_SARDINIAN";
	public static final String LANGUAGE_SD_SINDHI = "org.teamapps.dictionary.language.SD_SINDHI";
	public static final String LANGUAGE_SE_NORTHERN_SAMI = "org.teamapps.dictionary.language.SE_NORTHERN_SAMI";
	public static final String LANGUAGE_SG_SANGO = "org.teamapps.dictionary.language.SG_SANGO";
	public static final String LANGUAGE_SI_SINHALA_SINHALESE = "org.teamapps.dictionary.language.SI_SINHALA_SINHALESE";
	public static final String LANGUAGE_SK_SLOVAK = "org.teamapps.dictionary.language.SK_SLOVAK";
	public static final String LANGUAGE_SL_SLOVENIAN = "org.teamapps.dictionary.language.SL_SLOVENIAN";
	public static final String LANGUAGE_SM_SAMOAN = "org.teamapps.dictionary.language.SM_SAMOAN";
	public static final String LANGUAGE_SN_SHONA = "org.teamapps.dictionary.language.SN_SHONA";
	public static final String LANGUAGE_SO_SOMALI = "org.teamapps.dictionary.language.SO_SOMALI";
	public static final String LANGUAGE_SQ_ALBANIAN = "org.teamapps.dictionary.language.SQ_ALBANIAN";
	public static final String LANGUAGE_SR_SERBIAN = "org.teamapps.dictionary.language.SR_SERBIAN";
	public static final String LANGUAGE_SS_SWATI = "org.teamapps.dictionary.language.SS_SWATI";
	public static final String LANGUAGE_ST_SOTHO_SOUTHERN = "org.teamapps.dictionary.language.ST_SOTHO_SOUTHERN";
	public static final String LANGUAGE_SU_SUNDANESE = "org.teamapps.dictionary.language.SU_SUNDANESE";
	public static final String LANGUAGE_SV_SWEDISH = "org.teamapps.dictionary.language.SV_SWEDISH";
	public static final String LANGUAGE_SW_SWAHILI = "org.teamapps.dictionary.language.SW_SWAHILI";
	public static final String LANGUAGE_TA_TAMIL = "org.teamapps.dictionary.language.TA_TAMIL";
	public static final String LANGUAGE_TE_TELUGU = "org.teamapps.dictionary.language.TE_TELUGU";
	public static final String LANGUAGE_TG_TAJIK = "org.teamapps.dictionary.language.TG_TAJIK";
	public static final String LANGUAGE_TH_THAI = "org.teamapps.dictionary.language.TH_THAI";
	public static final String LANGUAGE_TI_TIGRINYA = "org.teamapps.dictionary.language.TI_TIGRINYA";
	public static final String LANGUAGE_TK_TURKMEN = "org.teamapps.dictionary.language.TK_TURKMEN";
	public static final String LANGUAGE_TL_TAGALOG = "org.teamapps.dictionary.language.TL_TAGALOG";
	public static final String LANGUAGE_TN_TSWANA = "org.teamapps.dictionary.language.TN_TSWANA";
	public static final String LANGUAGE_TO_TONGA = "org.teamapps.dictionary.language.TO_TONGA";
	public static final String LANGUAGE_TR_TURKISH = "org.teamapps.dictionary.language.TR_TURKISH";
	public static final String LANGUAGE_TS_TSONGA = "org.teamapps.dictionary.language.TS_TSONGA";
	public static final String LANGUAGE_TT_TATAR = "org.teamapps.dictionary.language.TT_TATAR";
	public static final String LANGUAGE_TW_TWI = "org.teamapps.dictionary.language.TW_TWI";
	public static final String LANGUAGE_TY_TAHITIAN = "org.teamapps.dictionary.language.TY_TAHITIAN";
	public static final String LANGUAGE_UG_UIGHUR_UYGHUR = "org.teamapps.dictionary.language.UG_UIGHUR_UYGHUR";
	public static final String LANGUAGE_UK_UKRAINIAN = "org.teamapps.dictionary.language.UK_UKRAINIAN";
	public static final String LANGUAGE_UR_URDU = "org.teamapps.dictionary.language.UR_URDU";
	public static final String LANGUAGE_UZ_UZBEK = "org.teamapps.dictionary.language.UZ_UZBEK";
	public static final String LANGUAGE_VE_VENDA = "org.teamapps.dictionary.language.VE_VENDA";
	public static final String LANGUAGE_VI_VIETNAMESE = "org.teamapps.dictionary.language.VI_VIETNAMESE";
	public static final String LANGUAGE_VO_VOLAPUK = "org.teamapps.dictionary.language.VO_VOLAPUK";
	public static final String LANGUAGE_WA_WALLOON = "org.teamapps.dictionary.language.WA_WALLOON";
	public static final String LANGUAGE_WO_WOLOF = "org.teamapps.dictionary.language.WO_WOLOF";
	public static final String LANGUAGE_XH_XHOSA = "org.teamapps.dictionary.language.XH_XHOSA";
	public static final String LANGUAGE_YI_YIDDISH = "org.teamapps.dictionary.language.YI_YIDDISH";
	public static final String LANGUAGE_YO_YORUBA = "org.teamapps.dictionary.language.YO_YORUBA";
	public static final String LANGUAGE_ZA_ZHUANG_CHUANG = "org.teamapps.dictionary.language.ZA_ZHUANG_CHUANG";
	public static final String LANGUAGE_ZH_CHINESE = "org.teamapps.dictionary.language.ZH_CHINESE";
	public static final String LANGUAGE_ZU_ZULU = "org.teamapps.dictionary.language.ZU_ZULU";
	public static final String LANGUAGE_PAP_PAPIAMENTO = "org.teamapps.dictionary.language.PAP_PAPIAMENTO";


}
