package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.transaction.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.query.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


public class UdbOrganizationUnitTypeViewQuery extends AbstractUdbQuery<OrganizationUnitTypeView> implements OrganizationUnitTypeViewQuery {

    public UdbOrganizationUnitTypeViewQuery() {
        super(UdbOrganizationUnitTypeView.table, OrganizationUnitTypeView.getBuilder());
    }

	@Override
	public OrganizationUnitTypeViewQuery fullTextFilter(TextFilter textFilter, String... fieldNames) {
    	and(UdbOrganizationUnitTypeView.table.createFullTextFilter(textFilter, fieldNames));
		return this;
	}

	@Override
	public OrganizationUnitTypeViewQuery parseFullTextFilter(String query, String... fieldNames) {
    	and(UdbOrganizationUnitTypeView.table.createFullTextFilter(query, fieldNames));
		return this;
	}

	@Override
	public OrganizationUnitTypeViewQuery name(TranslatableTextFilter filter) {
		and(UdbOrganizationUnitTypeView.name.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitTypeViewQuery orName(TranslatableTextFilter filter) {
		or(UdbOrganizationUnitTypeView.name.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitTypeViewQuery abbreviation(TranslatableTextFilter filter) {
		and(UdbOrganizationUnitTypeView.abbreviation.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitTypeViewQuery orAbbreviation(TranslatableTextFilter filter) {
		or(UdbOrganizationUnitTypeView.abbreviation.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitTypeViewQuery icon(TextFilter filter) {
		and(UdbOrganizationUnitTypeView.icon.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitTypeViewQuery orIcon(TextFilter filter) {
		or(UdbOrganizationUnitTypeView.icon.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitTypeViewQuery translateOrganizationUnits(BooleanFilter filter) {
		and(UdbOrganizationUnitTypeView.translateOrganizationUnits.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitTypeViewQuery orTranslateOrganizationUnits(BooleanFilter filter) {
		or(UdbOrganizationUnitTypeView.translateOrganizationUnits.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitTypeViewQuery allowUserContainer(BooleanFilter filter) {
		and(UdbOrganizationUnitTypeView.allowUserContainer.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitTypeViewQuery orAllowUserContainer(BooleanFilter filter) {
		or(UdbOrganizationUnitTypeView.allowUserContainer.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitTypeViewQuery filterDefaultChildType(OrganizationUnitTypeViewQuery query) {
		UdbOrganizationUnitTypeViewQuery udbQuery = (UdbOrganizationUnitTypeViewQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbOrganizationUnitTypeView.defaultChildType);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public OrganizationUnitTypeViewQuery defaultChildType(NumericFilter filter) {
		and(UdbOrganizationUnitTypeView.defaultChildType.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitTypeViewQuery orDefaultChildType(NumericFilter filter) {
		or(UdbOrganizationUnitTypeView.defaultChildType.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitTypeViewQuery filterPossibleChildrenTypes(OrganizationUnitTypeViewQuery query) {
		UdbOrganizationUnitTypeViewQuery udbQuery = (UdbOrganizationUnitTypeViewQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbOrganizationUnitTypeView.possibleChildrenTypes);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public OrganizationUnitTypeViewQuery possibleChildrenTypes(MultiReferenceFilterType type, OrganizationUnitTypeView ... values) {
		List<Integer> ids = new ArrayList<>();
		if (values != null) {
			for (OrganizationUnitTypeView value : values) {
				ids.add(value.getId());
			}
		}
		MultiReferenceFilter filter = MultiReferenceFilter.createFilter(type, ids);
		and(UdbOrganizationUnitTypeView.possibleChildrenTypes.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitTypeViewQuery possibleChildrenTypesCount(MultiReferenceFilterType type, int count) {
		MultiReferenceFilter filter = MultiReferenceFilter.createCountFilter(type, count);
		and(UdbOrganizationUnitTypeView.possibleChildrenTypes.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitTypeViewQuery possibleChildrenTypes(MultiReferenceFilter filter) {
		and(UdbOrganizationUnitTypeView.possibleChildrenTypes.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitTypeViewQuery orPossibleChildrenTypes(MultiReferenceFilter filter) {
		or(UdbOrganizationUnitTypeView.possibleChildrenTypes.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitTypeViewQuery geoLocationType(EnumFilterType filterType, GeoLocationType... enums) {
		and(UdbOrganizationUnitTypeView.geoLocationType.createFilter(NumericFilter.createEnumFilter(filterType, enums)));
		return this;
	}

	@Override
	public OrganizationUnitTypeViewQuery orGeoLocationType(EnumFilterType filterType, GeoLocationType... enums) {
		or(UdbOrganizationUnitTypeView.geoLocationType.createFilter(NumericFilter.createEnumFilter(filterType, enums)));
		return this;
	}


	@Override
	public UdbOrganizationUnitTypeViewQuery andOr(OrganizationUnitTypeViewQuery ... queries) {
	    AbstractUdbQuery[] abstractUdbQueries = Arrays.copyOf(queries, queries.length, AbstractUdbQuery[].class);
		andOr(abstractUdbQueries);
		return this;
	}

    @Override
    public OrganizationUnitTypeViewQuery customFilter(Function<OrganizationUnitTypeView, Boolean> customFilter) {
        Function<Integer, Boolean> filterFunction = id -> {
            return customFilter.apply(OrganizationUnitTypeView.getById(id));
        };
        and(new CustomEntityFilter(filterFunction));
        return this;
    }

}



