/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.ux.form;

import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.api.theme.ApplicationIcons;
import org.teamapps.application.tools.RecordModelBuilder;
import org.teamapps.icons.Icon;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.absolutelayout.Length;
import org.teamapps.ux.component.panel.Panel;
import org.teamapps.ux.component.table.Table;
import org.teamapps.ux.component.toolbar.Toolbar;
import org.teamapps.ux.component.toolbar.ToolbarButton;
import org.teamapps.ux.component.toolbar.ToolbarButtonGroup;

public class FormPanel {
    private final ApplicationInstanceData applicationInstanceData;
    private Panel panel;
    private Toolbar toolbar;
    private ToolbarButtonGroup currentButtonGroup;
    private ToolbarButton addButton;
    private ToolbarButton editButton;
    private ToolbarButton deleteButton;
    private int topSpace = 50;
    private int maxHeight = 300;

    public FormPanel(ApplicationInstanceData applicationInstanceData) {
        this(applicationInstanceData, null);
    }

    public FormPanel(ApplicationInstanceData applicationInstanceData, Component content) {
        this.applicationInstanceData = applicationInstanceData;
        this.panel = new Panel();
        this.toolbar = new Toolbar();
        this.panel.setHideTitleBar(true);
        this.panel.setToolbar(this.toolbar);
        this.setHeight(75);
        this.currentButtonGroup = this.toolbar.addButtonGroup(new ToolbarButtonGroup());
        this.setContent(content);
    }

    public void setContent(Component content) {
        this.panel.setContent(content);
    }

    public void setHeight(int height) {
        this.panel.setCssStyle("height", Length.ofPixels((int)height).toCssString());
    }

    public <RECORD> void setTable(Table<RECORD> table, RecordModelBuilder<RECORD> recordModelBuilder, Icon panelIcon, String panelTitle, boolean autoHeight, boolean autoEditButtonVisibility, boolean addAllEditButtons) {
        this.panel.setHideTitleBar(false);
        this.panel.setIcon(panelIcon);
        recordModelBuilder.attachSearchField(this.panel);
        recordModelBuilder.attachViewCountHandler(this.panel, () -> panelTitle);
        this.setTable(table, autoHeight, autoEditButtonVisibility, addAllEditButtons);
    }

    public void setTable(Table<?> table, boolean autoHeight, boolean autoEditButtonVisibility, boolean addAllEditButtons) {
        this.setContent((Component)table);
        if (autoHeight) {
            this.setAutoHeight(table);
        }
        if (autoEditButtonVisibility) {
            this.setAutoDisplayEditButtons(table);
        }
        if (addAllEditButtons) {
            this.addCreateButton();
            this.addEditButton();
            this.addDeleteButton();
        }
    }

    public void setAutoHeight(Table<?> table) {
        table.getCount().onChanged().addListener(count -> this.setHeight(Math.min(this.maxHeight, this.topSpace + (table.getRowHeight() + 2) * count)));
    }

    public void setAutoDisplayEditButtons(Table<?> table) {
        table.onRowSelected.addListener(record -> {
            if (this.editButton != null) {
                this.editButton.setVisible(true);
            }
            if (this.deleteButton != null) {
                this.deleteButton.setVisible(true);
            }
        });
        table.getCount().onChanged().addListener(count -> {
            if (count == 0) {
                if (this.editButton != null) {
                    this.editButton.setVisible(false);
                }
                if (this.deleteButton != null) {
                    this.deleteButton.setVisible(false);
                }
            }
        });
    }

    public ToolbarButtonGroup addButtonGroup() {
        this.currentButtonGroup = new ToolbarButtonGroup();
        this.toolbar.addButtonGroup(this.currentButtonGroup);
        return this.currentButtonGroup;
    }

    public ToolbarButton addButton(Icon icon, String title) {
        ToolbarButton button = ToolbarButton.createTiny((Icon)icon, (String)title);
        this.currentButtonGroup.addButton(button);
        return button;
    }

    public ToolbarButton addCreateButton() {
        return this.addCreateButton(this.getLocalized("org.teamapps.dictionary.add"));
    }

    public ToolbarButton addCreateButton(String title) {
        this.addButton = ToolbarButton.createTiny((Icon)ApplicationIcons.ADD, (String)title);
        this.currentButtonGroup.addButton(this.addButton);
        return this.addButton;
    }

    public ToolbarButton addEditButton() {
        return this.addEditButton(this.getLocalized("org.teamapps.dictionary.edit"));
    }

    public ToolbarButton addEditButton(String title) {
        this.editButton = ToolbarButton.createTiny((Icon)ApplicationIcons.EDIT, (String)title);
        this.editButton.setVisible(false);
        this.currentButtonGroup.addButton(this.editButton);
        return this.editButton;
    }

    public ToolbarButton addDeleteButton() {
        return this.addDeleteButton(this.getLocalized("org.teamapps.dictionary.delete"));
    }

    public ToolbarButton addDeleteButton(String title) {
        this.deleteButton = ToolbarButton.createTiny((Icon)ApplicationIcons.ERROR, (String)title);
        this.deleteButton.setVisible(false);
        this.currentButtonGroup.addButton(this.deleteButton);
        return this.deleteButton;
    }

    private String getLocalized(String key) {
        return this.applicationInstanceData.getLocalized(key, new Object[0]);
    }

    public Panel getPanel() {
        return this.panel;
    }

    public Toolbar getToolbar() {
        return this.toolbar;
    }

    public ToolbarButtonGroup getCurrentButtonGroup() {
        return this.currentButtonGroup;
    }

    public ToolbarButton getAddButton() {
        return this.addButton;
    }

    public ToolbarButton getEditButton() {
        return this.editButton;
    }

    public ToolbarButton getDeleteButton() {
        return this.deleteButton;
    }

    public void setTopSpace(int topSpace) {
        this.topSpace = topSpace;
    }

    public void setMaxHeight(int maxSpace) {
        this.maxHeight = maxSpace;
    }
}

