/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.api.application.perspective;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.api.application.perspective.AbstractPerspectiveBuilder;
import org.teamapps.application.api.application.perspective.ApplicationPerspective;
import org.teamapps.application.api.theme.ApplicationIcons;
import org.teamapps.icons.Icon;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.itemview.SimpleItemGroup;
import org.teamapps.ux.component.itemview.SimpleItemView;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.Template;
import org.teamapps.ux.component.tree.Tree;
import org.teamapps.ux.model.ListTreeModel;
import org.teamapps.ux.model.TreeModel;

public class PerspectiveMenuPanel {
    private final ApplicationInstanceData applicationInstanceData;
    private final List<AbstractPerspectiveBuilder> perspectiveBuilders;
    private Tree<AbstractPerspectiveBuilder> tree;
    private SimpleItemView<AbstractPerspectiveBuilder> buttonMenu;
    private Map<AbstractPerspectiveBuilder, ApplicationPerspective> perspectiveByBuilderMap;

    public static PerspectiveMenuPanel createMenuPanel(ApplicationInstanceData applicationInstanceData, AbstractPerspectiveBuilder ... perspectiveBuilders) {
        return PerspectiveMenuPanel.createMenuPanel(applicationInstanceData, Arrays.asList(perspectiveBuilders));
    }

    public static PerspectiveMenuPanel createMenuPanel(ApplicationInstanceData applicationInstanceData, List<AbstractPerspectiveBuilder> perspectiveBuilders) {
        return new PerspectiveMenuPanel(applicationInstanceData, perspectiveBuilders);
    }

    public PerspectiveMenuPanel(ApplicationInstanceData applicationInstanceData, List<AbstractPerspectiveBuilder> perspectiveBuilders) {
        this.applicationInstanceData = applicationInstanceData;
        this.perspectiveBuilders = perspectiveBuilders;
        this.init();
    }

    private void init() {
        this.perspectiveByBuilderMap = new HashMap<AbstractPerspectiveBuilder, ApplicationPerspective>();
        List<AbstractPerspectiveBuilder> allowedPerspectiveBuilders = this.perspectiveBuilders.stream().filter(p -> p.isPerspectiveAccessible(this.applicationInstanceData)).collect(Collectors.toList());
        this.createButtonMenu(allowedPerspectiveBuilders);
        this.createTree(allowedPerspectiveBuilders);
    }

    private void createButtonMenu(List<AbstractPerspectiveBuilder> allowedPerspectiveBuilders) {
        this.buttonMenu = new SimpleItemView();
        SimpleItemGroup itemGroup = this.buttonMenu.addSingleColumnGroup(ApplicationIcons.WINDOW_EXPLORER, this.applicationInstanceData.getLocalized("org.teamapps.dictionary.views", new Object[0]));
        itemGroup.setItemTemplate((Template)BaseTemplate.LIST_ITEM_VERY_LARGE_ICON_TWO_LINES);
        allowedPerspectiveBuilders.forEach(builder -> itemGroup.addItem((Icon)builder.getIcon(), (String)this.applicationInstanceData.getLocalized((String)builder.getTitleKey(), (Object[])new Object[0]), (String)this.applicationInstanceData.getLocalized((String)builder.getDescriptionKey(), (Object[])new Object[0])).onClick.addListener(() -> this.openPerspective((AbstractPerspectiveBuilder)builder)));
    }

    private void createTree(List<AbstractPerspectiveBuilder> allowedPerspectiveBuilders) {
        ListTreeModel treeModel = new ListTreeModel(allowedPerspectiveBuilders);
        this.tree = new Tree((TreeModel)treeModel);
        this.tree.setShowExpanders(false);
        this.tree.setEntryTemplate((Template)BaseTemplate.LIST_ITEM_VERY_LARGE_ICON_TWO_LINES);
        this.tree.setPropertyExtractor((builder, propertyName) -> switch (propertyName) {
            case "icon" -> builder.getIcon();
            case "caption" -> this.applicationInstanceData.getLocalized(builder.getTitleKey(), new Object[0]);
            case "description" -> this.applicationInstanceData.getLocalized(builder.getDescriptionKey(), new Object[0]);
            default -> null;
        });
        this.tree.onNodeSelected.addListener(this::openPerspective);
        if (!treeModel.getRecords().isEmpty()) {
            this.tree.setSelectedNode((Object)((AbstractPerspectiveBuilder)treeModel.getRecords().get(0)));
        }
    }

    public void openPerspective(AbstractPerspectiveBuilder builder) {
        ApplicationPerspective applicationPerspective = this.perspectiveByBuilderMap.get(builder);
        if (applicationPerspective == null) {
            applicationPerspective = builder.build(this.applicationInstanceData, null);
            this.perspectiveByBuilderMap.put(builder, applicationPerspective);
        }
        this.tree.setSelectedNode((Object)builder);
        this.applicationInstanceData.showPerspective(applicationPerspective.getPerspective());
    }

    public void addInstantiatedPerspective(AbstractPerspectiveBuilder builder, ApplicationPerspective perspective) {
        this.perspectiveByBuilderMap.put(builder, perspective);
        if (this.tree != null) {
            this.tree.setSelectedNode((Object)this.tree.getModel().getRecords().stream().filter(record -> record.equals(builder)).findAny().orElse(null));
        }
    }

    public Component getComponent() {
        return this.tree;
    }

    public SimpleItemView<AbstractPerspectiveBuilder> getButtonMenu() {
        return this.buttonMenu;
    }
}

