/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.api.privilege;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.teamapps.application.api.privilege.CustomObjectPrivilegeGroup;
import org.teamapps.application.api.privilege.OrganizationalPrivilegeGroup;
import org.teamapps.application.api.privilege.Privilege;
import org.teamapps.application.api.privilege.PrivilegeGroup;
import org.teamapps.application.api.privilege.PrivilegeObject;
import org.teamapps.application.api.privilege.SimpleCustomObjectPrivilege;
import org.teamapps.application.api.privilege.SimpleOrganizationalPrivilege;
import org.teamapps.application.api.privilege.SimplePrivilege;
import org.teamapps.application.api.privilege.StandardPrivilegeGroup;
import org.teamapps.application.api.theme.ApplicationIcons;
import org.teamapps.icons.Icon;

public class ApplicationPrivilegeBuilder {
    private List<PrivilegeGroup> privilegeGroups = new ArrayList<PrivilegeGroup>();
    public SimplePrivilege LAUNCH_APPLICATION = this.addSimplePrivilege("org.teamapps.privilege.launchApplication", ApplicationIcons.WINDOW, "org.teamapps.dictionary.launchApplication", "org.teamapps.dictionary.allowsAUserToLaunchTheApplication");

    public SimplePrivilege addSimplePrivilege(String name, Icon icon, String titleKey, String descriptionKey) {
        SimplePrivilege privilegeGroup = PrivilegeGroup.createSimplePrivilege(name, icon, titleKey, descriptionKey);
        this.addPrivilege(privilegeGroup);
        return privilegeGroup;
    }

    public SimpleOrganizationalPrivilege addSimpleOrganizationalPrivilege(String name, Icon icon, String titleKey, String descriptionKey) {
        SimpleOrganizationalPrivilege privilegeGroup = PrivilegeGroup.createSimpleOrganizationalPrivilege(name, icon, titleKey, descriptionKey);
        this.addPrivilege(privilegeGroup);
        return privilegeGroup;
    }

    public SimpleCustomObjectPrivilege addSimpleCustomObjectPrivilege(String name, Icon icon, String titleKey, String descriptionKey, Supplier<List<PrivilegeObject>> privilegeObjectsSupplier) {
        SimpleCustomObjectPrivilege privilegeGroup = PrivilegeGroup.createSimpleCustomObjectPrivilege(name, icon, titleKey, descriptionKey, privilegeObjectsSupplier);
        this.addPrivilege(privilegeGroup);
        return privilegeGroup;
    }

    public StandardPrivilegeGroup addDefaultStandardPrivilegeGroup(String name, Icon icon, String titleKey, String descriptionKey) {
        return this.addStandardPrivilegeGroup(name, icon, titleKey, descriptionKey, Privilege.getDefault());
    }

    public StandardPrivilegeGroup addStandardPrivilegeGroup(String name, Icon icon, String titleKey, String descriptionKey, Privilege ... privileges) {
        StandardPrivilegeGroup privilegeGroup = PrivilegeGroup.createStandardPrivilegeGroup(name, icon, titleKey, descriptionKey, privileges);
        this.addPrivilege(privilegeGroup);
        return privilegeGroup;
    }

    public OrganizationalPrivilegeGroup addDefaultOrganizationalPrivilegeGroup(String name, Icon icon, String titleKey, String descriptionKey) {
        return this.addOrganizationalPrivilegeGroup(name, icon, titleKey, descriptionKey, Privilege.getDefault());
    }

    public OrganizationalPrivilegeGroup addOrganizationalPrivilegeGroup(String name, Icon icon, String titleKey, String descriptionKey, Privilege ... privileges) {
        OrganizationalPrivilegeGroup privilegeGroup = PrivilegeGroup.createOrganizationalPrivilegeGroup(name, icon, titleKey, descriptionKey, privileges);
        this.addPrivilege(privilegeGroup);
        return privilegeGroup;
    }

    public CustomObjectPrivilegeGroup addCustomObjectPrivilegeGroup(String name, Icon icon, String titleKey, String descriptionKey, List<Privilege> privileges, Supplier<List<PrivilegeObject>> privilegeObjectsSupplier) {
        CustomObjectPrivilegeGroup privilegeGroup = PrivilegeGroup.createCustomObjectPrivilegeGroup(name, icon, titleKey, descriptionKey, privileges, privilegeObjectsSupplier);
        this.addPrivilege(privilegeGroup);
        return privilegeGroup;
    }

    private PrivilegeGroup addPrivilege(PrivilegeGroup privilegeGroup) {
        this.privilegeGroups.add(privilegeGroup);
        return privilegeGroup;
    }

    public List<PrivilegeGroup> getPrivileges() {
        return this.privilegeGroups;
    }
}

