package org.teamapps.model.system;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.transaction.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.query.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


public class UdbSystemStartsQuery extends AbstractUdbQuery<SystemStarts> implements SystemStartsQuery {

    public UdbSystemStartsQuery() {
        super(UdbSystemStarts.table, SystemStarts.getBuilder());
    }

	@Override
	public SystemStartsQuery fullTextFilter(TextFilter textFilter, String... fieldNames) {
    	and(UdbSystemStarts.table.createFullTextFilter(textFilter, fieldNames));
		return this;
	}

	@Override
	public SystemStartsQuery parseFullTextFilter(String query, String... fieldNames) {
    	and(UdbSystemStarts.table.createFullTextFilter(query, fieldNames));
		return this;
	}

	@Override
	public SystemStartsQuery timestamp(NumericFilter filter) {
		and(UdbSystemStarts.timestamp.createFilter(filter));
		return this;
	}

	@Override
	public SystemStartsQuery orTimestamp(NumericFilter filter) {
		or(UdbSystemStarts.timestamp.createFilter(filter));
		return this;
	}

	@Override
	public SystemStartsQuery type(EnumFilterType filterType, Type... enums) {
		and(UdbSystemStarts.type.createFilter(NumericFilter.createEnumFilter(filterType, enums)));
		return this;
	}

	@Override
	public SystemStartsQuery orType(EnumFilterType filterType, Type... enums) {
		or(UdbSystemStarts.type.createFilter(NumericFilter.createEnumFilter(filterType, enums)));
		return this;
	}


	@Override
	public UdbSystemStartsQuery andOr(SystemStartsQuery ... queries) {
	    AbstractUdbQuery[] abstractUdbQueries = Arrays.copyOf(queries, queries.length, AbstractUdbQuery[].class);
		andOr(abstractUdbQueries);
		return this;
	}

    @Override
    public SystemStartsQuery customFilter(Function<SystemStarts, Boolean> customFilter) {
        Function<Integer, Boolean> filterFunction = id -> {
            return customFilter.apply(SystemStarts.getById(id));
        };
        and(new CustomEntityFilter(filterFunction));
        return this;
    }

}



