/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.ux.form;

import java.util.ArrayList;
import java.util.List;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.ux.window.ApplicationWindow;
import org.teamapps.icons.Icon;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.form.ResponsiveForm;
import org.teamapps.ux.component.form.ResponsiveFormLayout;

public class FormWindow
extends ApplicationWindow {
    private ResponsiveForm responsiveForm;
    private ResponsiveFormLayout formLayout;
    private List<AbstractField> fields = new ArrayList<AbstractField>();

    public FormWindow(Icon icon, String title, ApplicationInstanceData applicationInstanceData) {
        super(icon, title, applicationInstanceData);
        this.init();
    }

    private void init() {
        this.responsiveForm = new ResponsiveForm(100, 150, 0);
        this.formLayout = this.responsiveForm.addResponsiveFormLayout(500);
        this.setContent((Component)this.responsiveForm);
    }

    public void addSection() {
        this.formLayout.addSection().setDrawHeaderLine(false);
    }

    public void addSection(Icon icon, String title) {
        this.formLayout.addSection(icon, title);
    }

    public void addField(String label, Component field) {
        this.addField(null, label, field);
    }

    public void addField(Icon icon, String label, Component field) {
        this.formLayout.addLabelAndComponent(icon, label, field);
        if (field instanceof AbstractField) {
            this.fields.add((AbstractField)field);
        }
    }

    public ResponsiveForm getResponsiveForm() {
        return this.responsiveForm;
    }

    public ResponsiveFormLayout getFormLayout() {
        return this.formLayout;
    }

    public List<AbstractField> getFields() {
        return this.fields;
    }
}

