/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.tools;

import java.util.List;
import java.util.function.Supplier;
import org.teamapps.application.tools.AbstractRecordTableModel;
import org.teamapps.data.value.SortDirection;
import org.teamapps.data.value.Sorting;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.pojo.AbstractUdbQuery;
import org.teamapps.universaldb.pojo.Entity;
import org.teamapps.universaldb.pojo.Query;
import org.teamapps.universaldb.record.EntityBuilder;

public class EntityTableModel<ENTITY extends Entity<ENTITY>>
extends AbstractRecordTableModel<ENTITY> {
    private final Supplier<Query<ENTITY>> querySupplier;
    private final TableIndex tableIndex;
    private final EntityBuilder<ENTITY> entityBuilder;

    public EntityTableModel(Supplier<Query<ENTITY>> querySupplier) {
        this.querySupplier = querySupplier;
        AbstractUdbQuery udbQuery = (AbstractUdbQuery)querySupplier.get();
        this.tableIndex = udbQuery.getTableIndex();
        this.entityBuilder = udbQuery.getEntityBuilder();
    }

    @Override
    List<ENTITY> executeQuery(String fullTextSearchString, Sorting sorting) {
        AbstractUdbQuery query = (AbstractUdbQuery)this.querySupplier.get();
        if (fullTextSearchString != null) {
            query.addFullTextQuery(fullTextSearchString, new String[0]);
        }
        String sortField = sorting != null ? sorting.getFieldName() : null;
        boolean sortAscending = sorting == null || sorting.getSortDirection() == SortDirection.ASC;
        return query.execute(sortField, sortAscending, null, new String[0]);
    }
}

