/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.ux.form;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.ux.form.FormValidationUtils;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.Fields;
import org.teamapps.ux.component.field.validator.FieldValidator;

public class FormValidator {
    private final ApplicationInstanceData applicationInstanceData;
    private Set<AbstractField<?>> fields = new HashSet();

    public FormValidator(ApplicationInstanceData applicationInstanceData) {
        this.applicationInstanceData = applicationInstanceData;
    }

    public <VALUE> void addValidator(AbstractField<VALUE> field, Function<VALUE, String> errorMessageOrNullFunction) {
        field.addValidator(FieldValidator.fromErrorMessageFunction(errorMessageOrNullFunction));
        this.fields.add(field);
    }

    public void addNotNull(AbstractField field) {
        field.addValidator(FormValidationUtils.createNotNullValidator(this.applicationInstanceData));
        this.fields.add(field);
    }

    public void addNotEmptyList(AbstractField field) {
        field.addValidator(FormValidationUtils.createNotEmptyListValidator(this.applicationInstanceData));
        this.fields.add(field);
    }

    public void addNotBlank(AbstractField<String> field) {
        field.addValidator(FormValidationUtils.createNotBlankValidator(this.applicationInstanceData));
        this.fields.add(field);
    }

    public void addMinCharacters(AbstractField<String> field, int chars) {
        field.addValidator(FormValidationUtils.createMinCharactersValidator(chars, this.applicationInstanceData));
        this.fields.add(field);
    }

    public void addMinCharactersOrEmpty(AbstractField<String> field, int chars) {
        field.addValidator(FormValidationUtils.createMinCharactersOrEmptyValidator(chars, this.applicationInstanceData));
        this.fields.add(field);
    }

    public void addMaxCharacters(AbstractField<String> field, int chars) {
        field.addValidator(FormValidationUtils.createMaxCharactersValidator(chars, this.applicationInstanceData));
        this.fields.add(field);
    }

    public void addEmail(AbstractField<String> field) {
        field.addValidator(FormValidationUtils.createEmailValidator(this.applicationInstanceData));
        this.fields.add(field);
    }

    public void addEmailOrEmpty(AbstractField<String> field) {
        field.addValidator(FormValidationUtils.createEmailOrEmptyValidator(this.applicationInstanceData));
        this.fields.add(field);
    }

    public void addPhoneNumber(AbstractField<String> field) {
        field.addValidator(FormValidationUtils.createPhoneNumberValidator(this.applicationInstanceData));
        this.fields.add(field);
    }

    public void addPhoneOrEmptyNumber(AbstractField<String> field) {
        field.addValidator(FormValidationUtils.createPhoneNumberOrEmptyValidator(this.applicationInstanceData));
        this.fields.add(field);
    }

    public void addFieldWithValidator(AbstractField<?> field) {
        this.fields.add(field);
    }

    public boolean validate() {
        return Fields.validateAll(new ArrayList(this.fields));
    }

    public void clearMessages() {
        this.fields.forEach(AbstractField::clearValidatorMessages);
    }

    public Set<AbstractField<?>> getFields() {
        return this.fields;
    }
}

