/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.ux.org;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.ux.IconUtils;
import org.teamapps.application.ux.localize.TranslatableTextUtils;
import org.teamapps.data.extract.PropertyProvider;
import org.teamapps.model.controlcenter.GeoLocationType;
import org.teamapps.model.controlcenter.OrganizationFieldView;
import org.teamapps.model.controlcenter.OrganizationUnitTypeView;
import org.teamapps.model.controlcenter.OrganizationUnitView;
import org.teamapps.universaldb.index.translation.TranslatableText;
import org.teamapps.ux.component.field.combobox.ComboBox;
import org.teamapps.ux.component.field.combobox.TagBoxWrappingMode;
import org.teamapps.ux.component.field.combobox.TagComboBox;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.Template;
import org.teamapps.ux.component.tree.TreeNodeInfo;
import org.teamapps.ux.component.tree.TreeNodeInfoImpl;
import org.teamapps.ux.model.ComboBoxModel;
import org.teamapps.ux.model.ListTreeModel;

public class OrganizationViewUtils {
    public static Set<OrganizationUnitView> getAllUnits(OrganizationUnitView unit, Collection<OrganizationUnitTypeView> unitTypesFilter) {
        HashSet<OrganizationUnitView> result = new HashSet<OrganizationUnitView>();
        HashSet<OrganizationUnitView> traversedNodes = new HashSet<OrganizationUnitView>();
        HashSet<OrganizationUnitTypeView> filter = unitTypesFilter != null && !unitTypesFilter.isEmpty() ? new HashSet<OrganizationUnitTypeView>(unitTypesFilter) : null;
        OrganizationViewUtils.calculateAllUnits(unit, filter, traversedNodes, result);
        return result;
    }

    private static void calculateAllUnits(OrganizationUnitView unit, Set<OrganizationUnitTypeView> unitTypesFilter, Set<OrganizationUnitView> traversedNodes, Set<OrganizationUnitView> result) {
        if (unitTypesFilter == null || unitTypesFilter.contains(unit.getType())) {
            result.add(unit);
        }
        for (OrganizationUnitView child : unit.getChildren()) {
            if (traversedNodes.contains(child)) continue;
            traversedNodes.add(child);
            OrganizationViewUtils.calculateAllUnits(child, unitTypesFilter, traversedNodes, result);
        }
    }

    public static ComboBox<OrganizationFieldView> createOrganizationFieldCombo(ApplicationInstanceData applicationInstanceData) {
        ComboBox comboBox = new ComboBox((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE);
        comboBox.setModel((ComboBoxModel)new ListTreeModel(OrganizationFieldView.getAll()));
        comboBox.setPropertyProvider(OrganizationViewUtils.createOrganizationFieldViewPropertyProvider(applicationInstanceData));
        return comboBox;
    }

    public static int getOrgLevel(OrganizationUnitView unit) {
        int level = 0;
        for (OrganizationUnitView parent = unit.getParent(); parent != null; parent = parent.getParent()) {
            ++level;
        }
        return level;
    }

    public static OrganizationUnitView getParentWithGeoType(OrganizationUnitView unit, GeoLocationType type) {
        if (unit == null) {
            return null;
        }
        for (OrganizationUnitView parent = unit.getParent(); parent != null; parent = parent.getParent()) {
            if (parent.getType().getGeoLocationType() != type) continue;
            return parent;
        }
        return null;
    }

    public static ComboBox<OrganizationUnitView> createOrganizationComboBox(Template template, Collection<OrganizationUnitView> allowedUnits, ApplicationInstanceData applicationInstanceData) {
        return OrganizationViewUtils.createOrganizationComboBox(template, () -> allowedUnits, applicationInstanceData);
    }

    public static ComboBox<OrganizationUnitView> createOrganizationComboBox(Template template, Supplier<Collection<OrganizationUnitView>> allowedUnitsSupplier, ApplicationInstanceData applicationInstanceData) {
        return OrganizationViewUtils.createOrganizationComboBox(template, allowedUnitsSupplier, null, applicationInstanceData);
    }

    public static ComboBox<OrganizationUnitView> createOrganizationComboBox(Template template, Supplier<Collection<OrganizationUnitView>> allowedUnitsSupplier, Set<OrganizationUnitTypeView> selectableTypes, ApplicationInstanceData applicationInstanceData) {
        ComboBox comboBox = new ComboBox(template);
        ComboBoxModel<OrganizationUnitView> model = OrganizationViewUtils.createLazyOrgUnitModel(allowedUnitsSupplier, selectableTypes);
        comboBox.setModel(model);
        comboBox.setShowExpanders(true);
        PropertyProvider<OrganizationUnitView> propertyProvider = OrganizationViewUtils.creatOrganizationUnitViewPropertyProvider(applicationInstanceData);
        comboBox.setPropertyProvider(propertyProvider);
        Function<OrganizationUnitView, String> recordToStringFunction = unit -> {
            Map values = propertyProvider.getValues(unit, Collections.singleton("caption"));
            Object result = values.get("caption");
            return (String)result;
        };
        comboBox.setRecordToStringFunction(recordToStringFunction);
        return comboBox;
    }

    public static ComboBoxModel<OrganizationUnitView> createLazyOrgUnitModel(final Supplier<Collection<OrganizationUnitView>> allowedUnitsSupplier, final Set<OrganizationUnitTypeView> selectableTypes) {
        ComboBoxModel<OrganizationUnitView> model = new ComboBoxModel<OrganizationUnitView>(){

            public List<OrganizationUnitView> getRecords(String query) {
                Collection nodes = (Collection)allowedUnitsSupplier.get();
                return query == null || query.isBlank() ? OrganizationViewUtils.getRootNodes(nodes) : OrganizationViewUtils.getRootNodes(OrganizationUnitView.filter().parseFullTextFilter(query, new String[0]).execute().stream().filter(nodes::contains).limit(250L).collect(Collectors.toList()));
            }

            public List<OrganizationUnitView> getChildRecords(OrganizationUnitView unit) {
                Collection organizationUnitViews = (Collection)allowedUnitsSupplier.get();
                return unit.getChildren().stream().filter(organizationUnitViews::contains).collect(Collectors.toList());
            }

            public TreeNodeInfo getTreeNodeInfo(OrganizationUnitView unit) {
                return new TreeNodeInfoImpl((Object)unit.getParent(), false, selectableTypes == null || selectableTypes.contains(unit.getType()), unit.getChildrenCount() > 0);
            }
        };
        return model;
    }

    private static List<OrganizationUnitView> getRootNodesOrSortByOrgLevel(Collection<OrganizationUnitView> nodes, int maxUnitsWithoutFiltering) {
        if (nodes.size() <= maxUnitsWithoutFiltering) {
            return new ArrayList<OrganizationUnitView>(nodes).stream().sorted(Comparator.comparingInt(OrganizationViewUtils::getOrgLevel)).collect(Collectors.toList());
        }
        return OrganizationViewUtils.getRootNodes(nodes);
    }

    private static List<OrganizationUnitView> getRootNodes(Collection<OrganizationUnitView> nodes) {
        Set<Object> set = nodes instanceof Set ? (Set<Object>)nodes : new HashSet<OrganizationUnitView>(nodes);
        return nodes.stream().filter(node -> node.getParent() == null || !set.contains(node.getParent())).collect(Collectors.toList());
    }

    public static TagComboBox<OrganizationUnitTypeView> createOrganizationUnitTypeTagComboBox(int limit, ApplicationInstanceData applicationInstanceData) {
        TagComboBox tagComboBox = new TagComboBox((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE);
        tagComboBox.setModel(query -> query == null || query.isBlank() ? OrganizationUnitTypeView.getAll().stream().limit(limit).collect(Collectors.toList()) : OrganizationUnitTypeView.filter().parseFullTextFilter(query, new String[0]).execute().stream().limit(limit).collect(Collectors.toList()));
        PropertyProvider<OrganizationUnitTypeView> propertyProvider = OrganizationViewUtils.creatOrganizationUnitTypeViewPropertyProvider(applicationInstanceData);
        tagComboBox.setPropertyProvider(propertyProvider);
        tagComboBox.setRecordToStringFunction(unitType -> (String)propertyProvider.getValues(unitType, Collections.emptyList()).get("caption"));
        tagComboBox.setWrappingMode(TagBoxWrappingMode.SINGLE_TAG_PER_LINE);
        tagComboBox.setDistinct(true);
        return tagComboBox;
    }

    public static PropertyProvider<OrganizationUnitView> creatOrganizationUnitViewPropertyProvider(ApplicationInstanceData applicationInstanceData) {
        Function<TranslatableText, String> translatableTextExtractor = TranslatableTextUtils.createTranslatableTextExtractor(applicationInstanceData);
        return (unit, propertyNames) -> {
            Object prefix = "";
            String abbreviation = (String)translatableTextExtractor.apply(unit.getType().getAbbreviation());
            if (abbreviation != null) {
                prefix = abbreviation + "-";
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("icon", unit.getIcon() != null ? IconUtils.decodeIcon(unit.getIcon()) : IconUtils.decodeIcon(unit.getType().getIcon()));
            map.put("caption", (String)prefix + (String)translatableTextExtractor.apply(unit.getName()));
            map.put("description", translatableTextExtractor.apply(unit.getType().getName()));
            return map;
        };
    }

    public static PropertyProvider<OrganizationUnitTypeView> creatOrganizationUnitTypeViewPropertyProvider(ApplicationInstanceData applicationInstanceData) {
        Function<TranslatableText, String> translatableTextExtractor = TranslatableTextUtils.createTranslatableTextExtractor(applicationInstanceData);
        return (unitType, propertyNames) -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("icon", IconUtils.decodeIcon(unitType.getIcon()));
            map.put("caption", translatableTextExtractor.apply(unitType.getName()));
            map.put("description", translatableTextExtractor.apply(unitType.getAbbreviation()));
            return map;
        };
    }

    public static PropertyProvider<OrganizationFieldView> createOrganizationFieldViewPropertyProvider(ApplicationInstanceData applicationInstanceData) {
        return (organizationFieldView, propertyNames) -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("icon", IconUtils.decodeIcon(organizationFieldView.getIcon()));
            map.put("caption", applicationInstanceData.getLocalized(organizationFieldView.getTitle()));
            return map;
        };
    }
}

