package org.teamapps.mock.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.reference.value.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.query.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.util.function.Function;


public interface OrganizationUnitTypeQuery extends Query<OrganizationUnitType> {

    static OrganizationUnitTypeQuery create() {
        return new UdbOrganizationUnitTypeQuery();
    }

    OrganizationUnitTypeQuery id(Integer... ids);

    OrganizationUnitTypeQuery id(BitSet ids);

    OrganizationUnitTypeQuery id(Collection<Integer> ids);

    OrganizationUnitTypeQuery fullTextFilter(TextFilter textFilter, String... fieldNames);

    OrganizationUnitTypeQuery parseFullTextFilter(String query, String... fieldNames);

	OrganizationUnitTypeQuery metaCreationDate(NumericFilter filter);

	OrganizationUnitTypeQuery orMetaCreationDate(NumericFilter filter);

	OrganizationUnitTypeQuery metaCreatedBy(NumericFilter filter);

	OrganizationUnitTypeQuery orMetaCreatedBy(NumericFilter filter);

	OrganizationUnitTypeQuery metaModificationDate(NumericFilter filter);

	OrganizationUnitTypeQuery orMetaModificationDate(NumericFilter filter);

	OrganizationUnitTypeQuery metaModifiedBy(NumericFilter filter);

	OrganizationUnitTypeQuery orMetaModifiedBy(NumericFilter filter);

	OrganizationUnitTypeQuery metaDeletionDate(NumericFilter filter);

	OrganizationUnitTypeQuery orMetaDeletionDate(NumericFilter filter);

	OrganizationUnitTypeQuery metaDeletedBy(NumericFilter filter);

	OrganizationUnitTypeQuery orMetaDeletedBy(NumericFilter filter);

	OrganizationUnitTypeQuery metaRestoreDate(NumericFilter filter);

	OrganizationUnitTypeQuery orMetaRestoreDate(NumericFilter filter);

	OrganizationUnitTypeQuery metaRestoredBy(NumericFilter filter);

	OrganizationUnitTypeQuery orMetaRestoredBy(NumericFilter filter);

	OrganizationUnitTypeQuery name(TranslatableTextFilter filter);

	OrganizationUnitTypeQuery orName(TranslatableTextFilter filter);

	OrganizationUnitTypeQuery abbreviation(TranslatableTextFilter filter);

	OrganizationUnitTypeQuery orAbbreviation(TranslatableTextFilter filter);

	OrganizationUnitTypeQuery icon(TextFilter filter);

	OrganizationUnitTypeQuery orIcon(TextFilter filter);

	OrganizationUnitTypeQuery translateOrganizationUnits(BooleanFilter filter);

	OrganizationUnitTypeQuery orTranslateOrganizationUnits(BooleanFilter filter);

	OrganizationUnitTypeQuery allowUserContainer(BooleanFilter filter);

	OrganizationUnitTypeQuery orAllowUserContainer(BooleanFilter filter);

	OrganizationUnitTypeQuery filterDefaultChildType(OrganizationUnitTypeQuery query);

	OrganizationUnitTypeQuery defaultChildType(NumericFilter filter);

	OrganizationUnitTypeQuery orDefaultChildType(NumericFilter filter);

	OrganizationUnitTypeQuery filterPossibleChildrenTypes(OrganizationUnitTypeQuery query);

	OrganizationUnitTypeQuery possibleChildrenTypes(MultiReferenceFilterType type, OrganizationUnitType ... value);

	OrganizationUnitTypeQuery possibleChildrenTypesCount(MultiReferenceFilterType type, int count);

	OrganizationUnitTypeQuery possibleChildrenTypes(MultiReferenceFilter filter);

	OrganizationUnitTypeQuery orPossibleChildrenTypes(MultiReferenceFilter filter);

	OrganizationUnitTypeQuery geoLocationType(EnumFilterType filterType, GeoLocationType ... enums);

	OrganizationUnitTypeQuery orGeoLocationType(EnumFilterType filterType, GeoLocationType ... enums);


    OrganizationUnitTypeQuery andOr(OrganizationUnitTypeQuery... queries);

    OrganizationUnitTypeQuery customFilter(Function<OrganizationUnitType, Boolean> customFilter);

    List<OrganizationUnitType> execute();

    List<OrganizationUnitType> executeOnDeletedRecords();

    OrganizationUnitType executeExpectSingleton();

    BitSet executeToBitSet();

    List<OrganizationUnitType> execute(String sortFieldName, boolean ascending, UserContext userContext, String ... path);

    List<OrganizationUnitType> execute(boolean deletedRecords, String sortFieldName, boolean ascending, UserContext userContext, String ... path);

    List<OrganizationUnitType> execute(int startIndex, int length, Sorting sorting, UserContext userContext);

}

