package org.teamapps.model.system;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.reference.value.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.query.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.util.function.Function;


public interface SystemStartsQuery extends Query<SystemStarts> {

    static SystemStartsQuery create() {
        return new UdbSystemStartsQuery();
    }

    SystemStartsQuery id(Integer... ids);

    SystemStartsQuery id(BitSet ids);

    SystemStartsQuery id(Collection<Integer> ids);

    SystemStartsQuery fullTextFilter(TextFilter textFilter, String... fieldNames);

    SystemStartsQuery parseFullTextFilter(String query, String... fieldNames);

	SystemStartsQuery timestamp(NumericFilter filter);

	SystemStartsQuery orTimestamp(NumericFilter filter);

	SystemStartsQuery type(EnumFilterType filterType, Type ... enums);

	SystemStartsQuery orType(EnumFilterType filterType, Type ... enums);


    SystemStartsQuery andOr(SystemStartsQuery... queries);

    SystemStartsQuery customFilter(Function<SystemStarts, Boolean> customFilter);

    List<SystemStarts> execute();

    List<SystemStarts> executeOnDeletedRecords();

    SystemStarts executeExpectSingleton();

    BitSet executeToBitSet();

    List<SystemStarts> execute(String sortFieldName, boolean ascending, UserContext userContext, String ... path);

    List<SystemStarts> execute(boolean deletedRecords, String sortFieldName, boolean ascending, UserContext userContext, String ... path);

    List<SystemStarts> execute(int startIndex, int length, Sorting sorting, UserContext userContext);

}

