package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.reference.value.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.query.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.util.function.Function;


public interface AddressViewQuery extends Query<AddressView> {

    static AddressViewQuery create() {
        return new UdbAddressViewQuery();
    }

    AddressViewQuery id(Integer... ids);

    AddressViewQuery id(BitSet ids);

    AddressViewQuery id(Collection<Integer> ids);

    AddressViewQuery fullTextFilter(TextFilter textFilter, String... fieldNames);

    AddressViewQuery parseFullTextFilter(String query, String... fieldNames);

	AddressViewQuery name(TextFilter filter);

	AddressViewQuery orName(TextFilter filter);

	AddressViewQuery organisation(TextFilter filter);

	AddressViewQuery orOrganisation(TextFilter filter);

	AddressViewQuery street(TextFilter filter);

	AddressViewQuery orStreet(TextFilter filter);

	AddressViewQuery city(TextFilter filter);

	AddressViewQuery orCity(TextFilter filter);

	AddressViewQuery dependentLocality(TextFilter filter);

	AddressViewQuery orDependentLocality(TextFilter filter);

	AddressViewQuery state(TextFilter filter);

	AddressViewQuery orState(TextFilter filter);

	AddressViewQuery postalCode(TextFilter filter);

	AddressViewQuery orPostalCode(TextFilter filter);

	AddressViewQuery country(TextFilter filter);

	AddressViewQuery orCountry(TextFilter filter);

	AddressViewQuery latitude(NumericFilter filter);

	AddressViewQuery orLatitude(NumericFilter filter);

	AddressViewQuery longitude(NumericFilter filter);

	AddressViewQuery orLongitude(NumericFilter filter);


    AddressViewQuery andOr(AddressViewQuery... queries);

    AddressViewQuery customFilter(Function<AddressView, Boolean> customFilter);

}

