/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.teamapps.application.api.application.ApplicationBuilder;
import org.teamapps.application.api.localization.ApplicationLocalizationProvider;
import org.teamapps.application.api.localization.Language;
import org.teamapps.application.api.privilege.ApplicationRole;
import org.teamapps.application.api.theme.ApplicationIcons;
import org.teamapps.application.server.DevApplication;
import org.teamapps.application.server.DevLocalizationProvider;
import org.teamapps.application.ux.IconUtils;
import org.teamapps.application.ux.combo.ComboBoxUtils;
import org.teamapps.data.extract.PropertyProvider;
import org.teamapps.event.Event;
import org.teamapps.icon.antu.AntuIcon;
import org.teamapps.icon.flags.FlagIcon;
import org.teamapps.icon.fontawesome.FontAwesomeIcon;
import org.teamapps.icon.material.MaterialIcon;
import org.teamapps.mock.model.MockSchema;
import org.teamapps.model.ApiSchema;
import org.teamapps.model.controlcenter.OrganizationUnitView;
import org.teamapps.reporting.convert.DocumentConverter;
import org.teamapps.server.undertow.embedded.TeamAppsUndertowEmbeddedServer;
import org.teamapps.universaldb.UniversalDB;
import org.teamapps.universaldb.schema.SchemaInfoProvider;
import org.teamapps.ux.component.AbstractComponent;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.absolutelayout.Length;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.Button;
import org.teamapps.ux.component.field.combobox.ComboBox;
import org.teamapps.ux.component.form.ResponsiveForm;
import org.teamapps.ux.component.form.ResponsiveFormLayout;
import org.teamapps.ux.component.panel.ElegantPanel;
import org.teamapps.ux.component.rootpanel.RootPanel;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.Template;
import org.teamapps.ux.session.SessionContext;
import org.teamapps.webcontroller.WebController;

public class DevServer {
    private final ApplicationBuilder applicationBuilder;
    private int port = 8080;
    private File path = new File("./dev-database");
    private List<OrganizationUnitView> organizationUnitViews = Collections.emptyList();
    private DocumentConverter documentConverter;
    public Event<Void> onDevServerBooted = new Event();
    private static Class standardIconClass;

    public static DevServer create(ApplicationBuilder applicationBuilder) {
        return new DevServer(applicationBuilder);
    }

    protected DevServer(ApplicationBuilder applicationBuilder) {
        this.applicationBuilder = applicationBuilder;
    }

    public DevServer withDbPath(File path) {
        this.path = path;
        return this;
    }

    public DevServer withPort(int port) {
        this.port = port;
        return this;
    }

    public DevServer withOrganizationUnitViews(List<OrganizationUnitView> organizationUnitViews) {
        this.organizationUnitViews = organizationUnitViews;
        return this;
    }

    public DevServer withDocumentConverter(DocumentConverter documentConverter) {
        this.documentConverter = documentConverter;
        return this;
    }

    public void start() {
        try {
            this.path.mkdir();
            SchemaInfoProvider databaseModel = this.applicationBuilder.getDatabaseModel();
            if (databaseModel != null) {
                UniversalDB universalDB = UniversalDB.createStandalone((File)this.path, (SchemaInfoProvider)new MockSchema());
                ClassLoader classLoader = DevServer.class.getClassLoader();
                ApiSchema apiSchema = new ApiSchema();
                universalDB.addAuxiliaryModel((SchemaInfoProvider)apiSchema, classLoader);
                universalDB.addAuxiliaryModel(databaseModel, classLoader);
            }
            this.onDevServerBooted.fire();
            this.applicationBuilder.getOnApplicationInstalled().fire();
            this.applicationBuilder.getOnApplicationLoaded().fire();
            WebController webController = sessionContext -> {
                SessionContext context = SessionContext.current();
                this.registerBaseIconProvider(context);
                if (standardIconClass != null) {
                    context.getIconProvider().registerIconLibrary(standardIconClass);
                }
                RootPanel rootPanel = context.addRootPanel();
                ResponsiveForm form = new ResponsiveForm(120, 120, 300);
                ResponsiveFormLayout formLayout = form.addResponsiveFormLayout(420);
                ElegantPanel elegantPanel = new ElegantPanel();
                form.setMaxWidth(Length.ofPixels((int)430));
                elegantPanel.setContent((AbstractComponent)form);
                elegantPanel.setCssStyle(".content-container", "display", "flex");
                elegantPanel.setCssStyle(".content-container", "justify-content", "center");
                DevLocalizationProvider localizationProvider = new DevLocalizationProvider(this.applicationBuilder);
                localizationProvider.setLanguage(context.getLocale().getLanguage());
                ArrayList<RoleEntry> roleEntries = new ArrayList<RoleEntry>();
                roleEntries.add(new RoleEntry(null));
                if (this.applicationBuilder.getApplicationRoles() != null) {
                    roleEntries.addAll(this.applicationBuilder.getApplicationRoles().stream().map(RoleEntry::new).collect(Collectors.toList()));
                }
                ComboBox roleEntryComboBox = ComboBoxUtils.createRecordComboBox(roleEntries, (roleEntry, propertyNames) -> roleEntry.getPropertyMap(localizationProvider), (Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE);
                List<OrganizationUnitView> orgUnits = this.organizationUnitViews != null && !this.organizationUnitViews.isEmpty() ? this.organizationUnitViews : OrganizationUnitView.getAll();
                ComboBox<OrganizationUnitView> rootUnitsComboBox = this.createOrgUnitComboBox(localizationProvider, orgUnits);
                ComboBox<Language> languageComboBox = Language.createComboBox(localizationProvider);
                languageComboBox.setValue((Object)Language.getLanguageByIsoCode(context.getLocale().getLanguage()));
                if (!orgUnits.isEmpty()) {
                    rootUnitsComboBox.setValue((Object)orgUnits.get(0));
                }
                roleEntryComboBox.setValue((Object)((RoleEntry)roleEntries.get(0)));
                Button loginButton = Button.create((String)"Login");
                formLayout.addSection().setCollapsible(false).setDrawHeaderLine(false);
                formLayout.addLabelAndField(null, "Language", languageComboBox);
                formLayout.addLabelAndField(null, "Application role", roleEntryComboBox);
                formLayout.addLabelAndField(null, "Organization root", rootUnitsComboBox);
                formLayout.addLabelAndField(null, null, (AbstractField)loginButton);
                rootPanel.setContent((Component)elegantPanel);
                String loginBackground = "/resources/backgrounds/login.jpg";
                context.registerBackgroundImage("login", loginBackground, loginBackground);
                context.setBackgroundImage("login", 0);
                loginButton.onClicked.addListener(() -> {
                    ApplicationRole applicationRole = ((RoleEntry)roleEntryComboBox.getValue()).getRole();
                    String languageIso = ((Language)((Object)((Object)((Object)languageComboBox.getValue())))).getIsoCode();
                    Locale locale = Locale.forLanguageTag(languageIso);
                    List<OrganizationUnitView> units = this.getAllUnits((OrganizationUnitView)rootUnitsComboBox.getValue());
                    localizationProvider.setLanguage(languageIso);
                    DevApplication devApplication = new DevApplication(applicationRole, context, locale, localizationProvider, this.applicationBuilder, units, this.documentConverter);
                    rootPanel.setContent(devApplication.getComponent());
                    context.showDefaultBackground(0);
                });
            };
            File webAppDirectory = Files.createTempDirectory("teamapps", new FileAttribute[0]).toRealPath(new LinkOption[0]).toFile();
            TeamAppsUndertowEmbeddedServer server = new TeamAppsUndertowEmbeddedServer(webController, webAppDirectory, this.port);
            server.start();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void registerBaseIconProvider(SessionContext context) {
        context.getIconProvider().registerIconLibrary(FlagIcon.class);
        context.getIconProvider().registerIconLibrary(MaterialIcon.class);
        context.getIconProvider().registerIconLibrary(FontAwesomeIcon.class);
        context.getIconProvider().registerIconLibrary(AntuIcon.class);
    }

    private List<OrganizationUnitView> getAllUnits(OrganizationUnitView rootUnit) {
        if (rootUnit == null) {
            return this.organizationUnitViews;
        }
        HashSet<OrganizationUnitView> unitSet = new HashSet<OrganizationUnitView>();
        this.getUnits(rootUnit, unitSet);
        return new ArrayList<OrganizationUnitView>(unitSet);
    }

    private void getUnits(OrganizationUnitView unit, Set<OrganizationUnitView> unitSet) {
        if (!unitSet.contains(unit)) {
            unitSet.add(unit);
            unit.getChildren().forEach(child -> this.getUnits((OrganizationUnitView)child, unitSet));
        }
    }

    private ComboBox<OrganizationUnitView> createOrgUnitComboBox(ApplicationLocalizationProvider localizationProvider, List<OrganizationUnitView> unitRoots) {
        PropertyProvider organizationUnitViewPropertyProvider = (unit, propertyNames) -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("icon", IconUtils.decodeIcon(unit.getIcon()));
            map.put("caption", localizationProvider.getLocalized(unit.getName()));
            return map;
        };
        return ComboBoxUtils.createRecordComboBox(unitRoots, organizationUnitViewPropertyProvider, (Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE);
    }

    static {
        try {
            standardIconClass = Class.forName("org.teamapps.icon.standard.StandardIcon");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static class RoleEntry {
        private final ApplicationRole role;

        public RoleEntry(ApplicationRole role) {
            this.role = role;
        }

        public ApplicationRole getRole() {
            return this.role;
        }

        public Map<String, Object> getPropertyMap(ApplicationLocalizationProvider localizationProvider) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (this.role != null) {
                map.put("icon", this.role.getIcon());
                map.put("caption", localizationProvider.getLocalized(this.role.getTitleKey(), new Object[0]));
                map.put("description", localizationProvider.getLocalized(this.role.getDescriptionKey(), new Object[0]));
            } else {
                map.put("icon", ApplicationIcons.SHAPE_CIRCLE);
                map.put("caption", "Allow all");
                map.put("description", "Allow all privilege provider");
            }
            return map;
        }
    }
}

