/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.api.privilege;

import org.teamapps.application.api.privilege.PrivilegeImpl;
import org.teamapps.application.api.privilege.PrivilegeType;
import org.teamapps.application.api.theme.ApplicationIcons;
import org.teamapps.icons.Icon;

public interface Privilege {
    public static final Privilege CREATE = Privilege.create(PrivilegeType.CREATE, "create", ApplicationIcons.DOCUMENT_EMPTY, "org.teamapps.dictionary.create");
    public static final Privilege READ = Privilege.create(PrivilegeType.READ, "read", ApplicationIcons.DOCUMENT_TEXT, "org.teamapps.dictionary.read");
    public static final Privilege UPDATE = Privilege.create(PrivilegeType.UPDATE, "update", ApplicationIcons.EDIT, "org.teamapps.dictionary.update");
    public static final Privilege DELETE = Privilege.create(PrivilegeType.DELETE, "delete", ApplicationIcons.GARBAGE_EMPTY, "org.teamapps.dictionary.delete");
    public static final Privilege RESTORE = Privilege.create(PrivilegeType.RESTORE, "restore", ApplicationIcons.GARBAGE_MAKE_EMPTY, "org.teamapps.dictionary.restore");
    public static final Privilege SHOW_RECYCLE_BIN = Privilege.create(PrivilegeType.SHOW_RECYCLE_BIN, "readRecycleBin", ApplicationIcons.GARBAGE_OVERFLOW, "org.teamapps.dictionary.showRecycleBin");
    public static final Privilege SHOW_MODIFICATION_HISTORY = Privilege.create(PrivilegeType.SHOW_MODIFICATION_HISTORY, "readModificationHistory", ApplicationIcons.HISTORY, "org.teamapps.dictionary.showModificationHistory");
    public static final Privilege EXECUTE = Privilege.create(PrivilegeType.EXECUTE, "execute", ApplicationIcons.GEARWHEEL, "org.teamapps.dictionary.execute");
    public static final Privilege PRINT = Privilege.create(PrivilegeType.PRINT, "print", ApplicationIcons.PRINTER, "org.teamapps.dictionary.print");
    public static final Privilege IMPORT = Privilege.create(PrivilegeType.IMPORT, "import", ApplicationIcons.ARROW_INTO, "org.teamapps.dictionary.import");
    public static final Privilege EXPORT = Privilege.create(PrivilegeType.EXPORT, "export", ApplicationIcons.ARROW_OUT, "org.teamapps.dictionary.export");
    public static final Privilege CUSTOM = Privilege.create(PrivilegeType.CUSTOM, "custom", ApplicationIcons.LOCK_OPEN, "org.teamapps.dictionary.custom");

    public static Privilege create(PrivilegeType privilegeType, String name, Icon icon, String titleKey) {
        return new PrivilegeImpl(privilegeType, name, icon, titleKey);
    }

    public static Privilege[] getDefault() {
        return new Privilege[]{CREATE, READ, UPDATE, DELETE, RESTORE, SHOW_RECYCLE_BIN};
    }

    public static Privilege[] getAll() {
        return new Privilege[]{CREATE, READ, UPDATE, DELETE, RESTORE, SHOW_RECYCLE_BIN, EXECUTE, PRINT, IMPORT, EXPORT};
    }

    public PrivilegeType getType();

    public String getName();

    public Icon getIcon();

    public String getTitleKey();
}

