/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teamapps.application.api.privilege.ApplicationPrivilegeProvider;
import org.teamapps.application.api.privilege.ApplicationRole;
import org.teamapps.application.api.privilege.CustomObjectPrivilegeGroup;
import org.teamapps.application.api.privilege.OrganizationalPrivilegeGroup;
import org.teamapps.application.api.privilege.Privilege;
import org.teamapps.application.api.privilege.PrivilegeGroup;
import org.teamapps.application.api.privilege.PrivilegeObject;
import org.teamapps.application.api.privilege.RoleAssignmentDelegatedCustomPrivilegeGroup;
import org.teamapps.application.api.privilege.SimpleCustomObjectPrivilege;
import org.teamapps.application.api.privilege.SimpleOrganizationalPrivilege;
import org.teamapps.application.api.privilege.SimplePrivilege;
import org.teamapps.application.api.privilege.StandardPrivilegeGroup;
import org.teamapps.model.controlcenter.OrganizationUnitView;

public class DevApplicationRolePrivilegeProvider
implements ApplicationPrivilegeProvider {
    private final ApplicationRole applicationRole;
    private final Set<OrganizationUnitView> allowedUnits;
    private Set<SimplePrivilege> simplePrivileges = new HashSet<SimplePrivilege>();
    private Map<SimpleOrganizationalPrivilege, Set<OrganizationUnitView>> simpleOrganizationalPrivilegeSetMap = new HashMap<SimpleOrganizationalPrivilege, Set<OrganizationUnitView>>();
    private Map<SimpleCustomObjectPrivilege, Set<PrivilegeObject>> simpleCustomObjectPrivilegeSetMap = new HashMap<SimpleCustomObjectPrivilege, Set<PrivilegeObject>>();
    private Map<StandardPrivilegeGroup, Set<Privilege>> standardPrivilegeGroupSetMap = new HashMap<StandardPrivilegeGroup, Set<Privilege>>();
    private Map<OrganizationalPrivilegeGroup, Map<Privilege, Set<OrganizationUnitView>>> organizationalPrivilegeGroupMap = new HashMap<OrganizationalPrivilegeGroup, Map<Privilege, Set<OrganizationUnitView>>>();
    private Map<CustomObjectPrivilegeGroup, Map<Privilege, Set<PrivilegeObject>>> customObjectPrivilegeGroupMap = new HashMap<CustomObjectPrivilegeGroup, Map<Privilege, Set<PrivilegeObject>>>();

    public DevApplicationRolePrivilegeProvider(ApplicationRole applicationRole, Set<OrganizationUnitView> allowedUnits) {
        this.applicationRole = applicationRole;
        this.allowedUnits = allowedUnits;
        this.init();
    }

    private void init() {
        for (PrivilegeGroup privilegeGroup : this.applicationRole.getPrivilegeGroups()) {
            if (privilegeGroup instanceof SimplePrivilege) {
                SimplePrivilege simplePrivilege = (SimplePrivilege)privilegeGroup;
                this.simplePrivileges.add(simplePrivilege);
                continue;
            }
            if (privilegeGroup instanceof SimpleOrganizationalPrivilege) {
                SimpleOrganizationalPrivilege simpleOrganizationalPrivilege = (SimpleOrganizationalPrivilege)privilegeGroup;
                this.simpleOrganizationalPrivilegeSetMap.put(simpleOrganizationalPrivilege, this.allowedUnits);
                continue;
            }
            if (privilegeGroup instanceof SimpleCustomObjectPrivilege) {
                SimpleCustomObjectPrivilege customObjectPrivilege = (SimpleCustomObjectPrivilege)privilegeGroup;
                this.simpleCustomObjectPrivilegeSetMap.put(customObjectPrivilege, new HashSet(customObjectPrivilege.getPrivilegeObjectsSupplier().get()));
                continue;
            }
            if (privilegeGroup instanceof StandardPrivilegeGroup) {
                StandardPrivilegeGroup standardPrivilegeGroup = (StandardPrivilegeGroup)privilegeGroup;
                this.standardPrivilegeGroupSetMap.put(standardPrivilegeGroup, new HashSet<Privilege>(standardPrivilegeGroup.getPrivileges()));
                continue;
            }
            if (privilegeGroup instanceof OrganizationalPrivilegeGroup) {
                OrganizationalPrivilegeGroup organizationalPrivilegeGroup = (OrganizationalPrivilegeGroup)privilegeGroup;
                for (Privilege privilege : organizationalPrivilegeGroup.getPrivileges()) {
                    this.organizationalPrivilegeGroupMap.computeIfAbsent(organizationalPrivilegeGroup, pg -> new HashMap()).put(privilege, this.allowedUnits);
                }
                continue;
            }
            if (!(privilegeGroup instanceof CustomObjectPrivilegeGroup)) continue;
            CustomObjectPrivilegeGroup objectPrivilegeGroup = (CustomObjectPrivilegeGroup)privilegeGroup;
            for (Privilege privilege : objectPrivilegeGroup.getPrivileges()) {
                this.customObjectPrivilegeGroupMap.computeIfAbsent(objectPrivilegeGroup, pg -> new HashMap()).put(privilege, new HashSet(objectPrivilegeGroup.getPrivilegeObjectsSupplier().get()));
            }
        }
    }

    @Override
    public boolean isAllowed(SimplePrivilege simplePrivilege) {
        if (this.simplePrivileges == null) {
            return false;
        }
        return this.simplePrivileges.contains(simplePrivilege);
    }

    @Override
    public boolean isAllowed(SimpleOrganizationalPrivilege simpleOrganizationalPrivilege, OrganizationUnitView organizationUnitView) {
        if (this.simpleOrganizationalPrivilegeSetMap == null || !this.simpleOrganizationalPrivilegeSetMap.containsKey(simpleOrganizationalPrivilege)) {
            return false;
        }
        return this.simpleOrganizationalPrivilegeSetMap.get(simpleOrganizationalPrivilege).contains(organizationUnitView);
    }

    @Override
    public boolean isAllowed(SimpleCustomObjectPrivilege simpleCustomObjectPrivilege, PrivilegeObject privilegeObject) {
        if (this.simpleCustomObjectPrivilegeSetMap == null || !this.simpleCustomObjectPrivilegeSetMap.containsKey(simpleCustomObjectPrivilege)) {
            return false;
        }
        return this.simpleCustomObjectPrivilegeSetMap.get(simpleCustomObjectPrivilege).contains(privilegeObject);
    }

    @Override
    public boolean isAllowed(StandardPrivilegeGroup standardPrivilegeGroup, Privilege privilege) {
        if (this.standardPrivilegeGroupSetMap == null || !this.standardPrivilegeGroupSetMap.containsKey(standardPrivilegeGroup)) {
            return false;
        }
        return this.standardPrivilegeGroupSetMap.get(standardPrivilegeGroup).contains(privilege);
    }

    @Override
    public boolean isAllowed(OrganizationalPrivilegeGroup organizationalPrivilegeGroup, Privilege privilege, OrganizationUnitView organizationUnitView) {
        if (this.organizationalPrivilegeGroupMap == null || !this.organizationalPrivilegeGroupMap.containsKey(organizationalPrivilegeGroup)) {
            return false;
        }
        Set<OrganizationUnitView> organizationUnitViews = this.organizationalPrivilegeGroupMap.get(organizationalPrivilegeGroup).get(privilege);
        return organizationUnitViews != null && organizationUnitViews.contains(organizationUnitView);
    }

    @Override
    public boolean isAllowed(CustomObjectPrivilegeGroup customObjectPrivilegeGroup, Privilege privilege, PrivilegeObject privilegeObject) {
        if (this.customObjectPrivilegeGroupMap == null || !this.customObjectPrivilegeGroupMap.containsKey(customObjectPrivilegeGroup)) {
            return false;
        }
        Set<PrivilegeObject> privilegeObjects = this.customObjectPrivilegeGroupMap.get(customObjectPrivilegeGroup).get(privilege);
        return privilegeObjects != null && privilegeObjects.contains(privilegeObject);
    }

    @Override
    public boolean isAllowed(RoleAssignmentDelegatedCustomPrivilegeGroup group, Privilege privilege, PrivilegeObject privilegeObject) {
        return false;
    }

    @Override
    public List<OrganizationUnitView> getAllowedUnits(SimpleOrganizationalPrivilege simpleOrganizationalPrivilege) {
        if (this.simpleOrganizationalPrivilegeSetMap == null || !this.simpleOrganizationalPrivilegeSetMap.containsKey(simpleOrganizationalPrivilege)) {
            return Collections.emptyList();
        }
        return new ArrayList<OrganizationUnitView>((Collection)this.simpleOrganizationalPrivilegeSetMap.get(simpleOrganizationalPrivilege));
    }

    @Override
    public List<OrganizationUnitView> getAllowedUnits(OrganizationalPrivilegeGroup organizationalPrivilegeGroup, Privilege privilege) {
        if (this.organizationalPrivilegeGroupMap == null || !this.organizationalPrivilegeGroupMap.containsKey(organizationalPrivilegeGroup)) {
            return Collections.emptyList();
        }
        Set<OrganizationUnitView> organizationUnitViews = this.organizationalPrivilegeGroupMap.get(organizationalPrivilegeGroup).get(privilege);
        return organizationUnitViews != null ? new ArrayList<OrganizationUnitView>(organizationUnitViews) : Collections.emptyList();
    }

    @Override
    public List<PrivilegeObject> getAllowedPrivilegeObjects(SimpleCustomObjectPrivilege simpleCustomObjectPrivilege) {
        if (this.simpleCustomObjectPrivilegeSetMap == null || !this.simpleCustomObjectPrivilegeSetMap.containsKey(simpleCustomObjectPrivilege)) {
            return Collections.emptyList();
        }
        return new ArrayList<PrivilegeObject>((Collection)this.simpleCustomObjectPrivilegeSetMap.get(simpleCustomObjectPrivilege));
    }

    @Override
    public List<PrivilegeObject> getAllowedPrivilegeObjects(CustomObjectPrivilegeGroup customObjectPrivilegeGroup, Privilege privilege) {
        if (this.customObjectPrivilegeGroupMap == null || !this.customObjectPrivilegeGroupMap.containsKey(customObjectPrivilegeGroup)) {
            return Collections.emptyList();
        }
        Set<PrivilegeObject> privilegeObjects = this.customObjectPrivilegeGroupMap.get(customObjectPrivilegeGroup).get(privilege);
        return privilegeObjects != null ? new ArrayList<PrivilegeObject>(privilegeObjects) : Collections.emptyList();
    }

    @Override
    public List<PrivilegeObject> getAllowedPrivilegeObjects(RoleAssignmentDelegatedCustomPrivilegeGroup group, Privilege privilege) {
        return Collections.emptyList();
    }
}

