/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.api.application;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.teamapps.application.api.application.entity.EntityUpdate;
import org.teamapps.application.api.config.ApplicationConfig;
import org.teamapps.application.api.desktop.ApplicationDesktop;
import org.teamapps.application.api.localization.ApplicationLocalizationProvider;
import org.teamapps.application.api.organization.UserRoleType;
import org.teamapps.application.api.privilege.ApplicationPrivilegeProvider;
import org.teamapps.application.api.ui.UiComponentFactory;
import org.teamapps.application.api.user.SessionUser;
import org.teamapps.icons.Icon;
import org.teamapps.model.controlcenter.OrganizationFieldView;
import org.teamapps.model.controlcenter.OrganizationUnitView;
import org.teamapps.reporting.convert.DocumentConverter;
import org.teamapps.universaldb.record.EntityBuilder;
import org.teamapps.ux.application.perspective.Perspective;
import org.teamapps.ux.component.progress.MultiProgressDisplay;
import org.teamapps.ux.session.SessionContext;

public interface ApplicationInstanceData
extends ApplicationPrivilegeProvider,
ApplicationLocalizationProvider {
    public SessionUser getUser();

    public OrganizationFieldView getOrganizationField();

    public int getManagedApplicationId();

    public DocumentConverter getDocumentConverter();

    public MultiProgressDisplay getMultiProgressDisplay();

    default public <RESULT> void runTaskAsync(Icon icon, String title, Supplier<RESULT> task, Consumer<RESULT> uiResultTask) {
        SessionContext context = SessionContext.current();
        MultiProgressDisplay multiProgressDisplay = this.getMultiProgressDisplay();
        multiProgressDisplay.addTask(icon, title, progressMonitor -> {
            Object result = task.get();
            progressMonitor.markCompleted();
            if (uiResultTask != null) {
                context.runWithContext(() -> uiResultTask.accept(result));
            }
        });
    }

    public void showPerspective(Perspective var1);

    public ApplicationDesktop createApplicationDesktop();

    public UiComponentFactory getComponentFactory();

    public boolean isDarkTheme();

    public ApplicationConfig<?> getApplicationConfig();

    public void writeActivityLog(String var1, String var2);

    public void writeExceptionLog(String var1, Throwable var2);

    public Integer getOrganizationUserWithRole(OrganizationUnitView var1, UserRoleType var2);

    public String getOrganizationUserNameWithRole(OrganizationUnitView var1, UserRoleType var2, boolean var3);

    public List<Integer> getOrganizationUsersWithRole(OrganizationUnitView var1, UserRoleType var2);

    public <ENTITY> void registerEntity(EntityBuilder<ENTITY> var1, Consumer<EntityUpdate<ENTITY>> var2);
}

