/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.ux.combo;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.teamapps.data.extract.PropertyProvider;
import org.teamapps.ux.component.field.combobox.ComboBox;
import org.teamapps.ux.component.template.Template;

public class RecordComboBox<RECORD>
extends ComboBox<RECORD> {
    private final PropertyProvider<RECORD> propertyProvider;
    private final Function<RECORD, String> recordToStringFunction;
    private final Function<RECORD, String> recordToStringSearchFunction;

    public RecordComboBox(PropertyProvider<RECORD> propertyProvider, Template template) {
        super(template);
        this.propertyProvider = propertyProvider;
        this.setPropertyProvider(propertyProvider);
        this.recordToStringFunction = record -> (String)propertyProvider.getValues(record, null).get("caption");
        this.recordToStringSearchFunction = record -> {
            String value = (String)propertyProvider.getValues(record, null).get("caption");
            String value2 = (String)propertyProvider.getValues(record, null).get("description");
            String value3 = (String)propertyProvider.getValues(record, null).get("badge");
            return (value != null ? value : "") + (value2 != null ? value2 : "") + (value3 != null ? value3 : "");
        };
        this.setRecordToStringFunction(this.recordToStringFunction);
    }

    public void setRecords(List<RECORD> records) {
        this.setModel(query -> query == null || query.isBlank() ? records : records.stream().filter(record -> this.recordToStringSearchFunction.apply(record).toLowerCase().contains(query.toLowerCase())).collect(Collectors.toList()));
    }
}

