/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.api.privilege;

import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.teamapps.application.api.privilege.CustomObjectPrivilegeGroup;
import org.teamapps.application.api.privilege.CustomObjectPrivilegeGroupImpl;
import org.teamapps.application.api.privilege.OrganizationalPrivilegeGroup;
import org.teamapps.application.api.privilege.OrganizationalPrivilegeGroupImpl;
import org.teamapps.application.api.privilege.Privilege;
import org.teamapps.application.api.privilege.PrivilegeGroupType;
import org.teamapps.application.api.privilege.PrivilegeObject;
import org.teamapps.application.api.privilege.RoleAssignmentDelegatedCustomPrivilegeGroup;
import org.teamapps.application.api.privilege.RoleAssignmentDelegatedCustomPrivilegeGroupImpl;
import org.teamapps.application.api.privilege.SimpleCustomObjectPrivilege;
import org.teamapps.application.api.privilege.SimpleCustomObjectPrivilegeImpl;
import org.teamapps.application.api.privilege.SimpleOrganizationalPrivilege;
import org.teamapps.application.api.privilege.SimpleOrganizationalPrivilegeImpl;
import org.teamapps.application.api.privilege.SimplePrivilege;
import org.teamapps.application.api.privilege.SimplePrivilegeImpl;
import org.teamapps.application.api.privilege.StandardPrivilegeGroup;
import org.teamapps.application.api.privilege.StandardPrivilegeGroupImpl;
import org.teamapps.icons.Icon;

public interface PrivilegeGroup {
    public static SimplePrivilege createSimplePrivilege(String name, Icon icon, String titleKey, String descriptionKey) {
        return new SimplePrivilegeImpl(name, icon, titleKey, descriptionKey);
    }

    public static SimpleOrganizationalPrivilege createSimpleOrganizationalPrivilege(String name, Icon icon, String titleKey, String descriptionKey) {
        return new SimpleOrganizationalPrivilegeImpl(name, icon, titleKey, descriptionKey);
    }

    public static SimpleCustomObjectPrivilege createSimpleCustomObjectPrivilege(String name, Icon icon, String titleKey, String descriptionKey, Supplier<List<PrivilegeObject>> privilegeObjectsSupplier) {
        return new SimpleCustomObjectPrivilegeImpl(name, icon, titleKey, descriptionKey, privilegeObjectsSupplier);
    }

    public static StandardPrivilegeGroup createStandardPrivilegeGroup(String name, Icon icon, String titleKey, String descriptionKey, Privilege ... privileges) {
        return new StandardPrivilegeGroupImpl(name, icon, titleKey, descriptionKey, privileges);
    }

    public static OrganizationalPrivilegeGroup createOrganizationalPrivilegeGroup(String name, Icon icon, String titleKey, String descriptionKey, Privilege ... privileges) {
        return new OrganizationalPrivilegeGroupImpl(name, icon, titleKey, descriptionKey, privileges);
    }

    public static CustomObjectPrivilegeGroup createCustomObjectPrivilegeGroup(String name, Icon icon, String titleKey, String descriptionKey, List<Privilege> privileges, Supplier<List<PrivilegeObject>> privilegeObjectsSupplier) {
        return new CustomObjectPrivilegeGroupImpl(name, icon, titleKey, descriptionKey, privileges, privilegeObjectsSupplier);
    }

    public static RoleAssignmentDelegatedCustomPrivilegeGroup createDelegatedCustomPrivilegeGroup(String name, Icon icon, String titleKey, String descriptionKey, Function<Integer, PrivilegeObject> privilegeObjectByIdFunction, Privilege ... privileges) {
        return new RoleAssignmentDelegatedCustomPrivilegeGroupImpl(name, icon, titleKey, descriptionKey, privilegeObjectByIdFunction, privileges);
    }

    public static PrivilegeGroup mergeGroups(PrivilegeGroup groupA, PrivilegeGroup groupB) {
        if (groupA.getType() != groupB.getType()) {
            throw new RuntimeException("Cannot merge privilege groups of different type:" + groupA);
        }
        List<Privilege> privileges = groupA.getPrivileges();
        HashSet<Privilege> privilegeSet = new HashSet<Privilege>(privileges);
        groupB.getPrivileges().stream().filter(p -> !privilegeSet.contains(p)).forEach(privileges::add);
        return groupA.createCopyWithPrivileges(privileges.toArray(new Privilege[0]));
    }

    public PrivilegeGroup createCopyWithPrivileges(Privilege ... var1);

    public PrivilegeGroupType getType();

    public String getName();

    public Icon getIcon();

    public String getTitleKey();

    public String getDescriptionKey();

    public List<Privilege> getPrivileges();

    public Supplier<List<PrivilegeObject>> getPrivilegeObjectsSupplier();
}

