package org.teamapps.mock.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.query.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


public class UdbAddressQuery extends AbstractUdbQuery<Address> implements AddressQuery {

    public UdbAddressQuery() {
        super(UdbAddress.table, Address.getBuilder());
    }

    @Override
    public AddressQuery id(Integer... ids) {
        return id(Arrays.asList(ids));
    }

    @Override
    public AddressQuery id(BitSet ids) {
        filterById(ids);
        return this;
    }

    @Override
    public AddressQuery id(Collection<Integer> ids) {
        filterById(ids);
        return this;
    }

	@Override
	public AddressQuery fullTextFilter(TextFilter textFilter, String... fieldNames) {
    	and(UdbAddress.table.createFullTextFilter(textFilter, fieldNames));
		return this;
	}

	@Override
	public AddressQuery parseFullTextFilter(String query, String... fieldNames) {
    	and(UdbAddress.table.createFullTextFilter(query, fieldNames));
		return this;
	}

	@Override
	public AddressQuery metaCreationDate(NumericFilter filter) {
		and(UdbAddress.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public AddressQuery orMetaCreationDate(NumericFilter filter) {
		or(UdbAddress.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public AddressQuery metaCreatedBy(NumericFilter filter) {
		and(UdbAddress.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public AddressQuery orMetaCreatedBy(NumericFilter filter) {
		or(UdbAddress.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public AddressQuery metaModificationDate(NumericFilter filter) {
		and(UdbAddress.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public AddressQuery orMetaModificationDate(NumericFilter filter) {
		or(UdbAddress.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public AddressQuery metaModifiedBy(NumericFilter filter) {
		and(UdbAddress.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public AddressQuery orMetaModifiedBy(NumericFilter filter) {
		or(UdbAddress.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public AddressQuery metaDeletionDate(NumericFilter filter) {
		and(UdbAddress.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public AddressQuery orMetaDeletionDate(NumericFilter filter) {
		or(UdbAddress.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public AddressQuery metaDeletedBy(NumericFilter filter) {
		and(UdbAddress.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public AddressQuery orMetaDeletedBy(NumericFilter filter) {
		or(UdbAddress.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public AddressQuery metaRestoreDate(NumericFilter filter) {
		and(UdbAddress.metaRestoreDate.createFilter(filter));
		return this;
	}

	@Override
	public AddressQuery orMetaRestoreDate(NumericFilter filter) {
		or(UdbAddress.metaRestoreDate.createFilter(filter));
		return this;
	}

	@Override
	public AddressQuery metaRestoredBy(NumericFilter filter) {
		and(UdbAddress.metaRestoredBy.createFilter(filter));
		return this;
	}

	@Override
	public AddressQuery orMetaRestoredBy(NumericFilter filter) {
		or(UdbAddress.metaRestoredBy.createFilter(filter));
		return this;
	}

	@Override
	public AddressQuery name(TextFilter filter) {
		and(UdbAddress.name.createFilter(filter));
		return this;
	}

	@Override
	public AddressQuery orName(TextFilter filter) {
		or(UdbAddress.name.createFilter(filter));
		return this;
	}

	@Override
	public AddressQuery organisation(TextFilter filter) {
		and(UdbAddress.organisation.createFilter(filter));
		return this;
	}

	@Override
	public AddressQuery orOrganisation(TextFilter filter) {
		or(UdbAddress.organisation.createFilter(filter));
		return this;
	}

	@Override
	public AddressQuery street(TextFilter filter) {
		and(UdbAddress.street.createFilter(filter));
		return this;
	}

	@Override
	public AddressQuery orStreet(TextFilter filter) {
		or(UdbAddress.street.createFilter(filter));
		return this;
	}

	@Override
	public AddressQuery city(TextFilter filter) {
		and(UdbAddress.city.createFilter(filter));
		return this;
	}

	@Override
	public AddressQuery orCity(TextFilter filter) {
		or(UdbAddress.city.createFilter(filter));
		return this;
	}

	@Override
	public AddressQuery dependentLocality(TextFilter filter) {
		and(UdbAddress.dependentLocality.createFilter(filter));
		return this;
	}

	@Override
	public AddressQuery orDependentLocality(TextFilter filter) {
		or(UdbAddress.dependentLocality.createFilter(filter));
		return this;
	}

	@Override
	public AddressQuery state(TextFilter filter) {
		and(UdbAddress.state.createFilter(filter));
		return this;
	}

	@Override
	public AddressQuery orState(TextFilter filter) {
		or(UdbAddress.state.createFilter(filter));
		return this;
	}

	@Override
	public AddressQuery postalCode(TextFilter filter) {
		and(UdbAddress.postalCode.createFilter(filter));
		return this;
	}

	@Override
	public AddressQuery orPostalCode(TextFilter filter) {
		or(UdbAddress.postalCode.createFilter(filter));
		return this;
	}

	@Override
	public AddressQuery country(TextFilter filter) {
		and(UdbAddress.country.createFilter(filter));
		return this;
	}

	@Override
	public AddressQuery orCountry(TextFilter filter) {
		or(UdbAddress.country.createFilter(filter));
		return this;
	}

	@Override
	public AddressQuery latitude(NumericFilter filter) {
		and(UdbAddress.latitude.createFilter(filter));
		return this;
	}

	@Override
	public AddressQuery orLatitude(NumericFilter filter) {
		or(UdbAddress.latitude.createFilter(filter));
		return this;
	}

	@Override
	public AddressQuery longitude(NumericFilter filter) {
		and(UdbAddress.longitude.createFilter(filter));
		return this;
	}

	@Override
	public AddressQuery orLongitude(NumericFilter filter) {
		or(UdbAddress.longitude.createFilter(filter));
		return this;
	}


	@Override
	public UdbAddressQuery andOr(AddressQuery ... queries) {
	    AbstractUdbQuery[] abstractUdbQueries = Arrays.copyOf(queries, queries.length, AbstractUdbQuery[].class);
		andOr(abstractUdbQueries);
		return this;
	}

    @Override
    public AddressQuery customFilter(Function<Address, Boolean> customFilter) {
        Function<Integer, Boolean> filterFunction = id -> {
            return customFilter.apply(Address.getById(id));
        };
        and(new CustomEntityFilter(filterFunction));
        return this;
    }

}



