package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.query.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


public class UdbOrganizationFieldViewQuery extends AbstractUdbQuery<OrganizationFieldView> implements OrganizationFieldViewQuery {

    public UdbOrganizationFieldViewQuery() {
        super(UdbOrganizationFieldView.table, OrganizationFieldView.getBuilder());
    }

    @Override
    public OrganizationFieldViewQuery id(Integer... ids) {
        return id(Arrays.asList(ids));
    }

    @Override
    public OrganizationFieldViewQuery id(BitSet ids) {
        filterById(ids);
        return this;
    }

    @Override
    public OrganizationFieldViewQuery id(Collection<Integer> ids) {
        filterById(ids);
        return this;
    }

	@Override
	public OrganizationFieldViewQuery fullTextFilter(TextFilter textFilter, String... fieldNames) {
    	and(UdbOrganizationFieldView.table.createFullTextFilter(textFilter, fieldNames));
		return this;
	}

	@Override
	public OrganizationFieldViewQuery parseFullTextFilter(String query, String... fieldNames) {
    	and(UdbOrganizationFieldView.table.createFullTextFilter(query, fieldNames));
		return this;
	}

	@Override
	public OrganizationFieldViewQuery title(TranslatableTextFilter filter) {
		and(UdbOrganizationFieldView.title.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationFieldViewQuery orTitle(TranslatableTextFilter filter) {
		or(UdbOrganizationFieldView.title.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationFieldViewQuery icon(TextFilter filter) {
		and(UdbOrganizationFieldView.icon.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationFieldViewQuery orIcon(TextFilter filter) {
		or(UdbOrganizationFieldView.icon.createFilter(filter));
		return this;
	}


	@Override
	public UdbOrganizationFieldViewQuery andOr(OrganizationFieldViewQuery ... queries) {
	    AbstractUdbQuery[] abstractUdbQueries = Arrays.copyOf(queries, queries.length, AbstractUdbQuery[].class);
		andOr(abstractUdbQueries);
		return this;
	}

    @Override
    public OrganizationFieldViewQuery customFilter(Function<OrganizationFieldView, Boolean> customFilter) {
        Function<Integer, Boolean> filterFunction = id -> {
            return customFilter.apply(OrganizationFieldView.getById(id));
        };
        and(new CustomEntityFilter(filterFunction));
        return this;
    }

}



