package org.teamapps.mock.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.time.*;
import java.io.*;
import java.util.concurrent.*;
import java.util.function.Supplier;


public class UdbOrganizationUnit extends AbstractUdbEntity<OrganizationUnit> implements OrganizationUnit {
	protected static TableIndex table;
	protected static IntegerIndex metaCreationDate;
	protected static IntegerIndex metaCreatedBy;
	protected static IntegerIndex metaModificationDate;
	protected static IntegerIndex metaModifiedBy;
	protected static IntegerIndex metaDeletionDate;
	protected static IntegerIndex metaDeletedBy;
	protected static IntegerIndex metaRestoreDate;
	protected static IntegerIndex metaRestoredBy;
	protected static TranslatableTextIndex name;
	protected static SingleReferenceIndex parent;
	protected static MultiReferenceIndex children;
	protected static SingleReferenceIndex type;
	protected static TextIndex icon;
	protected static SingleReferenceIndex address;

    private static void setTableIndex(TableIndex tableIndex) {
        table = tableIndex;
		metaCreationDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_CREATION_DATE);
		metaCreatedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_CREATED_BY);
		metaModificationDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_MODIFICATION_DATE);
		metaModifiedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_MODIFIED_BY);
		metaDeletionDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_DELETION_DATE);
		metaDeletedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_DELETED_BY);
		metaRestoreDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_RESTORE_DATE);
		metaRestoredBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_RESTORED_BY);
		name = (TranslatableTextIndex) tableIndex.getColumnIndex(FIELD_NAME);
		parent = (SingleReferenceIndex) tableIndex.getColumnIndex(FIELD_PARENT);
		children = (MultiReferenceIndex) tableIndex.getColumnIndex(FIELD_CHILDREN);
		type = (SingleReferenceIndex) tableIndex.getColumnIndex(FIELD_TYPE);
		icon = (TextIndex) tableIndex.getColumnIndex(FIELD_ICON);
		address = (SingleReferenceIndex) tableIndex.getColumnIndex(FIELD_ADDRESS);
    }

    public static List<OrganizationUnit> getAll() {
        return new EntityBitSetList<>(OrganizationUnit.getBuilder(), table.getRecordBitSet());
    }

    public static List<OrganizationUnit> getDeletedRecords() {
        return new EntityBitSetList<>(OrganizationUnit.getBuilder(), table.getDeletedRecordsBitSet());
    }

    public static List<OrganizationUnit> sort(List<OrganizationUnit> list, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
    	return sort(table, list, sortFieldName, ascending, userContext, path);
    }

    public static List<OrganizationUnit> sort(BitSet recordIds, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
        return sort(table, OrganizationUnit.getBuilder(), recordIds, sortFieldName, ascending, userContext, path);
    }

    public static int getCount() {
        return table.getCount();
    }

    public UdbOrganizationUnit() {
        super(table);
    }

    public UdbOrganizationUnit(int id, boolean createEntity) {
        super(table, id, createEntity);
    }

    @Override
    public OrganizationUnit build() {
        return new UdbOrganizationUnit();
    }

    @Override
    public OrganizationUnit build(int id) {
        return new UdbOrganizationUnit(id, false);
    }

	@Override
	public Instant getMetaCreationDate() {
	    return getTimestampValue(metaCreationDate);
	}

	@Override
	public OrganizationUnit setMetaCreationDate(Instant value) {
	    setTimestampValue(value, this.metaCreationDate);
		return this;
	}

	@Override
	public int getMetaCreationDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaCreationDate);
	}

	@Override
	public OrganizationUnit setMetaCreationDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaCreationDate);
		return this;
	}

	@Override
	public long getMetaCreationDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaCreationDate);
	}

	@Override
	public OrganizationUnit setMetaCreationDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaCreationDate);
		return this;
	}

	@Override
	public int getMetaCreatedBy() {
        return getIntValue(metaCreatedBy);
	}

	@Override
	public OrganizationUnit setMetaCreatedBy(int value) {
	    setIntValue(value, this.metaCreatedBy);
		return this;
	}

	@Override
	public Instant getMetaModificationDate() {
	    return getTimestampValue(metaModificationDate);
	}

	@Override
	public OrganizationUnit setMetaModificationDate(Instant value) {
	    setTimestampValue(value, this.metaModificationDate);
		return this;
	}

	@Override
	public int getMetaModificationDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaModificationDate);
	}

	@Override
	public OrganizationUnit setMetaModificationDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaModificationDate);
		return this;
	}

	@Override
	public long getMetaModificationDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaModificationDate);
	}

	@Override
	public OrganizationUnit setMetaModificationDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaModificationDate);
		return this;
	}

	@Override
	public int getMetaModifiedBy() {
        return getIntValue(metaModifiedBy);
	}

	@Override
	public OrganizationUnit setMetaModifiedBy(int value) {
	    setIntValue(value, this.metaModifiedBy);
		return this;
	}

	@Override
	public Instant getMetaDeletionDate() {
	    return getTimestampValue(metaDeletionDate);
	}

	@Override
	public OrganizationUnit setMetaDeletionDate(Instant value) {
	    setTimestampValue(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public int getMetaDeletionDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaDeletionDate);
	}

	@Override
	public OrganizationUnit setMetaDeletionDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public long getMetaDeletionDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaDeletionDate);
	}

	@Override
	public OrganizationUnit setMetaDeletionDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public int getMetaDeletedBy() {
        return getIntValue(metaDeletedBy);
	}

	@Override
	public OrganizationUnit setMetaDeletedBy(int value) {
	    setIntValue(value, this.metaDeletedBy);
		return this;
	}

	@Override
	public Instant getMetaRestoreDate() {
	    return getTimestampValue(metaRestoreDate);
	}

	@Override
	public OrganizationUnit setMetaRestoreDate(Instant value) {
	    setTimestampValue(value, this.metaRestoreDate);
		return this;
	}

	@Override
	public int getMetaRestoreDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaRestoreDate);
	}

	@Override
	public OrganizationUnit setMetaRestoreDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaRestoreDate);
		return this;
	}

	@Override
	public long getMetaRestoreDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaRestoreDate);
	}

	@Override
	public OrganizationUnit setMetaRestoreDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaRestoreDate);
		return this;
	}

	@Override
	public int getMetaRestoredBy() {
        return getIntValue(metaRestoredBy);
	}

	@Override
	public OrganizationUnit setMetaRestoredBy(int value) {
	    setIntValue(value, this.metaRestoredBy);
		return this;
	}

	@Override
	public TranslatableText getName() {
	    return getTranslatableTextValue(this.name);
	}

	@Override
	public OrganizationUnit setName(TranslatableText value) {
    	setTranslatableTextValue(value, this.name);
		return this;
	}

	@Override
	public OrganizationUnit getParent() {
		if (isChanged(parent)) {
			return (OrganizationUnit) getReferenceChangeValue(parent);
		} else {
			int id = parent.getValue(getId());
			if (id > 0) {
				return OrganizationUnit.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public OrganizationUnit setParent(OrganizationUnit value) {
		setSingleReferenceValue(parent, value, table);
		return this;
	}

	@Override
	public List<OrganizationUnit> getChildren() {
	    return getMultiReferenceValue(children, OrganizationUnit.getBuilder());
	}

	@Override
	public OrganizationUnit setChildren(List<OrganizationUnit> value) {
		setMultiReferenceValue(value, children);
		return this;
	}

	@Override
	public int getChildrenCount() {
	    return getMultiReferenceValueCount(children, OrganizationUnit.getBuilder());
	}

	@Override
	public OrganizationUnit setChildren(OrganizationUnit ... value) {
		setMultiReferenceValue(Arrays.asList(value), children);
		return this;
	}

	@Override
	public BitSet getChildrenAsBitSet() {
	    return getMultiReferenceValueAsBitSet(children, OrganizationUnit.getBuilder());
	}

	@Override
	public OrganizationUnit addChildren(List<OrganizationUnit> value) {
		addMultiReferenceValue(value, children);
		return this;
	}

	@Override
	public OrganizationUnit addChildren(OrganizationUnit ... value) {
		addMultiReferenceValue(Arrays.asList(value), children);
		return this;
	}

	@Override
	public OrganizationUnit removeChildren(List<OrganizationUnit> value) {
		removeMultiReferenceValue(value, children);
		return this;
	}

	@Override
	public OrganizationUnit removeChildren(OrganizationUnit ... value) {
		removeMultiReferenceValue(Arrays.asList(value), children);
		return this;
	}

	@Override
	public OrganizationUnit removeAllChildren() {
		removeAllMultiReferenceValue(children);
		return this;
	}

	@Override
	public OrganizationUnitType getType() {
		if (isChanged(type)) {
			return (OrganizationUnitType) getReferenceChangeValue(type);
		} else {
			int id = type.getValue(getId());
			if (id > 0) {
				return OrganizationUnitType.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public OrganizationUnit setType(OrganizationUnitType value) {
		setSingleReferenceValue(type, value, table);
		return this;
	}

	@Override
	public String getIcon() {
        return getTextValue(icon);
	}

	@Override
	public OrganizationUnit setIcon(String value) {
	    setTextValue(value, this.icon);
		return this;
	}

	@Override
	public Address getAddress() {
		if (isChanged(address)) {
			return (Address) getReferenceChangeValue(address);
		} else {
			int id = address.getValue(getId());
			if (id > 0) {
				return Address.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public OrganizationUnit setAddress(Address value) {
		setSingleReferenceValue(address, value, table);
		return this;
	}



    @Override
    public UdbOrganizationUnit save() {
        saveRecord();
        return this;
    }

    @Override
    public void delete() {
        deleteRecord();
    }

    @Override
    public void restoreDeleted() {
        restoreDeletedRecord();
    }
}



